/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the result of a successful invocation of the <code>DescribeDBSecurityGroups</code> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDbSecurityGroupsResponse extends RdsResponse implements
        ToCopyableBuilder<DescribeDbSecurityGroupsResponse.Builder, DescribeDbSecurityGroupsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeDbSecurityGroupsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<List<DBSecurityGroup>> DB_SECURITY_GROUPS_FIELD = SdkField
            .<List<DBSecurityGroup>> builder(MarshallingType.LIST)
            .memberName("DBSecurityGroups")
            .getter(getter(DescribeDbSecurityGroupsResponse::dbSecurityGroups))
            .setter(setter(Builder::dbSecurityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSecurityGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("DBSecurityGroup")
                            .memberFieldInfo(
                                    SdkField.<DBSecurityGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(DBSecurityGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("DBSecurityGroup").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD,
            DB_SECURITY_GROUPS_FIELD));

    private final String marker;

    private final List<DBSecurityGroup> dbSecurityGroups;

    private DescribeDbSecurityGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.dbSecurityGroups = builder.dbSecurityGroups;
    }

    /**
     * <p>
     * An optional pagination token provided by a previous request. If this parameter is specified, the response
     * includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
     * </p>
     * 
     * @return An optional pagination token provided by a previous request. If this parameter is specified, the response
     *         includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
     */
    public final String marker() {
        return marker;
    }

    /**
     * Returns true if the DBSecurityGroups property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasDbSecurityGroups() {
        return dbSecurityGroups != null && !(dbSecurityGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>DBSecurityGroup</code> instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDbSecurityGroups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of <code>DBSecurityGroup</code> instances.
     */
    public final List<DBSecurityGroup> dbSecurityGroups() {
        return dbSecurityGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(hasDbSecurityGroups() ? dbSecurityGroups() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDbSecurityGroupsResponse)) {
            return false;
        }
        DescribeDbSecurityGroupsResponse other = (DescribeDbSecurityGroupsResponse) obj;
        return Objects.equals(marker(), other.marker()) && hasDbSecurityGroups() == other.hasDbSecurityGroups()
                && Objects.equals(dbSecurityGroups(), other.dbSecurityGroups());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDbSecurityGroupsResponse").add("Marker", marker())
                .add("DBSecurityGroups", hasDbSecurityGroups() ? dbSecurityGroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "DBSecurityGroups":
            return Optional.ofNullable(clazz.cast(dbSecurityGroups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDbSecurityGroupsResponse, T> g) {
        return obj -> g.apply((DescribeDbSecurityGroupsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeDbSecurityGroupsResponse> {
        /**
         * <p>
         * An optional pagination token provided by a previous request. If this parameter is specified, the response
         * includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
         * </p>
         * 
         * @param marker
         *        An optional pagination token provided by a previous request. If this parameter is specified, the
         *        response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * A list of <code>DBSecurityGroup</code> instances.
         * </p>
         * 
         * @param dbSecurityGroups
         *        A list of <code>DBSecurityGroup</code> instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbSecurityGroups(Collection<DBSecurityGroup> dbSecurityGroups);

        /**
         * <p>
         * A list of <code>DBSecurityGroup</code> instances.
         * </p>
         * 
         * @param dbSecurityGroups
         *        A list of <code>DBSecurityGroup</code> instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbSecurityGroups(DBSecurityGroup... dbSecurityGroups);

        /**
         * <p>
         * A list of <code>DBSecurityGroup</code> instances.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DBSecurityGroup>.Builder} avoiding the need
         * to create one manually via {@link List<DBSecurityGroup>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DBSecurityGroup>.Builder#build()} is called immediately and
         * its result is passed to {@link #dbSecurityGroups(List<DBSecurityGroup>)}.
         * 
         * @param dbSecurityGroups
         *        a consumer that will call methods on {@link List<DBSecurityGroup>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dbSecurityGroups(List<DBSecurityGroup>)
         */
        Builder dbSecurityGroups(Consumer<DBSecurityGroup.Builder>... dbSecurityGroups);
    }

    static final class BuilderImpl extends RdsResponse.BuilderImpl implements Builder {
        private String marker;

        private List<DBSecurityGroup> dbSecurityGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDbSecurityGroupsResponse model) {
            super(model);
            marker(model.marker);
            dbSecurityGroups(model.dbSecurityGroups);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final List<DBSecurityGroup.Builder> getDbSecurityGroups() {
            List<DBSecurityGroup.Builder> result = DBSecurityGroupsCopier.copyToBuilder(this.dbSecurityGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder dbSecurityGroups(Collection<DBSecurityGroup> dbSecurityGroups) {
            this.dbSecurityGroups = DBSecurityGroupsCopier.copy(dbSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbSecurityGroups(DBSecurityGroup... dbSecurityGroups) {
            dbSecurityGroups(Arrays.asList(dbSecurityGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbSecurityGroups(Consumer<DBSecurityGroup.Builder>... dbSecurityGroups) {
            dbSecurityGroups(Stream.of(dbSecurityGroups).map(c -> DBSecurityGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDbSecurityGroups(Collection<DBSecurityGroup.BuilderImpl> dbSecurityGroups) {
            this.dbSecurityGroups = DBSecurityGroupsCopier.copyFromBuilder(dbSecurityGroups);
        }

        @Override
        public DescribeDbSecurityGroupsResponse build() {
            return new DescribeDbSecurityGroupsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
