/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDbEngineVersionsRequest extends RdsRequest implements
        ToCopyableBuilder<DescribeDbEngineVersionsRequest.Builder, DescribeDbEngineVersionsRequest> {
    private static final SdkField<String> ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Engine")
            .getter(getter(DescribeDbEngineVersionsRequest::engine)).setter(setter(Builder::engine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineVersion").getter(getter(DescribeDbEngineVersionsRequest::engineVersion))
            .setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<String> DB_PARAMETER_GROUP_FAMILY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBParameterGroupFamily").getter(getter(DescribeDbEngineVersionsRequest::dbParameterGroupFamily))
            .setter(setter(Builder::dbParameterGroupFamily))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBParameterGroupFamily").build())
            .build();

    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(DescribeDbEngineVersionsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Filter")
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Filter").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RECORDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxRecords").getter(getter(DescribeDbEngineVersionsRequest::maxRecords))
            .setter(setter(Builder::maxRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecords").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeDbEngineVersionsRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<Boolean> DEFAULT_ONLY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DefaultOnly").getter(getter(DescribeDbEngineVersionsRequest::defaultOnly))
            .setter(setter(Builder::defaultOnly))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultOnly").build()).build();

    private static final SdkField<Boolean> LIST_SUPPORTED_CHARACTER_SETS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ListSupportedCharacterSets")
            .getter(getter(DescribeDbEngineVersionsRequest::listSupportedCharacterSets))
            .setter(setter(Builder::listSupportedCharacterSets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListSupportedCharacterSets").build())
            .build();

    private static final SdkField<Boolean> LIST_SUPPORTED_TIMEZONES_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ListSupportedTimezones").getter(getter(DescribeDbEngineVersionsRequest::listSupportedTimezones))
            .setter(setter(Builder::listSupportedTimezones))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListSupportedTimezones").build())
            .build();

    private static final SdkField<Boolean> INCLUDE_ALL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IncludeAll").getter(getter(DescribeDbEngineVersionsRequest::includeAll))
            .setter(setter(Builder::includeAll))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeAll").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENGINE_FIELD,
            ENGINE_VERSION_FIELD, DB_PARAMETER_GROUP_FAMILY_FIELD, FILTERS_FIELD, MAX_RECORDS_FIELD, MARKER_FIELD,
            DEFAULT_ONLY_FIELD, LIST_SUPPORTED_CHARACTER_SETS_FIELD, LIST_SUPPORTED_TIMEZONES_FIELD, INCLUDE_ALL_FIELD));

    private final String engine;

    private final String engineVersion;

    private final String dbParameterGroupFamily;

    private final List<Filter> filters;

    private final Integer maxRecords;

    private final String marker;

    private final Boolean defaultOnly;

    private final Boolean listSupportedCharacterSets;

    private final Boolean listSupportedTimezones;

    private final Boolean includeAll;

    private DescribeDbEngineVersionsRequest(BuilderImpl builder) {
        super(builder);
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.dbParameterGroupFamily = builder.dbParameterGroupFamily;
        this.filters = builder.filters;
        this.maxRecords = builder.maxRecords;
        this.marker = builder.marker;
        this.defaultOnly = builder.defaultOnly;
        this.listSupportedCharacterSets = builder.listSupportedCharacterSets;
        this.listSupportedTimezones = builder.listSupportedTimezones;
        this.includeAll = builder.includeAll;
    }

    /**
     * <p>
     * The database engine to return.
     * </p>
     * <p>
     * Valid Values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>aurora</code> (for MySQL 5.6-compatible Aurora)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>aurora-mysql</code> (for MySQL 5.7-compatible Aurora)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>aurora-postgresql</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>mariadb</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>mysql</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>oracle-ee</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>oracle-ee-cdb</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>oracle-se2</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>oracle-se2-cdb</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>postgres</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sqlserver-ee</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sqlserver-se</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sqlserver-ex</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sqlserver-web</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The database engine to return.</p>
     *         <p>
     *         Valid Values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>aurora</code> (for MySQL 5.6-compatible Aurora)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>aurora-mysql</code> (for MySQL 5.7-compatible Aurora)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>aurora-postgresql</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>mariadb</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>mysql</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>oracle-ee</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>oracle-ee-cdb</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>oracle-se2</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>oracle-se2-cdb</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>postgres</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sqlserver-ee</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sqlserver-se</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sqlserver-ex</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sqlserver-web</code>
     *         </p>
     *         </li>
     */
    public final String engine() {
        return engine;
    }

    /**
     * <p>
     * The database engine version to return.
     * </p>
     * <p>
     * Example: <code>5.1.49</code>
     * </p>
     * 
     * @return The database engine version to return.</p>
     *         <p>
     *         Example: <code>5.1.49</code>
     */
    public final String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * The name of a specific DB parameter group family to return details for.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If supplied, must match an existing DBParameterGroupFamily.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of a specific DB parameter group family to return details for.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If supplied, must match an existing DBParameterGroupFamily.
     *         </p>
     *         </li>
     */
    public final String dbParameterGroupFamily() {
        return dbParameterGroupFamily;
    }

    /**
     * Returns true if the Filters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * This parameter isn't currently supported.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFilters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return This parameter isn't currently supported.
     */
    public final List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * The maximum number of records to include in the response. If more than the <code>MaxRecords</code> value is
     * available, a pagination token called a marker is included in the response so you can retrieve the remaining
     * results.
     * </p>
     * <p>
     * Default: 100
     * </p>
     * <p>
     * Constraints: Minimum 20, maximum 100.
     * </p>
     * 
     * @return The maximum number of records to include in the response. If more than the <code>MaxRecords</code> value
     *         is available, a pagination token called a marker is included in the response so you can retrieve the
     *         remaining results. </p>
     *         <p>
     *         Default: 100
     *         </p>
     *         <p>
     *         Constraints: Minimum 20, maximum 100.
     */
    public final Integer maxRecords() {
        return maxRecords;
    }

    /**
     * <p>
     * An optional pagination token provided by a previous request. If this parameter is specified, the response
     * includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
     * </p>
     * 
     * @return An optional pagination token provided by a previous request. If this parameter is specified, the response
     *         includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
     */
    public final String marker() {
        return marker;
    }

    /**
     * <p>
     * A value that indicates whether only the default version of the specified engine or engine and major version
     * combination is returned.
     * </p>
     * 
     * @return A value that indicates whether only the default version of the specified engine or engine and major
     *         version combination is returned.
     */
    public final Boolean defaultOnly() {
        return defaultOnly;
    }

    /**
     * <p>
     * A value that indicates whether to list the supported character sets for each engine version.
     * </p>
     * <p>
     * If this parameter is enabled and the requested engine supports the <code>CharacterSetName</code> parameter for
     * <code>CreateDBInstance</code>, the response includes a list of supported character sets for each engine version.
     * </p>
     * 
     * @return A value that indicates whether to list the supported character sets for each engine version.</p>
     *         <p>
     *         If this parameter is enabled and the requested engine supports the <code>CharacterSetName</code>
     *         parameter for <code>CreateDBInstance</code>, the response includes a list of supported character sets for
     *         each engine version.
     */
    public final Boolean listSupportedCharacterSets() {
        return listSupportedCharacterSets;
    }

    /**
     * <p>
     * A value that indicates whether to list the supported time zones for each engine version.
     * </p>
     * <p>
     * If this parameter is enabled and the requested engine supports the <code>TimeZone</code> parameter for
     * <code>CreateDBInstance</code>, the response includes a list of supported time zones for each engine version.
     * </p>
     * 
     * @return A value that indicates whether to list the supported time zones for each engine version.</p>
     *         <p>
     *         If this parameter is enabled and the requested engine supports the <code>TimeZone</code> parameter for
     *         <code>CreateDBInstance</code>, the response includes a list of supported time zones for each engine
     *         version.
     */
    public final Boolean listSupportedTimezones() {
        return listSupportedTimezones;
    }

    /**
     * <p>
     * A value that indicates whether to include engine versions that aren't available in the list. The default is to
     * list only available engine versions.
     * </p>
     * 
     * @return A value that indicates whether to include engine versions that aren't available in the list. The default
     *         is to list only available engine versions.
     */
    public final Boolean includeAll() {
        return includeAll;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(engine());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(dbParameterGroupFamily());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(defaultOnly());
        hashCode = 31 * hashCode + Objects.hashCode(listSupportedCharacterSets());
        hashCode = 31 * hashCode + Objects.hashCode(listSupportedTimezones());
        hashCode = 31 * hashCode + Objects.hashCode(includeAll());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDbEngineVersionsRequest)) {
            return false;
        }
        DescribeDbEngineVersionsRequest other = (DescribeDbEngineVersionsRequest) obj;
        return Objects.equals(engine(), other.engine()) && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(dbParameterGroupFamily(), other.dbParameterGroupFamily()) && hasFilters() == other.hasFilters()
                && Objects.equals(filters(), other.filters()) && Objects.equals(maxRecords(), other.maxRecords())
                && Objects.equals(marker(), other.marker()) && Objects.equals(defaultOnly(), other.defaultOnly())
                && Objects.equals(listSupportedCharacterSets(), other.listSupportedCharacterSets())
                && Objects.equals(listSupportedTimezones(), other.listSupportedTimezones())
                && Objects.equals(includeAll(), other.includeAll());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDbEngineVersionsRequest").add("Engine", engine()).add("EngineVersion", engineVersion())
                .add("DBParameterGroupFamily", dbParameterGroupFamily()).add("Filters", hasFilters() ? filters() : null)
                .add("MaxRecords", maxRecords()).add("Marker", marker()).add("DefaultOnly", defaultOnly())
                .add("ListSupportedCharacterSets", listSupportedCharacterSets())
                .add("ListSupportedTimezones", listSupportedTimezones()).add("IncludeAll", includeAll()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Engine":
            return Optional.ofNullable(clazz.cast(engine()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "DBParameterGroupFamily":
            return Optional.ofNullable(clazz.cast(dbParameterGroupFamily()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "MaxRecords":
            return Optional.ofNullable(clazz.cast(maxRecords()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "DefaultOnly":
            return Optional.ofNullable(clazz.cast(defaultOnly()));
        case "ListSupportedCharacterSets":
            return Optional.ofNullable(clazz.cast(listSupportedCharacterSets()));
        case "ListSupportedTimezones":
            return Optional.ofNullable(clazz.cast(listSupportedTimezones()));
        case "IncludeAll":
            return Optional.ofNullable(clazz.cast(includeAll()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDbEngineVersionsRequest, T> g) {
        return obj -> g.apply((DescribeDbEngineVersionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeDbEngineVersionsRequest> {
        /**
         * <p>
         * The database engine to return.
         * </p>
         * <p>
         * Valid Values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>aurora</code> (for MySQL 5.6-compatible Aurora)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>aurora-mysql</code> (for MySQL 5.7-compatible Aurora)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>aurora-postgresql</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>mariadb</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>mysql</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>oracle-ee</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>oracle-ee-cdb</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>oracle-se2</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>oracle-se2-cdb</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>postgres</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sqlserver-ee</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sqlserver-se</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sqlserver-ex</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sqlserver-web</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param engine
         *        The database engine to return.</p>
         *        <p>
         *        Valid Values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>aurora</code> (for MySQL 5.6-compatible Aurora)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>aurora-mysql</code> (for MySQL 5.7-compatible Aurora)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>aurora-postgresql</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>mariadb</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>mysql</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>oracle-ee</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>oracle-ee-cdb</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>oracle-se2</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>oracle-se2-cdb</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>postgres</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sqlserver-ee</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sqlserver-se</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sqlserver-ex</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sqlserver-web</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engine(String engine);

        /**
         * <p>
         * The database engine version to return.
         * </p>
         * <p>
         * Example: <code>5.1.49</code>
         * </p>
         * 
         * @param engineVersion
         *        The database engine version to return.</p>
         *        <p>
         *        Example: <code>5.1.49</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * The name of a specific DB parameter group family to return details for.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If supplied, must match an existing DBParameterGroupFamily.
         * </p>
         * </li>
         * </ul>
         * 
         * @param dbParameterGroupFamily
         *        The name of a specific DB parameter group family to return details for.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If supplied, must match an existing DBParameterGroupFamily.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbParameterGroupFamily(String dbParameterGroupFamily);

        /**
         * <p>
         * This parameter isn't currently supported.
         * </p>
         * 
         * @param filters
         *        This parameter isn't currently supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * This parameter isn't currently supported.
         * </p>
         * 
         * @param filters
         *        This parameter isn't currently supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * This parameter isn't currently supported.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Filter>.Builder} avoiding the need to
         * create one manually via {@link List<Filter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Filter>.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<Filter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        /**
         * <p>
         * The maximum number of records to include in the response. If more than the <code>MaxRecords</code> value is
         * available, a pagination token called a marker is included in the response so you can retrieve the remaining
         * results.
         * </p>
         * <p>
         * Default: 100
         * </p>
         * <p>
         * Constraints: Minimum 20, maximum 100.
         * </p>
         * 
         * @param maxRecords
         *        The maximum number of records to include in the response. If more than the <code>MaxRecords</code>
         *        value is available, a pagination token called a marker is included in the response so you can retrieve
         *        the remaining results. </p>
         *        <p>
         *        Default: 100
         *        </p>
         *        <p>
         *        Constraints: Minimum 20, maximum 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRecords(Integer maxRecords);

        /**
         * <p>
         * An optional pagination token provided by a previous request. If this parameter is specified, the response
         * includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
         * </p>
         * 
         * @param marker
         *        An optional pagination token provided by a previous request. If this parameter is specified, the
         *        response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * A value that indicates whether only the default version of the specified engine or engine and major version
         * combination is returned.
         * </p>
         * 
         * @param defaultOnly
         *        A value that indicates whether only the default version of the specified engine or engine and major
         *        version combination is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultOnly(Boolean defaultOnly);

        /**
         * <p>
         * A value that indicates whether to list the supported character sets for each engine version.
         * </p>
         * <p>
         * If this parameter is enabled and the requested engine supports the <code>CharacterSetName</code> parameter
         * for <code>CreateDBInstance</code>, the response includes a list of supported character sets for each engine
         * version.
         * </p>
         * 
         * @param listSupportedCharacterSets
         *        A value that indicates whether to list the supported character sets for each engine version.</p>
         *        <p>
         *        If this parameter is enabled and the requested engine supports the <code>CharacterSetName</code>
         *        parameter for <code>CreateDBInstance</code>, the response includes a list of supported character sets
         *        for each engine version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listSupportedCharacterSets(Boolean listSupportedCharacterSets);

        /**
         * <p>
         * A value that indicates whether to list the supported time zones for each engine version.
         * </p>
         * <p>
         * If this parameter is enabled and the requested engine supports the <code>TimeZone</code> parameter for
         * <code>CreateDBInstance</code>, the response includes a list of supported time zones for each engine version.
         * </p>
         * 
         * @param listSupportedTimezones
         *        A value that indicates whether to list the supported time zones for each engine version.</p>
         *        <p>
         *        If this parameter is enabled and the requested engine supports the <code>TimeZone</code> parameter for
         *        <code>CreateDBInstance</code>, the response includes a list of supported time zones for each engine
         *        version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listSupportedTimezones(Boolean listSupportedTimezones);

        /**
         * <p>
         * A value that indicates whether to include engine versions that aren't available in the list. The default is
         * to list only available engine versions.
         * </p>
         * 
         * @param includeAll
         *        A value that indicates whether to include engine versions that aren't available in the list. The
         *        default is to list only available engine versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeAll(Boolean includeAll);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RdsRequest.BuilderImpl implements Builder {
        private String engine;

        private String engineVersion;

        private String dbParameterGroupFamily;

        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private Integer maxRecords;

        private String marker;

        private Boolean defaultOnly;

        private Boolean listSupportedCharacterSets;

        private Boolean listSupportedTimezones;

        private Boolean includeAll;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDbEngineVersionsRequest model) {
            super(model);
            engine(model.engine);
            engineVersion(model.engineVersion);
            dbParameterGroupFamily(model.dbParameterGroupFamily);
            filters(model.filters);
            maxRecords(model.maxRecords);
            marker(model.marker);
            defaultOnly(model.defaultOnly);
            listSupportedCharacterSets(model.listSupportedCharacterSets);
            listSupportedTimezones(model.listSupportedTimezones);
            includeAll(model.includeAll);
        }

        public final String getEngine() {
            return engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final String getDbParameterGroupFamily() {
            return dbParameterGroupFamily;
        }

        @Override
        public final Builder dbParameterGroupFamily(String dbParameterGroupFamily) {
            this.dbParameterGroupFamily = dbParameterGroupFamily;
            return this;
        }

        public final void setDbParameterGroupFamily(String dbParameterGroupFamily) {
            this.dbParameterGroupFamily = dbParameterGroupFamily;
        }

        public final List<Filter.Builder> getFilters() {
            List<Filter.Builder> result = FilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final Integer getMaxRecords() {
            return maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Boolean getDefaultOnly() {
            return defaultOnly;
        }

        @Override
        public final Builder defaultOnly(Boolean defaultOnly) {
            this.defaultOnly = defaultOnly;
            return this;
        }

        public final void setDefaultOnly(Boolean defaultOnly) {
            this.defaultOnly = defaultOnly;
        }

        public final Boolean getListSupportedCharacterSets() {
            return listSupportedCharacterSets;
        }

        @Override
        public final Builder listSupportedCharacterSets(Boolean listSupportedCharacterSets) {
            this.listSupportedCharacterSets = listSupportedCharacterSets;
            return this;
        }

        public final void setListSupportedCharacterSets(Boolean listSupportedCharacterSets) {
            this.listSupportedCharacterSets = listSupportedCharacterSets;
        }

        public final Boolean getListSupportedTimezones() {
            return listSupportedTimezones;
        }

        @Override
        public final Builder listSupportedTimezones(Boolean listSupportedTimezones) {
            this.listSupportedTimezones = listSupportedTimezones;
            return this;
        }

        public final void setListSupportedTimezones(Boolean listSupportedTimezones) {
            this.listSupportedTimezones = listSupportedTimezones;
        }

        public final Boolean getIncludeAll() {
            return includeAll;
        }

        @Override
        public final Builder includeAll(Boolean includeAll) {
            this.includeAll = includeAll;
            return this;
        }

        public final void setIncludeAll(Boolean includeAll) {
            this.includeAll = includeAll;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeDbEngineVersionsRequest build() {
            return new DescribeDbEngineVersionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
