/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.RdsRequest;
import software.amazon.awssdk.services.rds.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyDbClusterEndpointRequest
extends RdsRequest
implements ToCopyableBuilder<Builder, ModifyDbClusterEndpointRequest> {
    private static final SdkField<String> DB_CLUSTER_ENDPOINT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBClusterEndpointIdentifier").getter(ModifyDbClusterEndpointRequest.getter(ModifyDbClusterEndpointRequest::dbClusterEndpointIdentifier)).setter(ModifyDbClusterEndpointRequest.setter(Builder::dbClusterEndpointIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterEndpointIdentifier").build()}).build();
    private static final SdkField<String> ENDPOINT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointType").getter(ModifyDbClusterEndpointRequest.getter(ModifyDbClusterEndpointRequest::endpointType)).setter(ModifyDbClusterEndpointRequest.setter(Builder::endpointType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointType").build()}).build();
    private static final SdkField<List<String>> STATIC_MEMBERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StaticMembers").getter(ModifyDbClusterEndpointRequest.getter(ModifyDbClusterEndpointRequest::staticMembers)).setter(ModifyDbClusterEndpointRequest.setter(Builder::staticMembers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StaticMembers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EXCLUDED_MEMBERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExcludedMembers").getter(ModifyDbClusterEndpointRequest.getter(ModifyDbClusterEndpointRequest::excludedMembers)).setter(ModifyDbClusterEndpointRequest.setter(Builder::excludedMembers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludedMembers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_CLUSTER_ENDPOINT_IDENTIFIER_FIELD, ENDPOINT_TYPE_FIELD, STATIC_MEMBERS_FIELD, EXCLUDED_MEMBERS_FIELD));
    private final String dbClusterEndpointIdentifier;
    private final String endpointType;
    private final List<String> staticMembers;
    private final List<String> excludedMembers;

    private ModifyDbClusterEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.dbClusterEndpointIdentifier = builder.dbClusterEndpointIdentifier;
        this.endpointType = builder.endpointType;
        this.staticMembers = builder.staticMembers;
        this.excludedMembers = builder.excludedMembers;
    }

    public final String dbClusterEndpointIdentifier() {
        return this.dbClusterEndpointIdentifier;
    }

    public final String endpointType() {
        return this.endpointType;
    }

    public final boolean hasStaticMembers() {
        return this.staticMembers != null && !(this.staticMembers instanceof SdkAutoConstructList);
    }

    public final List<String> staticMembers() {
        return this.staticMembers;
    }

    public final boolean hasExcludedMembers() {
        return this.excludedMembers != null && !(this.excludedMembers instanceof SdkAutoConstructList);
    }

    public final List<String> excludedMembers() {
        return this.excludedMembers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterEndpointIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStaticMembers() ? this.staticMembers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExcludedMembers() ? this.excludedMembers() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyDbClusterEndpointRequest)) {
            return false;
        }
        ModifyDbClusterEndpointRequest other = (ModifyDbClusterEndpointRequest)((Object)obj);
        return Objects.equals(this.dbClusterEndpointIdentifier(), other.dbClusterEndpointIdentifier()) && Objects.equals(this.endpointType(), other.endpointType()) && this.hasStaticMembers() == other.hasStaticMembers() && Objects.equals(this.staticMembers(), other.staticMembers()) && this.hasExcludedMembers() == other.hasExcludedMembers() && Objects.equals(this.excludedMembers(), other.excludedMembers());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyDbClusterEndpointRequest").add("DBClusterEndpointIdentifier", (Object)this.dbClusterEndpointIdentifier()).add("EndpointType", (Object)this.endpointType()).add("StaticMembers", this.hasStaticMembers() ? this.staticMembers() : null).add("ExcludedMembers", this.hasExcludedMembers() ? this.excludedMembers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBClusterEndpointIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbClusterEndpointIdentifier()));
            }
            case "EndpointType": {
                return Optional.ofNullable(clazz.cast(this.endpointType()));
            }
            case "StaticMembers": {
                return Optional.ofNullable(clazz.cast(this.staticMembers()));
            }
            case "ExcludedMembers": {
                return Optional.ofNullable(clazz.cast(this.excludedMembers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyDbClusterEndpointRequest, T> g) {
        return obj -> g.apply((ModifyDbClusterEndpointRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsRequest.BuilderImpl
    implements Builder {
        private String dbClusterEndpointIdentifier;
        private String endpointType;
        private List<String> staticMembers = DefaultSdkAutoConstructList.getInstance();
        private List<String> excludedMembers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyDbClusterEndpointRequest model) {
            super(model);
            this.dbClusterEndpointIdentifier(model.dbClusterEndpointIdentifier);
            this.endpointType(model.endpointType);
            this.staticMembers(model.staticMembers);
            this.excludedMembers(model.excludedMembers);
        }

        public final String getDbClusterEndpointIdentifier() {
            return this.dbClusterEndpointIdentifier;
        }

        @Override
        public final Builder dbClusterEndpointIdentifier(String dbClusterEndpointIdentifier) {
            this.dbClusterEndpointIdentifier = dbClusterEndpointIdentifier;
            return this;
        }

        public final void setDbClusterEndpointIdentifier(String dbClusterEndpointIdentifier) {
            this.dbClusterEndpointIdentifier = dbClusterEndpointIdentifier;
        }

        public final String getEndpointType() {
            return this.endpointType;
        }

        @Override
        public final Builder endpointType(String endpointType) {
            this.endpointType = endpointType;
            return this;
        }

        public final void setEndpointType(String endpointType) {
            this.endpointType = endpointType;
        }

        public final Collection<String> getStaticMembers() {
            if (this.staticMembers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.staticMembers;
        }

        @Override
        public final Builder staticMembers(Collection<String> staticMembers) {
            this.staticMembers = StringListCopier.copy(staticMembers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder staticMembers(String ... staticMembers) {
            this.staticMembers(Arrays.asList(staticMembers));
            return this;
        }

        public final void setStaticMembers(Collection<String> staticMembers) {
            this.staticMembers = StringListCopier.copy(staticMembers);
        }

        public final Collection<String> getExcludedMembers() {
            if (this.excludedMembers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.excludedMembers;
        }

        @Override
        public final Builder excludedMembers(Collection<String> excludedMembers) {
            this.excludedMembers = StringListCopier.copy(excludedMembers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludedMembers(String ... excludedMembers) {
            this.excludedMembers(Arrays.asList(excludedMembers));
            return this;
        }

        public final void setExcludedMembers(Collection<String> excludedMembers) {
            this.excludedMembers = StringListCopier.copy(excludedMembers);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyDbClusterEndpointRequest build() {
            return new ModifyDbClusterEndpointRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RdsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyDbClusterEndpointRequest> {
        public Builder dbClusterEndpointIdentifier(String var1);

        public Builder endpointType(String var1);

        public Builder staticMembers(Collection<String> var1);

        public Builder staticMembers(String ... var1);

        public Builder excludedMembers(Collection<String> var1);

        public Builder excludedMembers(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

