/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This data type is used as a response element in the <code>DescribeReservedDBInstances</code> and
 * <code>PurchaseReservedDBInstancesOffering</code> actions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReservedDBInstance implements SdkPojo, Serializable,
        ToCopyableBuilder<ReservedDBInstance.Builder, ReservedDBInstance> {
    private static final SdkField<String> RESERVED_DB_INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReservedDBInstanceId").getter(getter(ReservedDBInstance::reservedDBInstanceId))
            .setter(setter(Builder::reservedDBInstanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedDBInstanceId").build())
            .build();

    private static final SdkField<String> RESERVED_DB_INSTANCES_OFFERING_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ReservedDBInstancesOfferingId")
            .getter(getter(ReservedDBInstance::reservedDBInstancesOfferingId))
            .setter(setter(Builder::reservedDBInstancesOfferingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedDBInstancesOfferingId")
                    .build()).build();

    private static final SdkField<String> DB_INSTANCE_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBInstanceClass").getter(getter(ReservedDBInstance::dbInstanceClass))
            .setter(setter(Builder::dbInstanceClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceClass").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(ReservedDBInstance::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Integer> DURATION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Duration").getter(getter(ReservedDBInstance::duration)).setter(setter(Builder::duration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()).build();

    private static final SdkField<Double> FIXED_PRICE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("FixedPrice").getter(getter(ReservedDBInstance::fixedPrice)).setter(setter(Builder::fixedPrice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FixedPrice").build()).build();

    private static final SdkField<Double> USAGE_PRICE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("UsagePrice").getter(getter(ReservedDBInstance::usagePrice)).setter(setter(Builder::usagePrice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsagePrice").build()).build();

    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CurrencyCode").getter(getter(ReservedDBInstance::currencyCode)).setter(setter(Builder::currencyCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrencyCode").build()).build();

    private static final SdkField<Integer> DB_INSTANCE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DBInstanceCount").getter(getter(ReservedDBInstance::dbInstanceCount))
            .setter(setter(Builder::dbInstanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceCount").build()).build();

    private static final SdkField<String> PRODUCT_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProductDescription").getter(getter(ReservedDBInstance::productDescription))
            .setter(setter(Builder::productDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductDescription").build())
            .build();

    private static final SdkField<String> OFFERING_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OfferingType").getter(getter(ReservedDBInstance::offeringType)).setter(setter(Builder::offeringType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OfferingType").build()).build();

    private static final SdkField<Boolean> MULTI_AZ_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("MultiAZ").getter(getter(ReservedDBInstance::multiAZ)).setter(setter(Builder::multiAZ))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiAZ").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(ReservedDBInstance::state)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<List<RecurringCharge>> RECURRING_CHARGES_FIELD = SdkField
            .<List<RecurringCharge>> builder(MarshallingType.LIST)
            .memberName("RecurringCharges")
            .getter(getter(ReservedDBInstance::recurringCharges))
            .setter(setter(Builder::recurringCharges))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecurringCharges").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("RecurringCharge")
                            .memberFieldInfo(
                                    SdkField.<RecurringCharge> builder(MarshallingType.SDK_POJO)
                                            .constructor(RecurringCharge::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("RecurringCharge").build()).build()).build()).build();

    private static final SdkField<String> RESERVED_DB_INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReservedDBInstanceArn").getter(getter(ReservedDBInstance::reservedDBInstanceArn))
            .setter(setter(Builder::reservedDBInstanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedDBInstanceArn").build())
            .build();

    private static final SdkField<String> LEASE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LeaseId").getter(getter(ReservedDBInstance::leaseId)).setter(setter(Builder::leaseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LeaseId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESERVED_DB_INSTANCE_ID_FIELD,
            RESERVED_DB_INSTANCES_OFFERING_ID_FIELD, DB_INSTANCE_CLASS_FIELD, START_TIME_FIELD, DURATION_FIELD,
            FIXED_PRICE_FIELD, USAGE_PRICE_FIELD, CURRENCY_CODE_FIELD, DB_INSTANCE_COUNT_FIELD, PRODUCT_DESCRIPTION_FIELD,
            OFFERING_TYPE_FIELD, MULTI_AZ_FIELD, STATE_FIELD, RECURRING_CHARGES_FIELD, RESERVED_DB_INSTANCE_ARN_FIELD,
            LEASE_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String reservedDBInstanceId;

    private final String reservedDBInstancesOfferingId;

    private final String dbInstanceClass;

    private final Instant startTime;

    private final Integer duration;

    private final Double fixedPrice;

    private final Double usagePrice;

    private final String currencyCode;

    private final Integer dbInstanceCount;

    private final String productDescription;

    private final String offeringType;

    private final Boolean multiAZ;

    private final String state;

    private final List<RecurringCharge> recurringCharges;

    private final String reservedDBInstanceArn;

    private final String leaseId;

    private ReservedDBInstance(BuilderImpl builder) {
        this.reservedDBInstanceId = builder.reservedDBInstanceId;
        this.reservedDBInstancesOfferingId = builder.reservedDBInstancesOfferingId;
        this.dbInstanceClass = builder.dbInstanceClass;
        this.startTime = builder.startTime;
        this.duration = builder.duration;
        this.fixedPrice = builder.fixedPrice;
        this.usagePrice = builder.usagePrice;
        this.currencyCode = builder.currencyCode;
        this.dbInstanceCount = builder.dbInstanceCount;
        this.productDescription = builder.productDescription;
        this.offeringType = builder.offeringType;
        this.multiAZ = builder.multiAZ;
        this.state = builder.state;
        this.recurringCharges = builder.recurringCharges;
        this.reservedDBInstanceArn = builder.reservedDBInstanceArn;
        this.leaseId = builder.leaseId;
    }

    /**
     * <p>
     * The unique identifier for the reservation.
     * </p>
     * 
     * @return The unique identifier for the reservation.
     */
    public final String reservedDBInstanceId() {
        return reservedDBInstanceId;
    }

    /**
     * <p>
     * The offering identifier.
     * </p>
     * 
     * @return The offering identifier.
     */
    public final String reservedDBInstancesOfferingId() {
        return reservedDBInstancesOfferingId;
    }

    /**
     * <p>
     * The DB instance class for the reserved DB instance.
     * </p>
     * 
     * @return The DB instance class for the reserved DB instance.
     */
    public final String dbInstanceClass() {
        return dbInstanceClass;
    }

    /**
     * <p>
     * The time the reservation started.
     * </p>
     * 
     * @return The time the reservation started.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The duration of the reservation in seconds.
     * </p>
     * 
     * @return The duration of the reservation in seconds.
     */
    public final Integer duration() {
        return duration;
    }

    /**
     * <p>
     * The fixed price charged for this reserved DB instance.
     * </p>
     * 
     * @return The fixed price charged for this reserved DB instance.
     */
    public final Double fixedPrice() {
        return fixedPrice;
    }

    /**
     * <p>
     * The hourly price charged for this reserved DB instance.
     * </p>
     * 
     * @return The hourly price charged for this reserved DB instance.
     */
    public final Double usagePrice() {
        return usagePrice;
    }

    /**
     * <p>
     * The currency code for the reserved DB instance.
     * </p>
     * 
     * @return The currency code for the reserved DB instance.
     */
    public final String currencyCode() {
        return currencyCode;
    }

    /**
     * <p>
     * The number of reserved DB instances.
     * </p>
     * 
     * @return The number of reserved DB instances.
     */
    public final Integer dbInstanceCount() {
        return dbInstanceCount;
    }

    /**
     * <p>
     * The description of the reserved DB instance.
     * </p>
     * 
     * @return The description of the reserved DB instance.
     */
    public final String productDescription() {
        return productDescription;
    }

    /**
     * <p>
     * The offering type of this reserved DB instance.
     * </p>
     * 
     * @return The offering type of this reserved DB instance.
     */
    public final String offeringType() {
        return offeringType;
    }

    /**
     * <p>
     * Indicates if the reservation applies to Multi-AZ deployments.
     * </p>
     * 
     * @return Indicates if the reservation applies to Multi-AZ deployments.
     */
    public final Boolean multiAZ() {
        return multiAZ;
    }

    /**
     * <p>
     * The state of the reserved DB instance.
     * </p>
     * 
     * @return The state of the reserved DB instance.
     */
    public final String state() {
        return state;
    }

    /**
     * Returns true if the RecurringCharges property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasRecurringCharges() {
        return recurringCharges != null && !(recurringCharges instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The recurring price charged to run this reserved DB instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRecurringCharges()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The recurring price charged to run this reserved DB instance.
     */
    public final List<RecurringCharge> recurringCharges() {
        return recurringCharges;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the reserved DB instance.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the reserved DB instance.
     */
    public final String reservedDBInstanceArn() {
        return reservedDBInstanceArn;
    }

    /**
     * <p>
     * The unique identifier for the lease associated with the reserved DB instance.
     * </p>
     * <note>
     * <p>
     * AWS Support might request the lease ID for an issue related to a reserved DB instance.
     * </p>
     * </note>
     * 
     * @return The unique identifier for the lease associated with the reserved DB instance.</p> <note>
     *         <p>
     *         AWS Support might request the lease ID for an issue related to a reserved DB instance.
     *         </p>
     */
    public final String leaseId() {
        return leaseId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(reservedDBInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(reservedDBInstancesOfferingId());
        hashCode = 31 * hashCode + Objects.hashCode(dbInstanceClass());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(duration());
        hashCode = 31 * hashCode + Objects.hashCode(fixedPrice());
        hashCode = 31 * hashCode + Objects.hashCode(usagePrice());
        hashCode = 31 * hashCode + Objects.hashCode(currencyCode());
        hashCode = 31 * hashCode + Objects.hashCode(dbInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(productDescription());
        hashCode = 31 * hashCode + Objects.hashCode(offeringType());
        hashCode = 31 * hashCode + Objects.hashCode(multiAZ());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        hashCode = 31 * hashCode + Objects.hashCode(hasRecurringCharges() ? recurringCharges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(reservedDBInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(leaseId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservedDBInstance)) {
            return false;
        }
        ReservedDBInstance other = (ReservedDBInstance) obj;
        return Objects.equals(reservedDBInstanceId(), other.reservedDBInstanceId())
                && Objects.equals(reservedDBInstancesOfferingId(), other.reservedDBInstancesOfferingId())
                && Objects.equals(dbInstanceClass(), other.dbInstanceClass()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(duration(), other.duration()) && Objects.equals(fixedPrice(), other.fixedPrice())
                && Objects.equals(usagePrice(), other.usagePrice()) && Objects.equals(currencyCode(), other.currencyCode())
                && Objects.equals(dbInstanceCount(), other.dbInstanceCount())
                && Objects.equals(productDescription(), other.productDescription())
                && Objects.equals(offeringType(), other.offeringType()) && Objects.equals(multiAZ(), other.multiAZ())
                && Objects.equals(state(), other.state()) && hasRecurringCharges() == other.hasRecurringCharges()
                && Objects.equals(recurringCharges(), other.recurringCharges())
                && Objects.equals(reservedDBInstanceArn(), other.reservedDBInstanceArn())
                && Objects.equals(leaseId(), other.leaseId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReservedDBInstance").add("ReservedDBInstanceId", reservedDBInstanceId())
                .add("ReservedDBInstancesOfferingId", reservedDBInstancesOfferingId()).add("DBInstanceClass", dbInstanceClass())
                .add("StartTime", startTime()).add("Duration", duration()).add("FixedPrice", fixedPrice())
                .add("UsagePrice", usagePrice()).add("CurrencyCode", currencyCode()).add("DBInstanceCount", dbInstanceCount())
                .add("ProductDescription", productDescription()).add("OfferingType", offeringType()).add("MultiAZ", multiAZ())
                .add("State", state()).add("RecurringCharges", hasRecurringCharges() ? recurringCharges() : null)
                .add("ReservedDBInstanceArn", reservedDBInstanceArn()).add("LeaseId", leaseId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReservedDBInstanceId":
            return Optional.ofNullable(clazz.cast(reservedDBInstanceId()));
        case "ReservedDBInstancesOfferingId":
            return Optional.ofNullable(clazz.cast(reservedDBInstancesOfferingId()));
        case "DBInstanceClass":
            return Optional.ofNullable(clazz.cast(dbInstanceClass()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "Duration":
            return Optional.ofNullable(clazz.cast(duration()));
        case "FixedPrice":
            return Optional.ofNullable(clazz.cast(fixedPrice()));
        case "UsagePrice":
            return Optional.ofNullable(clazz.cast(usagePrice()));
        case "CurrencyCode":
            return Optional.ofNullable(clazz.cast(currencyCode()));
        case "DBInstanceCount":
            return Optional.ofNullable(clazz.cast(dbInstanceCount()));
        case "ProductDescription":
            return Optional.ofNullable(clazz.cast(productDescription()));
        case "OfferingType":
            return Optional.ofNullable(clazz.cast(offeringType()));
        case "MultiAZ":
            return Optional.ofNullable(clazz.cast(multiAZ()));
        case "State":
            return Optional.ofNullable(clazz.cast(state()));
        case "RecurringCharges":
            return Optional.ofNullable(clazz.cast(recurringCharges()));
        case "ReservedDBInstanceArn":
            return Optional.ofNullable(clazz.cast(reservedDBInstanceArn()));
        case "LeaseId":
            return Optional.ofNullable(clazz.cast(leaseId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReservedDBInstance, T> g) {
        return obj -> g.apply((ReservedDBInstance) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReservedDBInstance> {
        /**
         * <p>
         * The unique identifier for the reservation.
         * </p>
         * 
         * @param reservedDBInstanceId
         *        The unique identifier for the reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedDBInstanceId(String reservedDBInstanceId);

        /**
         * <p>
         * The offering identifier.
         * </p>
         * 
         * @param reservedDBInstancesOfferingId
         *        The offering identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedDBInstancesOfferingId(String reservedDBInstancesOfferingId);

        /**
         * <p>
         * The DB instance class for the reserved DB instance.
         * </p>
         * 
         * @param dbInstanceClass
         *        The DB instance class for the reserved DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbInstanceClass(String dbInstanceClass);

        /**
         * <p>
         * The time the reservation started.
         * </p>
         * 
         * @param startTime
         *        The time the reservation started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The duration of the reservation in seconds.
         * </p>
         * 
         * @param duration
         *        The duration of the reservation in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder duration(Integer duration);

        /**
         * <p>
         * The fixed price charged for this reserved DB instance.
         * </p>
         * 
         * @param fixedPrice
         *        The fixed price charged for this reserved DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fixedPrice(Double fixedPrice);

        /**
         * <p>
         * The hourly price charged for this reserved DB instance.
         * </p>
         * 
         * @param usagePrice
         *        The hourly price charged for this reserved DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usagePrice(Double usagePrice);

        /**
         * <p>
         * The currency code for the reserved DB instance.
         * </p>
         * 
         * @param currencyCode
         *        The currency code for the reserved DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currencyCode(String currencyCode);

        /**
         * <p>
         * The number of reserved DB instances.
         * </p>
         * 
         * @param dbInstanceCount
         *        The number of reserved DB instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbInstanceCount(Integer dbInstanceCount);

        /**
         * <p>
         * The description of the reserved DB instance.
         * </p>
         * 
         * @param productDescription
         *        The description of the reserved DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productDescription(String productDescription);

        /**
         * <p>
         * The offering type of this reserved DB instance.
         * </p>
         * 
         * @param offeringType
         *        The offering type of this reserved DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offeringType(String offeringType);

        /**
         * <p>
         * Indicates if the reservation applies to Multi-AZ deployments.
         * </p>
         * 
         * @param multiAZ
         *        Indicates if the reservation applies to Multi-AZ deployments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiAZ(Boolean multiAZ);

        /**
         * <p>
         * The state of the reserved DB instance.
         * </p>
         * 
         * @param state
         *        The state of the reserved DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(String state);

        /**
         * <p>
         * The recurring price charged to run this reserved DB instance.
         * </p>
         * 
         * @param recurringCharges
         *        The recurring price charged to run this reserved DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recurringCharges(Collection<RecurringCharge> recurringCharges);

        /**
         * <p>
         * The recurring price charged to run this reserved DB instance.
         * </p>
         * 
         * @param recurringCharges
         *        The recurring price charged to run this reserved DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recurringCharges(RecurringCharge... recurringCharges);

        /**
         * <p>
         * The recurring price charged to run this reserved DB instance.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RecurringCharge>.Builder} avoiding the need
         * to create one manually via {@link List<RecurringCharge>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RecurringCharge>.Builder#build()} is called immediately and
         * its result is passed to {@link #recurringCharges(List<RecurringCharge>)}.
         * 
         * @param recurringCharges
         *        a consumer that will call methods on {@link List<RecurringCharge>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recurringCharges(List<RecurringCharge>)
         */
        Builder recurringCharges(Consumer<RecurringCharge.Builder>... recurringCharges);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the reserved DB instance.
         * </p>
         * 
         * @param reservedDBInstanceArn
         *        The Amazon Resource Name (ARN) for the reserved DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedDBInstanceArn(String reservedDBInstanceArn);

        /**
         * <p>
         * The unique identifier for the lease associated with the reserved DB instance.
         * </p>
         * <note>
         * <p>
         * AWS Support might request the lease ID for an issue related to a reserved DB instance.
         * </p>
         * </note>
         * 
         * @param leaseId
         *        The unique identifier for the lease associated with the reserved DB instance.</p> <note>
         *        <p>
         *        AWS Support might request the lease ID for an issue related to a reserved DB instance.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder leaseId(String leaseId);
    }

    static final class BuilderImpl implements Builder {
        private String reservedDBInstanceId;

        private String reservedDBInstancesOfferingId;

        private String dbInstanceClass;

        private Instant startTime;

        private Integer duration;

        private Double fixedPrice;

        private Double usagePrice;

        private String currencyCode;

        private Integer dbInstanceCount;

        private String productDescription;

        private String offeringType;

        private Boolean multiAZ;

        private String state;

        private List<RecurringCharge> recurringCharges = DefaultSdkAutoConstructList.getInstance();

        private String reservedDBInstanceArn;

        private String leaseId;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservedDBInstance model) {
            reservedDBInstanceId(model.reservedDBInstanceId);
            reservedDBInstancesOfferingId(model.reservedDBInstancesOfferingId);
            dbInstanceClass(model.dbInstanceClass);
            startTime(model.startTime);
            duration(model.duration);
            fixedPrice(model.fixedPrice);
            usagePrice(model.usagePrice);
            currencyCode(model.currencyCode);
            dbInstanceCount(model.dbInstanceCount);
            productDescription(model.productDescription);
            offeringType(model.offeringType);
            multiAZ(model.multiAZ);
            state(model.state);
            recurringCharges(model.recurringCharges);
            reservedDBInstanceArn(model.reservedDBInstanceArn);
            leaseId(model.leaseId);
        }

        public final String getReservedDBInstanceId() {
            return reservedDBInstanceId;
        }

        @Override
        public final Builder reservedDBInstanceId(String reservedDBInstanceId) {
            this.reservedDBInstanceId = reservedDBInstanceId;
            return this;
        }

        public final void setReservedDBInstanceId(String reservedDBInstanceId) {
            this.reservedDBInstanceId = reservedDBInstanceId;
        }

        public final String getReservedDBInstancesOfferingId() {
            return reservedDBInstancesOfferingId;
        }

        @Override
        public final Builder reservedDBInstancesOfferingId(String reservedDBInstancesOfferingId) {
            this.reservedDBInstancesOfferingId = reservedDBInstancesOfferingId;
            return this;
        }

        public final void setReservedDBInstancesOfferingId(String reservedDBInstancesOfferingId) {
            this.reservedDBInstancesOfferingId = reservedDBInstancesOfferingId;
        }

        public final String getDbInstanceClass() {
            return dbInstanceClass;
        }

        @Override
        public final Builder dbInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
            return this;
        }

        public final void setDbInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Integer getDuration() {
            return duration;
        }

        @Override
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        public final Double getFixedPrice() {
            return fixedPrice;
        }

        @Override
        public final Builder fixedPrice(Double fixedPrice) {
            this.fixedPrice = fixedPrice;
            return this;
        }

        public final void setFixedPrice(Double fixedPrice) {
            this.fixedPrice = fixedPrice;
        }

        public final Double getUsagePrice() {
            return usagePrice;
        }

        @Override
        public final Builder usagePrice(Double usagePrice) {
            this.usagePrice = usagePrice;
            return this;
        }

        public final void setUsagePrice(Double usagePrice) {
            this.usagePrice = usagePrice;
        }

        public final String getCurrencyCode() {
            return currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        public final Integer getDbInstanceCount() {
            return dbInstanceCount;
        }

        @Override
        public final Builder dbInstanceCount(Integer dbInstanceCount) {
            this.dbInstanceCount = dbInstanceCount;
            return this;
        }

        public final void setDbInstanceCount(Integer dbInstanceCount) {
            this.dbInstanceCount = dbInstanceCount;
        }

        public final String getProductDescription() {
            return productDescription;
        }

        @Override
        public final Builder productDescription(String productDescription) {
            this.productDescription = productDescription;
            return this;
        }

        public final void setProductDescription(String productDescription) {
            this.productDescription = productDescription;
        }

        public final String getOfferingType() {
            return offeringType;
        }

        @Override
        public final Builder offeringType(String offeringType) {
            this.offeringType = offeringType;
            return this;
        }

        public final void setOfferingType(String offeringType) {
            this.offeringType = offeringType;
        }

        public final Boolean getMultiAZ() {
            return multiAZ;
        }

        @Override
        public final Builder multiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
            return this;
        }

        public final void setMultiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final List<RecurringCharge.Builder> getRecurringCharges() {
            List<RecurringCharge.Builder> result = RecurringChargeListCopier.copyToBuilder(this.recurringCharges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder recurringCharges(Collection<RecurringCharge> recurringCharges) {
            this.recurringCharges = RecurringChargeListCopier.copy(recurringCharges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recurringCharges(RecurringCharge... recurringCharges) {
            recurringCharges(Arrays.asList(recurringCharges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recurringCharges(Consumer<RecurringCharge.Builder>... recurringCharges) {
            recurringCharges(Stream.of(recurringCharges).map(c -> RecurringCharge.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setRecurringCharges(Collection<RecurringCharge.BuilderImpl> recurringCharges) {
            this.recurringCharges = RecurringChargeListCopier.copyFromBuilder(recurringCharges);
        }

        public final String getReservedDBInstanceArn() {
            return reservedDBInstanceArn;
        }

        @Override
        public final Builder reservedDBInstanceArn(String reservedDBInstanceArn) {
            this.reservedDBInstanceArn = reservedDBInstanceArn;
            return this;
        }

        public final void setReservedDBInstanceArn(String reservedDBInstanceArn) {
            this.reservedDBInstanceArn = reservedDBInstanceArn;
        }

        public final String getLeaseId() {
            return leaseId;
        }

        @Override
        public final Builder leaseId(String leaseId) {
            this.leaseId = leaseId;
            return this;
        }

        public final void setLeaseId(String leaseId) {
            this.leaseId = leaseId;
        }

        @Override
        public ReservedDBInstance build() {
            return new ReservedDBInstance(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
