/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyCertificatesRequest extends RdsRequest implements
        ToCopyableBuilder<ModifyCertificatesRequest.Builder, ModifyCertificatesRequest> {
    private static final SdkField<String> CERTIFICATE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CertificateIdentifier").getter(getter(ModifyCertificatesRequest::certificateIdentifier))
            .setter(setter(Builder::certificateIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateIdentifier").build())
            .build();

    private static final SdkField<Boolean> REMOVE_CUSTOMER_OVERRIDE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RemoveCustomerOverride").getter(getter(ModifyCertificatesRequest::removeCustomerOverride))
            .setter(setter(Builder::removeCustomerOverride))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveCustomerOverride").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_IDENTIFIER_FIELD,
            REMOVE_CUSTOMER_OVERRIDE_FIELD));

    private final String certificateIdentifier;

    private final Boolean removeCustomerOverride;

    private ModifyCertificatesRequest(BuilderImpl builder) {
        super(builder);
        this.certificateIdentifier = builder.certificateIdentifier;
        this.removeCustomerOverride = builder.removeCustomerOverride;
    }

    /**
     * <p>
     * The new default certificate identifier to override the current one with.
     * </p>
     * <p>
     * To determine the valid values, use the <code>describe-certificates</code> AWS CLI command or the
     * <code>DescribeCertificates</code> API operation.
     * </p>
     * 
     * @return The new default certificate identifier to override the current one with.</p>
     *         <p>
     *         To determine the valid values, use the <code>describe-certificates</code> AWS CLI command or the
     *         <code>DescribeCertificates</code> API operation.
     */
    public final String certificateIdentifier() {
        return certificateIdentifier;
    }

    /**
     * <p>
     * A value that indicates whether to remove the override for the default certificate. If the override is removed,
     * the default certificate is the system default.
     * </p>
     * 
     * @return A value that indicates whether to remove the override for the default certificate. If the override is
     *         removed, the default certificate is the system default.
     */
    public final Boolean removeCustomerOverride() {
        return removeCustomerOverride;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(certificateIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(removeCustomerOverride());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyCertificatesRequest)) {
            return false;
        }
        ModifyCertificatesRequest other = (ModifyCertificatesRequest) obj;
        return Objects.equals(certificateIdentifier(), other.certificateIdentifier())
                && Objects.equals(removeCustomerOverride(), other.removeCustomerOverride());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyCertificatesRequest").add("CertificateIdentifier", certificateIdentifier())
                .add("RemoveCustomerOverride", removeCustomerOverride()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CertificateIdentifier":
            return Optional.ofNullable(clazz.cast(certificateIdentifier()));
        case "RemoveCustomerOverride":
            return Optional.ofNullable(clazz.cast(removeCustomerOverride()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyCertificatesRequest, T> g) {
        return obj -> g.apply((ModifyCertificatesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsRequest.Builder, SdkPojo, CopyableBuilder<Builder, ModifyCertificatesRequest> {
        /**
         * <p>
         * The new default certificate identifier to override the current one with.
         * </p>
         * <p>
         * To determine the valid values, use the <code>describe-certificates</code> AWS CLI command or the
         * <code>DescribeCertificates</code> API operation.
         * </p>
         * 
         * @param certificateIdentifier
         *        The new default certificate identifier to override the current one with.</p>
         *        <p>
         *        To determine the valid values, use the <code>describe-certificates</code> AWS CLI command or the
         *        <code>DescribeCertificates</code> API operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateIdentifier(String certificateIdentifier);

        /**
         * <p>
         * A value that indicates whether to remove the override for the default certificate. If the override is
         * removed, the default certificate is the system default.
         * </p>
         * 
         * @param removeCustomerOverride
         *        A value that indicates whether to remove the override for the default certificate. If the override is
         *        removed, the default certificate is the system default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeCustomerOverride(Boolean removeCustomerOverride);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RdsRequest.BuilderImpl implements Builder {
        private String certificateIdentifier;

        private Boolean removeCustomerOverride;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyCertificatesRequest model) {
            super(model);
            certificateIdentifier(model.certificateIdentifier);
            removeCustomerOverride(model.removeCustomerOverride);
        }

        public final String getCertificateIdentifier() {
            return certificateIdentifier;
        }

        @Override
        public final Builder certificateIdentifier(String certificateIdentifier) {
            this.certificateIdentifier = certificateIdentifier;
            return this;
        }

        public final void setCertificateIdentifier(String certificateIdentifier) {
            this.certificateIdentifier = certificateIdentifier;
        }

        public final Boolean getRemoveCustomerOverride() {
            return removeCustomerOverride;
        }

        @Override
        public final Builder removeCustomerOverride(Boolean removeCustomerOverride) {
            this.removeCustomerOverride = removeCustomerOverride;
            return this;
        }

        public final void setRemoveCustomerOverride(Boolean removeCustomerOverride) {
            this.removeCustomerOverride = removeCustomerOverride;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyCertificatesRequest build() {
            return new ModifyCertificatesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
