/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeReservedDbInstancesOfferingsRequest extends RdsRequest implements
        ToCopyableBuilder<DescribeReservedDbInstancesOfferingsRequest.Builder, DescribeReservedDbInstancesOfferingsRequest> {
    private static final SdkField<String> RESERVED_DB_INSTANCES_OFFERING_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ReservedDBInstancesOfferingId")
            .getter(getter(DescribeReservedDbInstancesOfferingsRequest::reservedDBInstancesOfferingId))
            .setter(setter(Builder::reservedDBInstancesOfferingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedDBInstancesOfferingId")
                    .build()).build();

    private static final SdkField<String> DB_INSTANCE_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBInstanceClass").getter(getter(DescribeReservedDbInstancesOfferingsRequest::dbInstanceClass))
            .setter(setter(Builder::dbInstanceClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceClass").build()).build();

    private static final SdkField<String> DURATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Duration").getter(getter(DescribeReservedDbInstancesOfferingsRequest::duration))
            .setter(setter(Builder::duration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()).build();

    private static final SdkField<String> PRODUCT_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProductDescription").getter(getter(DescribeReservedDbInstancesOfferingsRequest::productDescription))
            .setter(setter(Builder::productDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductDescription").build())
            .build();

    private static final SdkField<String> OFFERING_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OfferingType").getter(getter(DescribeReservedDbInstancesOfferingsRequest::offeringType))
            .setter(setter(Builder::offeringType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OfferingType").build()).build();

    private static final SdkField<Boolean> MULTI_AZ_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("MultiAZ").getter(getter(DescribeReservedDbInstancesOfferingsRequest::multiAZ))
            .setter(setter(Builder::multiAZ))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiAZ").build()).build();

    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(DescribeReservedDbInstancesOfferingsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Filter")
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Filter").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RECORDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxRecords").getter(getter(DescribeReservedDbInstancesOfferingsRequest::maxRecords))
            .setter(setter(Builder::maxRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecords").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeReservedDbInstancesOfferingsRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            RESERVED_DB_INSTANCES_OFFERING_ID_FIELD, DB_INSTANCE_CLASS_FIELD, DURATION_FIELD, PRODUCT_DESCRIPTION_FIELD,
            OFFERING_TYPE_FIELD, MULTI_AZ_FIELD, FILTERS_FIELD, MAX_RECORDS_FIELD, MARKER_FIELD));

    private final String reservedDBInstancesOfferingId;

    private final String dbInstanceClass;

    private final String duration;

    private final String productDescription;

    private final String offeringType;

    private final Boolean multiAZ;

    private final List<Filter> filters;

    private final Integer maxRecords;

    private final String marker;

    private DescribeReservedDbInstancesOfferingsRequest(BuilderImpl builder) {
        super(builder);
        this.reservedDBInstancesOfferingId = builder.reservedDBInstancesOfferingId;
        this.dbInstanceClass = builder.dbInstanceClass;
        this.duration = builder.duration;
        this.productDescription = builder.productDescription;
        this.offeringType = builder.offeringType;
        this.multiAZ = builder.multiAZ;
        this.filters = builder.filters;
        this.maxRecords = builder.maxRecords;
        this.marker = builder.marker;
    }

    /**
     * <p>
     * The offering identifier filter value. Specify this parameter to show only the available offering that matches the
     * specified reservation identifier.
     * </p>
     * <p>
     * Example: <code>438012d3-4052-4cc7-b2e3-8d3372e0e706</code>
     * </p>
     * 
     * @return The offering identifier filter value. Specify this parameter to show only the available offering that
     *         matches the specified reservation identifier.</p>
     *         <p>
     *         Example: <code>438012d3-4052-4cc7-b2e3-8d3372e0e706</code>
     */
    public final String reservedDBInstancesOfferingId() {
        return reservedDBInstancesOfferingId;
    }

    /**
     * <p>
     * The DB instance class filter value. Specify this parameter to show only the available offerings matching the
     * specified DB instance class.
     * </p>
     * 
     * @return The DB instance class filter value. Specify this parameter to show only the available offerings matching
     *         the specified DB instance class.
     */
    public final String dbInstanceClass() {
        return dbInstanceClass;
    }

    /**
     * <p>
     * Duration filter value, specified in years or seconds. Specify this parameter to show only reservations for this
     * duration.
     * </p>
     * <p>
     * Valid Values: <code>1 | 3 | 31536000 | 94608000</code>
     * </p>
     * 
     * @return Duration filter value, specified in years or seconds. Specify this parameter to show only reservations
     *         for this duration.</p>
     *         <p>
     *         Valid Values: <code>1 | 3 | 31536000 | 94608000</code>
     */
    public final String duration() {
        return duration;
    }

    /**
     * <p>
     * Product description filter value. Specify this parameter to show only the available offerings that contain the
     * specified product description.
     * </p>
     * <note>
     * <p>
     * The results show offerings that partially match the filter value.
     * </p>
     * </note>
     * 
     * @return Product description filter value. Specify this parameter to show only the available offerings that
     *         contain the specified product description.</p> <note>
     *         <p>
     *         The results show offerings that partially match the filter value.
     *         </p>
     */
    public final String productDescription() {
        return productDescription;
    }

    /**
     * <p>
     * The offering type filter value. Specify this parameter to show only the available offerings matching the
     * specified offering type.
     * </p>
     * <p>
     * Valid Values: <code>"Partial Upfront" | "All Upfront" | "No Upfront" </code>
     * </p>
     * 
     * @return The offering type filter value. Specify this parameter to show only the available offerings matching the
     *         specified offering type.</p>
     *         <p>
     *         Valid Values: <code>"Partial Upfront" | "All Upfront" | "No Upfront" </code>
     */
    public final String offeringType() {
        return offeringType;
    }

    /**
     * <p>
     * A value that indicates whether to show only those reservations that support Multi-AZ.
     * </p>
     * 
     * @return A value that indicates whether to show only those reservations that support Multi-AZ.
     */
    public final Boolean multiAZ() {
        return multiAZ;
    }

    /**
     * Returns true if the Filters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * This parameter isn't currently supported.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFilters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return This parameter isn't currently supported.
     */
    public final List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * The maximum number of records to include in the response. If more than the <code>MaxRecords</code> value is
     * available, a pagination token called a marker is included in the response so you can retrieve the remaining
     * results.
     * </p>
     * <p>
     * Default: 100
     * </p>
     * <p>
     * Constraints: Minimum 20, maximum 100.
     * </p>
     * 
     * @return The maximum number of records to include in the response. If more than the <code>MaxRecords</code> value
     *         is available, a pagination token called a marker is included in the response so you can retrieve the
     *         remaining results. </p>
     *         <p>
     *         Default: 100
     *         </p>
     *         <p>
     *         Constraints: Minimum 20, maximum 100.
     */
    public final Integer maxRecords() {
        return maxRecords;
    }

    /**
     * <p>
     * An optional pagination token provided by a previous request. If this parameter is specified, the response
     * includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
     * </p>
     * 
     * @return An optional pagination token provided by a previous request. If this parameter is specified, the response
     *         includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
     */
    public final String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(reservedDBInstancesOfferingId());
        hashCode = 31 * hashCode + Objects.hashCode(dbInstanceClass());
        hashCode = 31 * hashCode + Objects.hashCode(duration());
        hashCode = 31 * hashCode + Objects.hashCode(productDescription());
        hashCode = 31 * hashCode + Objects.hashCode(offeringType());
        hashCode = 31 * hashCode + Objects.hashCode(multiAZ());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedDbInstancesOfferingsRequest)) {
            return false;
        }
        DescribeReservedDbInstancesOfferingsRequest other = (DescribeReservedDbInstancesOfferingsRequest) obj;
        return Objects.equals(reservedDBInstancesOfferingId(), other.reservedDBInstancesOfferingId())
                && Objects.equals(dbInstanceClass(), other.dbInstanceClass()) && Objects.equals(duration(), other.duration())
                && Objects.equals(productDescription(), other.productDescription())
                && Objects.equals(offeringType(), other.offeringType()) && Objects.equals(multiAZ(), other.multiAZ())
                && hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters())
                && Objects.equals(maxRecords(), other.maxRecords()) && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeReservedDbInstancesOfferingsRequest")
                .add("ReservedDBInstancesOfferingId", reservedDBInstancesOfferingId()).add("DBInstanceClass", dbInstanceClass())
                .add("Duration", duration()).add("ProductDescription", productDescription()).add("OfferingType", offeringType())
                .add("MultiAZ", multiAZ()).add("Filters", hasFilters() ? filters() : null).add("MaxRecords", maxRecords())
                .add("Marker", marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReservedDBInstancesOfferingId":
            return Optional.ofNullable(clazz.cast(reservedDBInstancesOfferingId()));
        case "DBInstanceClass":
            return Optional.ofNullable(clazz.cast(dbInstanceClass()));
        case "Duration":
            return Optional.ofNullable(clazz.cast(duration()));
        case "ProductDescription":
            return Optional.ofNullable(clazz.cast(productDescription()));
        case "OfferingType":
            return Optional.ofNullable(clazz.cast(offeringType()));
        case "MultiAZ":
            return Optional.ofNullable(clazz.cast(multiAZ()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "MaxRecords":
            return Optional.ofNullable(clazz.cast(maxRecords()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeReservedDbInstancesOfferingsRequest, T> g) {
        return obj -> g.apply((DescribeReservedDbInstancesOfferingsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeReservedDbInstancesOfferingsRequest> {
        /**
         * <p>
         * The offering identifier filter value. Specify this parameter to show only the available offering that matches
         * the specified reservation identifier.
         * </p>
         * <p>
         * Example: <code>438012d3-4052-4cc7-b2e3-8d3372e0e706</code>
         * </p>
         * 
         * @param reservedDBInstancesOfferingId
         *        The offering identifier filter value. Specify this parameter to show only the available offering that
         *        matches the specified reservation identifier.</p>
         *        <p>
         *        Example: <code>438012d3-4052-4cc7-b2e3-8d3372e0e706</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedDBInstancesOfferingId(String reservedDBInstancesOfferingId);

        /**
         * <p>
         * The DB instance class filter value. Specify this parameter to show only the available offerings matching the
         * specified DB instance class.
         * </p>
         * 
         * @param dbInstanceClass
         *        The DB instance class filter value. Specify this parameter to show only the available offerings
         *        matching the specified DB instance class.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbInstanceClass(String dbInstanceClass);

        /**
         * <p>
         * Duration filter value, specified in years or seconds. Specify this parameter to show only reservations for
         * this duration.
         * </p>
         * <p>
         * Valid Values: <code>1 | 3 | 31536000 | 94608000</code>
         * </p>
         * 
         * @param duration
         *        Duration filter value, specified in years or seconds. Specify this parameter to show only reservations
         *        for this duration.</p>
         *        <p>
         *        Valid Values: <code>1 | 3 | 31536000 | 94608000</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder duration(String duration);

        /**
         * <p>
         * Product description filter value. Specify this parameter to show only the available offerings that contain
         * the specified product description.
         * </p>
         * <note>
         * <p>
         * The results show offerings that partially match the filter value.
         * </p>
         * </note>
         * 
         * @param productDescription
         *        Product description filter value. Specify this parameter to show only the available offerings that
         *        contain the specified product description.</p> <note>
         *        <p>
         *        The results show offerings that partially match the filter value.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productDescription(String productDescription);

        /**
         * <p>
         * The offering type filter value. Specify this parameter to show only the available offerings matching the
         * specified offering type.
         * </p>
         * <p>
         * Valid Values: <code>"Partial Upfront" | "All Upfront" | "No Upfront" </code>
         * </p>
         * 
         * @param offeringType
         *        The offering type filter value. Specify this parameter to show only the available offerings matching
         *        the specified offering type.</p>
         *        <p>
         *        Valid Values: <code>"Partial Upfront" | "All Upfront" | "No Upfront" </code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offeringType(String offeringType);

        /**
         * <p>
         * A value that indicates whether to show only those reservations that support Multi-AZ.
         * </p>
         * 
         * @param multiAZ
         *        A value that indicates whether to show only those reservations that support Multi-AZ.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiAZ(Boolean multiAZ);

        /**
         * <p>
         * This parameter isn't currently supported.
         * </p>
         * 
         * @param filters
         *        This parameter isn't currently supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * This parameter isn't currently supported.
         * </p>
         * 
         * @param filters
         *        This parameter isn't currently supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * This parameter isn't currently supported.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Filter>.Builder} avoiding the need to
         * create one manually via {@link List<Filter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Filter>.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<Filter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        /**
         * <p>
         * The maximum number of records to include in the response. If more than the <code>MaxRecords</code> value is
         * available, a pagination token called a marker is included in the response so you can retrieve the remaining
         * results.
         * </p>
         * <p>
         * Default: 100
         * </p>
         * <p>
         * Constraints: Minimum 20, maximum 100.
         * </p>
         * 
         * @param maxRecords
         *        The maximum number of records to include in the response. If more than the <code>MaxRecords</code>
         *        value is available, a pagination token called a marker is included in the response so you can retrieve
         *        the remaining results. </p>
         *        <p>
         *        Default: 100
         *        </p>
         *        <p>
         *        Constraints: Minimum 20, maximum 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRecords(Integer maxRecords);

        /**
         * <p>
         * An optional pagination token provided by a previous request. If this parameter is specified, the response
         * includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
         * </p>
         * 
         * @param marker
         *        An optional pagination token provided by a previous request. If this parameter is specified, the
         *        response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RdsRequest.BuilderImpl implements Builder {
        private String reservedDBInstancesOfferingId;

        private String dbInstanceClass;

        private String duration;

        private String productDescription;

        private String offeringType;

        private Boolean multiAZ;

        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private Integer maxRecords;

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedDbInstancesOfferingsRequest model) {
            super(model);
            reservedDBInstancesOfferingId(model.reservedDBInstancesOfferingId);
            dbInstanceClass(model.dbInstanceClass);
            duration(model.duration);
            productDescription(model.productDescription);
            offeringType(model.offeringType);
            multiAZ(model.multiAZ);
            filters(model.filters);
            maxRecords(model.maxRecords);
            marker(model.marker);
        }

        public final String getReservedDBInstancesOfferingId() {
            return reservedDBInstancesOfferingId;
        }

        @Override
        public final Builder reservedDBInstancesOfferingId(String reservedDBInstancesOfferingId) {
            this.reservedDBInstancesOfferingId = reservedDBInstancesOfferingId;
            return this;
        }

        public final void setReservedDBInstancesOfferingId(String reservedDBInstancesOfferingId) {
            this.reservedDBInstancesOfferingId = reservedDBInstancesOfferingId;
        }

        public final String getDbInstanceClass() {
            return dbInstanceClass;
        }

        @Override
        public final Builder dbInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
            return this;
        }

        public final void setDbInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
        }

        public final String getDuration() {
            return duration;
        }

        @Override
        public final Builder duration(String duration) {
            this.duration = duration;
            return this;
        }

        public final void setDuration(String duration) {
            this.duration = duration;
        }

        public final String getProductDescription() {
            return productDescription;
        }

        @Override
        public final Builder productDescription(String productDescription) {
            this.productDescription = productDescription;
            return this;
        }

        public final void setProductDescription(String productDescription) {
            this.productDescription = productDescription;
        }

        public final String getOfferingType() {
            return offeringType;
        }

        @Override
        public final Builder offeringType(String offeringType) {
            this.offeringType = offeringType;
            return this;
        }

        public final void setOfferingType(String offeringType) {
            this.offeringType = offeringType;
        }

        public final Boolean getMultiAZ() {
            return multiAZ;
        }

        @Override
        public final Builder multiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
            return this;
        }

        public final void setMultiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
        }

        public final List<Filter.Builder> getFilters() {
            List<Filter.Builder> result = FilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        public final Integer getMaxRecords() {
            return maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeReservedDbInstancesOfferingsRequest build() {
            return new DescribeReservedDbInstancesOfferingsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
