/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeInstallationMediaResponse extends RdsResponse implements
        ToCopyableBuilder<DescribeInstallationMediaResponse.Builder, DescribeInstallationMediaResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeInstallationMediaResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<List<InstallationMedia>> INSTALLATION_MEDIA_FIELD = SdkField
            .<List<InstallationMedia>> builder(MarshallingType.LIST)
            .memberName("InstallationMedia")
            .getter(getter(DescribeInstallationMediaResponse::installationMedia))
            .setter(setter(Builder::installationMedia))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstallationMedia").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("InstallationMedia")
                            .memberFieldInfo(
                                    SdkField.<InstallationMedia> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstallationMedia::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("InstallationMedia").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD,
            INSTALLATION_MEDIA_FIELD));

    private final String marker;

    private final List<InstallationMedia> installationMedia;

    private DescribeInstallationMediaResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.installationMedia = builder.installationMedia;
    }

    /**
     * <p>
     * An optional pagination token provided by a previous <a>DescribeInstallationMedia</a> request. If this parameter
     * is specified, the response includes only records beyond the marker, up to the value specified by
     * <code>MaxRecords</code>.
     * </p>
     * 
     * @return An optional pagination token provided by a previous <a>DescribeInstallationMedia</a> request. If this
     *         parameter is specified, the response includes only records beyond the marker, up to the value specified
     *         by <code>MaxRecords</code>.
     */
    public final String marker() {
        return marker;
    }

    /**
     * Returns true if the InstallationMedia property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasInstallationMedia() {
        return installationMedia != null && !(installationMedia instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of <a>InstallationMedia</a> objects for the AWS account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInstallationMedia()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of <a>InstallationMedia</a> objects for the AWS account.
     */
    public final List<InstallationMedia> installationMedia() {
        return installationMedia;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(hasInstallationMedia() ? installationMedia() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstallationMediaResponse)) {
            return false;
        }
        DescribeInstallationMediaResponse other = (DescribeInstallationMediaResponse) obj;
        return Objects.equals(marker(), other.marker()) && hasInstallationMedia() == other.hasInstallationMedia()
                && Objects.equals(installationMedia(), other.installationMedia());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeInstallationMediaResponse").add("Marker", marker())
                .add("InstallationMedia", hasInstallationMedia() ? installationMedia() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "InstallationMedia":
            return Optional.ofNullable(clazz.cast(installationMedia()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeInstallationMediaResponse, T> g) {
        return obj -> g.apply((DescribeInstallationMediaResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeInstallationMediaResponse> {
        /**
         * <p>
         * An optional pagination token provided by a previous <a>DescribeInstallationMedia</a> request. If this
         * parameter is specified, the response includes only records beyond the marker, up to the value specified by
         * <code>MaxRecords</code>.
         * </p>
         * 
         * @param marker
         *        An optional pagination token provided by a previous <a>DescribeInstallationMedia</a> request. If this
         *        parameter is specified, the response includes only records beyond the marker, up to the value
         *        specified by <code>MaxRecords</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * The list of <a>InstallationMedia</a> objects for the AWS account.
         * </p>
         * 
         * @param installationMedia
         *        The list of <a>InstallationMedia</a> objects for the AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder installationMedia(Collection<InstallationMedia> installationMedia);

        /**
         * <p>
         * The list of <a>InstallationMedia</a> objects for the AWS account.
         * </p>
         * 
         * @param installationMedia
         *        The list of <a>InstallationMedia</a> objects for the AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder installationMedia(InstallationMedia... installationMedia);

        /**
         * <p>
         * The list of <a>InstallationMedia</a> objects for the AWS account.
         * </p>
         * This is a convenience that creates an instance of the {@link List<InstallationMedia>.Builder} avoiding the
         * need to create one manually via {@link List<InstallationMedia>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InstallationMedia>.Builder#build()} is called immediately
         * and its result is passed to {@link #installationMedia(List<InstallationMedia>)}.
         * 
         * @param installationMedia
         *        a consumer that will call methods on {@link List<InstallationMedia>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #installationMedia(List<InstallationMedia>)
         */
        Builder installationMedia(Consumer<InstallationMedia.Builder>... installationMedia);
    }

    static final class BuilderImpl extends RdsResponse.BuilderImpl implements Builder {
        private String marker;

        private List<InstallationMedia> installationMedia = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstallationMediaResponse model) {
            super(model);
            marker(model.marker);
            installationMedia(model.installationMedia);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final List<InstallationMedia.Builder> getInstallationMedia() {
            List<InstallationMedia.Builder> result = InstallationMediaListCopier.copyToBuilder(this.installationMedia);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder installationMedia(Collection<InstallationMedia> installationMedia) {
            this.installationMedia = InstallationMediaListCopier.copy(installationMedia);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder installationMedia(InstallationMedia... installationMedia) {
            installationMedia(Arrays.asList(installationMedia));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder installationMedia(Consumer<InstallationMedia.Builder>... installationMedia) {
            installationMedia(Stream.of(installationMedia).map(c -> InstallationMedia.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setInstallationMedia(Collection<InstallationMedia.BuilderImpl> installationMedia) {
            this.installationMedia = InstallationMediaListCopier.copyFromBuilder(installationMedia);
        }

        @Override
        public DescribeInstallationMediaResponse build() {
            return new DescribeInstallationMediaResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
