/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteDbProxyResponse extends RdsResponse implements
        ToCopyableBuilder<DeleteDbProxyResponse.Builder, DeleteDbProxyResponse> {
    private static final SdkField<DBProxy> DB_PROXY_FIELD = SdkField.<DBProxy> builder(MarshallingType.SDK_POJO)
            .memberName("DBProxy").getter(getter(DeleteDbProxyResponse::dbProxy)).setter(setter(Builder::dbProxy))
            .constructor(DBProxy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBProxy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_PROXY_FIELD));

    private final DBProxy dbProxy;

    private DeleteDbProxyResponse(BuilderImpl builder) {
        super(builder);
        this.dbProxy = builder.dbProxy;
    }

    /**
     * <p>
     * The data structure representing the details of the DB proxy that you delete.
     * </p>
     * 
     * @return The data structure representing the details of the DB proxy that you delete.
     */
    public final DBProxy dbProxy() {
        return dbProxy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dbProxy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteDbProxyResponse)) {
            return false;
        }
        DeleteDbProxyResponse other = (DeleteDbProxyResponse) obj;
        return Objects.equals(dbProxy(), other.dbProxy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteDbProxyResponse").add("DBProxy", dbProxy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBProxy":
            return Optional.ofNullable(clazz.cast(dbProxy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteDbProxyResponse, T> g) {
        return obj -> g.apply((DeleteDbProxyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeleteDbProxyResponse> {
        /**
         * <p>
         * The data structure representing the details of the DB proxy that you delete.
         * </p>
         * 
         * @param dbProxy
         *        The data structure representing the details of the DB proxy that you delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbProxy(DBProxy dbProxy);

        /**
         * <p>
         * The data structure representing the details of the DB proxy that you delete.
         * </p>
         * This is a convenience that creates an instance of the {@link DBProxy.Builder} avoiding the need to create one
         * manually via {@link DBProxy#builder()}.
         *
         * When the {@link Consumer} completes, {@link DBProxy.Builder#build()} is called immediately and its result is
         * passed to {@link #dbProxy(DBProxy)}.
         * 
         * @param dbProxy
         *        a consumer that will call methods on {@link DBProxy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dbProxy(DBProxy)
         */
        default Builder dbProxy(Consumer<DBProxy.Builder> dbProxy) {
            return dbProxy(DBProxy.builder().applyMutation(dbProxy).build());
        }
    }

    static final class BuilderImpl extends RdsResponse.BuilderImpl implements Builder {
        private DBProxy dbProxy;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteDbProxyResponse model) {
            super(model);
            dbProxy(model.dbProxy);
        }

        public final DBProxy.Builder getDbProxy() {
            return dbProxy != null ? dbProxy.toBuilder() : null;
        }

        @Override
        public final Builder dbProxy(DBProxy dbProxy) {
            this.dbProxy = dbProxy;
            return this;
        }

        public final void setDbProxy(DBProxy.BuilderImpl dbProxy) {
            this.dbProxy = dbProxy != null ? dbProxy.build() : null;
        }

        @Override
        public DeleteDbProxyResponse build() {
            return new DeleteDbProxyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
