/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rds.model.RdsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteDbInstanceRequest
extends RdsRequest
implements ToCopyableBuilder<Builder, DeleteDbInstanceRequest> {
    private static final SdkField<String> DB_INSTANCE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBInstanceIdentifier").getter(DeleteDbInstanceRequest.getter(DeleteDbInstanceRequest::dbInstanceIdentifier)).setter(DeleteDbInstanceRequest.setter(Builder::dbInstanceIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceIdentifier").build()}).build();
    private static final SdkField<Boolean> SKIP_FINAL_SNAPSHOT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SkipFinalSnapshot").getter(DeleteDbInstanceRequest.getter(DeleteDbInstanceRequest::skipFinalSnapshot)).setter(DeleteDbInstanceRequest.setter(Builder::skipFinalSnapshot)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SkipFinalSnapshot").build()}).build();
    private static final SdkField<String> FINAL_DB_SNAPSHOT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FinalDBSnapshotIdentifier").getter(DeleteDbInstanceRequest.getter(DeleteDbInstanceRequest::finalDBSnapshotIdentifier)).setter(DeleteDbInstanceRequest.setter(Builder::finalDBSnapshotIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FinalDBSnapshotIdentifier").build()}).build();
    private static final SdkField<Boolean> DELETE_AUTOMATED_BACKUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DeleteAutomatedBackups").getter(DeleteDbInstanceRequest.getter(DeleteDbInstanceRequest::deleteAutomatedBackups)).setter(DeleteDbInstanceRequest.setter(Builder::deleteAutomatedBackups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteAutomatedBackups").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_INSTANCE_IDENTIFIER_FIELD, SKIP_FINAL_SNAPSHOT_FIELD, FINAL_DB_SNAPSHOT_IDENTIFIER_FIELD, DELETE_AUTOMATED_BACKUPS_FIELD));
    private final String dbInstanceIdentifier;
    private final Boolean skipFinalSnapshot;
    private final String finalDBSnapshotIdentifier;
    private final Boolean deleteAutomatedBackups;

    private DeleteDbInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.dbInstanceIdentifier = builder.dbInstanceIdentifier;
        this.skipFinalSnapshot = builder.skipFinalSnapshot;
        this.finalDBSnapshotIdentifier = builder.finalDBSnapshotIdentifier;
        this.deleteAutomatedBackups = builder.deleteAutomatedBackups;
    }

    public String dbInstanceIdentifier() {
        return this.dbInstanceIdentifier;
    }

    public Boolean skipFinalSnapshot() {
        return this.skipFinalSnapshot;
    }

    public String finalDBSnapshotIdentifier() {
        return this.finalDBSnapshotIdentifier;
    }

    public Boolean deleteAutomatedBackups() {
        return this.deleteAutomatedBackups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dbInstanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.skipFinalSnapshot());
        hashCode = 31 * hashCode + Objects.hashCode(this.finalDBSnapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteAutomatedBackups());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteDbInstanceRequest)) {
            return false;
        }
        DeleteDbInstanceRequest other = (DeleteDbInstanceRequest)((Object)obj);
        return Objects.equals(this.dbInstanceIdentifier(), other.dbInstanceIdentifier()) && Objects.equals(this.skipFinalSnapshot(), other.skipFinalSnapshot()) && Objects.equals(this.finalDBSnapshotIdentifier(), other.finalDBSnapshotIdentifier()) && Objects.equals(this.deleteAutomatedBackups(), other.deleteAutomatedBackups());
    }

    public String toString() {
        return ToString.builder((String)"DeleteDbInstanceRequest").add("DBInstanceIdentifier", (Object)this.dbInstanceIdentifier()).add("SkipFinalSnapshot", (Object)this.skipFinalSnapshot()).add("FinalDBSnapshotIdentifier", (Object)this.finalDBSnapshotIdentifier()).add("DeleteAutomatedBackups", (Object)this.deleteAutomatedBackups()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBInstanceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbInstanceIdentifier()));
            }
            case "SkipFinalSnapshot": {
                return Optional.ofNullable(clazz.cast(this.skipFinalSnapshot()));
            }
            case "FinalDBSnapshotIdentifier": {
                return Optional.ofNullable(clazz.cast(this.finalDBSnapshotIdentifier()));
            }
            case "DeleteAutomatedBackups": {
                return Optional.ofNullable(clazz.cast(this.deleteAutomatedBackups()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteDbInstanceRequest, T> g) {
        return obj -> g.apply((DeleteDbInstanceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsRequest.BuilderImpl
    implements Builder {
        private String dbInstanceIdentifier;
        private Boolean skipFinalSnapshot;
        private String finalDBSnapshotIdentifier;
        private Boolean deleteAutomatedBackups;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteDbInstanceRequest model) {
            super(model);
            this.dbInstanceIdentifier(model.dbInstanceIdentifier);
            this.skipFinalSnapshot(model.skipFinalSnapshot);
            this.finalDBSnapshotIdentifier(model.finalDBSnapshotIdentifier);
            this.deleteAutomatedBackups(model.deleteAutomatedBackups);
        }

        public final String getDbInstanceIdentifier() {
            return this.dbInstanceIdentifier;
        }

        @Override
        public final Builder dbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
            return this;
        }

        public final void setDbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
        }

        public final Boolean getSkipFinalSnapshot() {
            return this.skipFinalSnapshot;
        }

        @Override
        public final Builder skipFinalSnapshot(Boolean skipFinalSnapshot) {
            this.skipFinalSnapshot = skipFinalSnapshot;
            return this;
        }

        public final void setSkipFinalSnapshot(Boolean skipFinalSnapshot) {
            this.skipFinalSnapshot = skipFinalSnapshot;
        }

        public final String getFinalDBSnapshotIdentifier() {
            return this.finalDBSnapshotIdentifier;
        }

        @Override
        public final Builder finalDBSnapshotIdentifier(String finalDBSnapshotIdentifier) {
            this.finalDBSnapshotIdentifier = finalDBSnapshotIdentifier;
            return this;
        }

        public final void setFinalDBSnapshotIdentifier(String finalDBSnapshotIdentifier) {
            this.finalDBSnapshotIdentifier = finalDBSnapshotIdentifier;
        }

        public final Boolean getDeleteAutomatedBackups() {
            return this.deleteAutomatedBackups;
        }

        @Override
        public final Builder deleteAutomatedBackups(Boolean deleteAutomatedBackups) {
            this.deleteAutomatedBackups = deleteAutomatedBackups;
            return this;
        }

        public final void setDeleteAutomatedBackups(Boolean deleteAutomatedBackups) {
            this.deleteAutomatedBackups = deleteAutomatedBackups;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteDbInstanceRequest build() {
            return new DeleteDbInstanceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RdsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteDbInstanceRequest> {
        public Builder dbInstanceIdentifier(String var1);

        public Builder skipFinalSnapshot(Boolean var1);

        public Builder finalDBSnapshotIdentifier(String var1);

        public Builder deleteAutomatedBackups(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

