/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rds.model.TargetHealth;
import software.amazon.awssdk.services.rds.model.TargetType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DBProxyTarget
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DBProxyTarget> {
    private static final SdkField<String> TARGET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetArn").getter(DBProxyTarget.getter(DBProxyTarget::targetArn)).setter(DBProxyTarget.setter(Builder::targetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetArn").build()}).build();
    private static final SdkField<String> ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Endpoint").getter(DBProxyTarget.getter(DBProxyTarget::endpoint)).setter(DBProxyTarget.setter(Builder::endpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoint").build()}).build();
    private static final SdkField<String> TRACKED_CLUSTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrackedClusterId").getter(DBProxyTarget.getter(DBProxyTarget::trackedClusterId)).setter(DBProxyTarget.setter(Builder::trackedClusterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrackedClusterId").build()}).build();
    private static final SdkField<String> RDS_RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RdsResourceId").getter(DBProxyTarget.getter(DBProxyTarget::rdsResourceId)).setter(DBProxyTarget.setter(Builder::rdsResourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RdsResourceId").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Port").getter(DBProxyTarget.getter(DBProxyTarget::port)).setter(DBProxyTarget.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(DBProxyTarget.getter(DBProxyTarget::typeAsString)).setter(DBProxyTarget.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<TargetHealth> TARGET_HEALTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TargetHealth").getter(DBProxyTarget.getter(DBProxyTarget::targetHealth)).setter(DBProxyTarget.setter(Builder::targetHealth)).constructor(TargetHealth::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetHealth").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_ARN_FIELD, ENDPOINT_FIELD, TRACKED_CLUSTER_ID_FIELD, RDS_RESOURCE_ID_FIELD, PORT_FIELD, TYPE_FIELD, TARGET_HEALTH_FIELD));
    private static final long serialVersionUID = 1L;
    private final String targetArn;
    private final String endpoint;
    private final String trackedClusterId;
    private final String rdsResourceId;
    private final Integer port;
    private final String type;
    private final TargetHealth targetHealth;

    private DBProxyTarget(BuilderImpl builder) {
        this.targetArn = builder.targetArn;
        this.endpoint = builder.endpoint;
        this.trackedClusterId = builder.trackedClusterId;
        this.rdsResourceId = builder.rdsResourceId;
        this.port = builder.port;
        this.type = builder.type;
        this.targetHealth = builder.targetHealth;
    }

    public String targetArn() {
        return this.targetArn;
    }

    public String endpoint() {
        return this.endpoint;
    }

    public String trackedClusterId() {
        return this.trackedClusterId;
    }

    public String rdsResourceId() {
        return this.rdsResourceId;
    }

    public Integer port() {
        return this.port;
    }

    public TargetType type() {
        return TargetType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public TargetHealth targetHealth() {
        return this.targetHealth;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.targetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.trackedClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.rdsResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetHealth());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBProxyTarget)) {
            return false;
        }
        DBProxyTarget other = (DBProxyTarget)obj;
        return Objects.equals(this.targetArn(), other.targetArn()) && Objects.equals(this.endpoint(), other.endpoint()) && Objects.equals(this.trackedClusterId(), other.trackedClusterId()) && Objects.equals(this.rdsResourceId(), other.rdsResourceId()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.targetHealth(), other.targetHealth());
    }

    public String toString() {
        return ToString.builder((String)"DBProxyTarget").add("TargetArn", (Object)this.targetArn()).add("Endpoint", (Object)this.endpoint()).add("TrackedClusterId", (Object)this.trackedClusterId()).add("RdsResourceId", (Object)this.rdsResourceId()).add("Port", (Object)this.port()).add("Type", (Object)this.typeAsString()).add("TargetHealth", (Object)this.targetHealth()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TargetArn": {
                return Optional.ofNullable(clazz.cast(this.targetArn()));
            }
            case "Endpoint": {
                return Optional.ofNullable(clazz.cast(this.endpoint()));
            }
            case "TrackedClusterId": {
                return Optional.ofNullable(clazz.cast(this.trackedClusterId()));
            }
            case "RdsResourceId": {
                return Optional.ofNullable(clazz.cast(this.rdsResourceId()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "TargetHealth": {
                return Optional.ofNullable(clazz.cast(this.targetHealth()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DBProxyTarget, T> g) {
        return obj -> g.apply((DBProxyTarget)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String targetArn;
        private String endpoint;
        private String trackedClusterId;
        private String rdsResourceId;
        private Integer port;
        private String type;
        private TargetHealth targetHealth;

        private BuilderImpl() {
        }

        private BuilderImpl(DBProxyTarget model) {
            this.targetArn(model.targetArn);
            this.endpoint(model.endpoint);
            this.trackedClusterId(model.trackedClusterId);
            this.rdsResourceId(model.rdsResourceId);
            this.port(model.port);
            this.type(model.type);
            this.targetHealth(model.targetHealth);
        }

        public final String getTargetArn() {
            return this.targetArn;
        }

        @Override
        public final Builder targetArn(String targetArn) {
            this.targetArn = targetArn;
            return this;
        }

        public final void setTargetArn(String targetArn) {
            this.targetArn = targetArn;
        }

        public final String getEndpoint() {
            return this.endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public final String getTrackedClusterId() {
            return this.trackedClusterId;
        }

        @Override
        public final Builder trackedClusterId(String trackedClusterId) {
            this.trackedClusterId = trackedClusterId;
            return this;
        }

        public final void setTrackedClusterId(String trackedClusterId) {
            this.trackedClusterId = trackedClusterId;
        }

        public final String getRdsResourceId() {
            return this.rdsResourceId;
        }

        @Override
        public final Builder rdsResourceId(String rdsResourceId) {
            this.rdsResourceId = rdsResourceId;
            return this;
        }

        public final void setRdsResourceId(String rdsResourceId) {
            this.rdsResourceId = rdsResourceId;
        }

        public final Integer getPort() {
            return this.port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(TargetType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final TargetHealth.Builder getTargetHealth() {
            return this.targetHealth != null ? this.targetHealth.toBuilder() : null;
        }

        @Override
        public final Builder targetHealth(TargetHealth targetHealth) {
            this.targetHealth = targetHealth;
            return this;
        }

        public final void setTargetHealth(TargetHealth.BuilderImpl targetHealth) {
            this.targetHealth = targetHealth != null ? targetHealth.build() : null;
        }

        public DBProxyTarget build() {
            return new DBProxyTarget(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DBProxyTarget> {
        public Builder targetArn(String var1);

        public Builder endpoint(String var1);

        public Builder trackedClusterId(String var1);

        public Builder rdsResourceId(String var1);

        public Builder port(Integer var1);

        public Builder type(String var1);

        public Builder type(TargetType var1);

        public Builder targetHealth(TargetHealth var1);

        default public Builder targetHealth(Consumer<TargetHealth.Builder> targetHealth) {
            return this.targetHealth((TargetHealth)((TargetHealth.Builder)TargetHealth.builder().applyMutation(targetHealth)).build());
        }
    }
}

