/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rds.model.RdsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BacktrackDbClusterResponse
extends RdsResponse
implements ToCopyableBuilder<Builder, BacktrackDbClusterResponse> {
    private static final SdkField<String> DB_CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBClusterIdentifier").getter(BacktrackDbClusterResponse.getter(BacktrackDbClusterResponse::dbClusterIdentifier)).setter(BacktrackDbClusterResponse.setter(Builder::dbClusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterIdentifier").build()}).build();
    private static final SdkField<String> BACKTRACK_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BacktrackIdentifier").getter(BacktrackDbClusterResponse.getter(BacktrackDbClusterResponse::backtrackIdentifier)).setter(BacktrackDbClusterResponse.setter(Builder::backtrackIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BacktrackIdentifier").build()}).build();
    private static final SdkField<Instant> BACKTRACK_TO_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("BacktrackTo").getter(BacktrackDbClusterResponse.getter(BacktrackDbClusterResponse::backtrackTo)).setter(BacktrackDbClusterResponse.setter(Builder::backtrackTo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BacktrackTo").build()}).build();
    private static final SdkField<Instant> BACKTRACKED_FROM_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("BacktrackedFrom").getter(BacktrackDbClusterResponse.getter(BacktrackDbClusterResponse::backtrackedFrom)).setter(BacktrackDbClusterResponse.setter(Builder::backtrackedFrom)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BacktrackedFrom").build()}).build();
    private static final SdkField<Instant> BACKTRACK_REQUEST_CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("BacktrackRequestCreationTime").getter(BacktrackDbClusterResponse.getter(BacktrackDbClusterResponse::backtrackRequestCreationTime)).setter(BacktrackDbClusterResponse.setter(Builder::backtrackRequestCreationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BacktrackRequestCreationTime").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(BacktrackDbClusterResponse.getter(BacktrackDbClusterResponse::status)).setter(BacktrackDbClusterResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_CLUSTER_IDENTIFIER_FIELD, BACKTRACK_IDENTIFIER_FIELD, BACKTRACK_TO_FIELD, BACKTRACKED_FROM_FIELD, BACKTRACK_REQUEST_CREATION_TIME_FIELD, STATUS_FIELD));
    private final String dbClusterIdentifier;
    private final String backtrackIdentifier;
    private final Instant backtrackTo;
    private final Instant backtrackedFrom;
    private final Instant backtrackRequestCreationTime;
    private final String status;

    private BacktrackDbClusterResponse(BuilderImpl builder) {
        super(builder);
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.backtrackIdentifier = builder.backtrackIdentifier;
        this.backtrackTo = builder.backtrackTo;
        this.backtrackedFrom = builder.backtrackedFrom;
        this.backtrackRequestCreationTime = builder.backtrackRequestCreationTime;
        this.status = builder.status;
    }

    public String dbClusterIdentifier() {
        return this.dbClusterIdentifier;
    }

    public String backtrackIdentifier() {
        return this.backtrackIdentifier;
    }

    public Instant backtrackTo() {
        return this.backtrackTo;
    }

    public Instant backtrackedFrom() {
        return this.backtrackedFrom;
    }

    public Instant backtrackRequestCreationTime() {
        return this.backtrackRequestCreationTime;
    }

    public String status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.backtrackIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.backtrackTo());
        hashCode = 31 * hashCode + Objects.hashCode(this.backtrackedFrom());
        hashCode = 31 * hashCode + Objects.hashCode(this.backtrackRequestCreationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BacktrackDbClusterResponse)) {
            return false;
        }
        BacktrackDbClusterResponse other = (BacktrackDbClusterResponse)((Object)obj);
        return Objects.equals(this.dbClusterIdentifier(), other.dbClusterIdentifier()) && Objects.equals(this.backtrackIdentifier(), other.backtrackIdentifier()) && Objects.equals(this.backtrackTo(), other.backtrackTo()) && Objects.equals(this.backtrackedFrom(), other.backtrackedFrom()) && Objects.equals(this.backtrackRequestCreationTime(), other.backtrackRequestCreationTime()) && Objects.equals(this.status(), other.status());
    }

    public String toString() {
        return ToString.builder((String)"BacktrackDbClusterResponse").add("DBClusterIdentifier", (Object)this.dbClusterIdentifier()).add("BacktrackIdentifier", (Object)this.backtrackIdentifier()).add("BacktrackTo", (Object)this.backtrackTo()).add("BacktrackedFrom", (Object)this.backtrackedFrom()).add("BacktrackRequestCreationTime", (Object)this.backtrackRequestCreationTime()).add("Status", (Object)this.status()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbClusterIdentifier()));
            }
            case "BacktrackIdentifier": {
                return Optional.ofNullable(clazz.cast(this.backtrackIdentifier()));
            }
            case "BacktrackTo": {
                return Optional.ofNullable(clazz.cast(this.backtrackTo()));
            }
            case "BacktrackedFrom": {
                return Optional.ofNullable(clazz.cast(this.backtrackedFrom()));
            }
            case "BacktrackRequestCreationTime": {
                return Optional.ofNullable(clazz.cast(this.backtrackRequestCreationTime()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BacktrackDbClusterResponse, T> g) {
        return obj -> g.apply((BacktrackDbClusterResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsResponse.BuilderImpl
    implements Builder {
        private String dbClusterIdentifier;
        private String backtrackIdentifier;
        private Instant backtrackTo;
        private Instant backtrackedFrom;
        private Instant backtrackRequestCreationTime;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(BacktrackDbClusterResponse model) {
            super(model);
            this.dbClusterIdentifier(model.dbClusterIdentifier);
            this.backtrackIdentifier(model.backtrackIdentifier);
            this.backtrackTo(model.backtrackTo);
            this.backtrackedFrom(model.backtrackedFrom);
            this.backtrackRequestCreationTime(model.backtrackRequestCreationTime);
            this.status(model.status);
        }

        public final String getDbClusterIdentifier() {
            return this.dbClusterIdentifier;
        }

        @Override
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final void setDbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        public final String getBacktrackIdentifier() {
            return this.backtrackIdentifier;
        }

        @Override
        public final Builder backtrackIdentifier(String backtrackIdentifier) {
            this.backtrackIdentifier = backtrackIdentifier;
            return this;
        }

        public final void setBacktrackIdentifier(String backtrackIdentifier) {
            this.backtrackIdentifier = backtrackIdentifier;
        }

        public final Instant getBacktrackTo() {
            return this.backtrackTo;
        }

        @Override
        public final Builder backtrackTo(Instant backtrackTo) {
            this.backtrackTo = backtrackTo;
            return this;
        }

        public final void setBacktrackTo(Instant backtrackTo) {
            this.backtrackTo = backtrackTo;
        }

        public final Instant getBacktrackedFrom() {
            return this.backtrackedFrom;
        }

        @Override
        public final Builder backtrackedFrom(Instant backtrackedFrom) {
            this.backtrackedFrom = backtrackedFrom;
            return this;
        }

        public final void setBacktrackedFrom(Instant backtrackedFrom) {
            this.backtrackedFrom = backtrackedFrom;
        }

        public final Instant getBacktrackRequestCreationTime() {
            return this.backtrackRequestCreationTime;
        }

        @Override
        public final Builder backtrackRequestCreationTime(Instant backtrackRequestCreationTime) {
            this.backtrackRequestCreationTime = backtrackRequestCreationTime;
            return this;
        }

        public final void setBacktrackRequestCreationTime(Instant backtrackRequestCreationTime) {
            this.backtrackRequestCreationTime = backtrackRequestCreationTime;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public BacktrackDbClusterResponse build() {
            return new BacktrackDbClusterResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RdsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BacktrackDbClusterResponse> {
        public Builder dbClusterIdentifier(String var1);

        public Builder backtrackIdentifier(String var1);

        public Builder backtrackTo(Instant var1);

        public Builder backtrackedFrom(Instant var1);

        public Builder backtrackRequestCreationTime(Instant var1);

        public Builder status(String var1);
    }
}

