/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.rds.model.RebootDBInstanceRequest;
import software.amazon.awssdk.util.StringUtils;

public class RebootDBInstanceRequestMarshaller
implements Marshaller<Request<RebootDBInstanceRequest>, RebootDBInstanceRequest> {
    public Request<RebootDBInstanceRequest> marshall(RebootDBInstanceRequest rebootDBInstanceRequest) {
        if (rebootDBInstanceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)rebootDBInstanceRequest, "RDSClient");
        request.addParameter("Action", "RebootDBInstance");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (rebootDBInstanceRequest.dbInstanceIdentifier() != null) {
            request.addParameter("DBInstanceIdentifier", StringUtils.fromString((String)rebootDBInstanceRequest.dbInstanceIdentifier()));
        }
        if (rebootDBInstanceRequest.forceFailover() != null) {
            request.addParameter("ForceFailover", StringUtils.fromBoolean((Boolean)rebootDBInstanceRequest.forceFailover()));
        }
        return request;
    }
}

