/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.rds.model.AddTagsToResourceRequest;
import software.amazon.awssdk.services.rds.model.Tag;
import software.amazon.awssdk.util.StringUtils;

public class AddTagsToResourceRequestMarshaller
implements Marshaller<Request<AddTagsToResourceRequest>, AddTagsToResourceRequest> {
    public Request<AddTagsToResourceRequest> marshall(AddTagsToResourceRequest addTagsToResourceRequest) {
        List<Tag> tagsList;
        if (addTagsToResourceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)addTagsToResourceRequest, "RDSClient");
        request.addParameter("Action", "AddTagsToResource");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (addTagsToResourceRequest.resourceName() != null) {
            request.addParameter("ResourceName", StringUtils.fromString((String)addTagsToResourceRequest.resourceName()));
        }
        if ((tagsList = addTagsToResourceRequest.tags()) != null) {
            if (!tagsList.isEmpty()) {
                int tagsListIndex = 1;
                for (Tag tagsListValue : tagsList) {
                    if (tagsListValue.key() != null) {
                        request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.key()));
                    }
                    if (tagsListValue.value() != null) {
                        request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.value()));
                    }
                    ++tagsListIndex;
                }
            } else {
                request.addParameter("Tags", "");
            }
        }
        return request;
    }
}

