/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.rds.model.OptionGroupOptionSetting;
import software.amazon.awssdk.services.rds.model.OptionGroupOptionSettingsListCopier;
import software.amazon.awssdk.services.rds.model.OptionGroupOptionVersionsListCopier;
import software.amazon.awssdk.services.rds.model.OptionVersion;
import software.amazon.awssdk.services.rds.model.OptionsConflictsWithCopier;
import software.amazon.awssdk.services.rds.model.OptionsDependedOnCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class OptionGroupOption
implements ToCopyableBuilder<Builder, OptionGroupOption> {
    private final String name;
    private final String description;
    private final String engineName;
    private final String majorEngineVersion;
    private final String minimumRequiredMinorEngineVersion;
    private final Boolean portRequired;
    private final Integer defaultPort;
    private final List<String> optionsDependedOn;
    private final List<String> optionsConflictsWith;
    private final Boolean persistent;
    private final Boolean permanent;
    private final List<OptionGroupOptionSetting> optionGroupOptionSettings;
    private final List<OptionVersion> optionGroupOptionVersions;

    private OptionGroupOption(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.engineName = builder.engineName;
        this.majorEngineVersion = builder.majorEngineVersion;
        this.minimumRequiredMinorEngineVersion = builder.minimumRequiredMinorEngineVersion;
        this.portRequired = builder.portRequired;
        this.defaultPort = builder.defaultPort;
        this.optionsDependedOn = builder.optionsDependedOn;
        this.optionsConflictsWith = builder.optionsConflictsWith;
        this.persistent = builder.persistent;
        this.permanent = builder.permanent;
        this.optionGroupOptionSettings = builder.optionGroupOptionSettings;
        this.optionGroupOptionVersions = builder.optionGroupOptionVersions;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public String engineName() {
        return this.engineName;
    }

    public String majorEngineVersion() {
        return this.majorEngineVersion;
    }

    public String minimumRequiredMinorEngineVersion() {
        return this.minimumRequiredMinorEngineVersion;
    }

    public Boolean portRequired() {
        return this.portRequired;
    }

    public Integer defaultPort() {
        return this.defaultPort;
    }

    public List<String> optionsDependedOn() {
        return this.optionsDependedOn;
    }

    public List<String> optionsConflictsWith() {
        return this.optionsConflictsWith;
    }

    public Boolean persistent() {
        return this.persistent;
    }

    public Boolean permanent() {
        return this.permanent;
    }

    public List<OptionGroupOptionSetting> optionGroupOptionSettings() {
        return this.optionGroupOptionSettings;
    }

    public List<OptionVersion> optionGroupOptionVersions() {
        return this.optionGroupOptionVersions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.engineName() == null ? 0 : this.engineName().hashCode());
        hashCode = 31 * hashCode + (this.majorEngineVersion() == null ? 0 : this.majorEngineVersion().hashCode());
        hashCode = 31 * hashCode + (this.minimumRequiredMinorEngineVersion() == null ? 0 : this.minimumRequiredMinorEngineVersion().hashCode());
        hashCode = 31 * hashCode + (this.portRequired() == null ? 0 : this.portRequired().hashCode());
        hashCode = 31 * hashCode + (this.defaultPort() == null ? 0 : this.defaultPort().hashCode());
        hashCode = 31 * hashCode + (this.optionsDependedOn() == null ? 0 : this.optionsDependedOn().hashCode());
        hashCode = 31 * hashCode + (this.optionsConflictsWith() == null ? 0 : this.optionsConflictsWith().hashCode());
        hashCode = 31 * hashCode + (this.persistent() == null ? 0 : this.persistent().hashCode());
        hashCode = 31 * hashCode + (this.permanent() == null ? 0 : this.permanent().hashCode());
        hashCode = 31 * hashCode + (this.optionGroupOptionSettings() == null ? 0 : this.optionGroupOptionSettings().hashCode());
        hashCode = 31 * hashCode + (this.optionGroupOptionVersions() == null ? 0 : this.optionGroupOptionVersions().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OptionGroupOption)) {
            return false;
        }
        OptionGroupOption other = (OptionGroupOption)obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.engineName() == null ^ this.engineName() == null) {
            return false;
        }
        if (other.engineName() != null && !other.engineName().equals(this.engineName())) {
            return false;
        }
        if (other.majorEngineVersion() == null ^ this.majorEngineVersion() == null) {
            return false;
        }
        if (other.majorEngineVersion() != null && !other.majorEngineVersion().equals(this.majorEngineVersion())) {
            return false;
        }
        if (other.minimumRequiredMinorEngineVersion() == null ^ this.minimumRequiredMinorEngineVersion() == null) {
            return false;
        }
        if (other.minimumRequiredMinorEngineVersion() != null && !other.minimumRequiredMinorEngineVersion().equals(this.minimumRequiredMinorEngineVersion())) {
            return false;
        }
        if (other.portRequired() == null ^ this.portRequired() == null) {
            return false;
        }
        if (other.portRequired() != null && !other.portRequired().equals(this.portRequired())) {
            return false;
        }
        if (other.defaultPort() == null ^ this.defaultPort() == null) {
            return false;
        }
        if (other.defaultPort() != null && !other.defaultPort().equals(this.defaultPort())) {
            return false;
        }
        if (other.optionsDependedOn() == null ^ this.optionsDependedOn() == null) {
            return false;
        }
        if (other.optionsDependedOn() != null && !other.optionsDependedOn().equals(this.optionsDependedOn())) {
            return false;
        }
        if (other.optionsConflictsWith() == null ^ this.optionsConflictsWith() == null) {
            return false;
        }
        if (other.optionsConflictsWith() != null && !other.optionsConflictsWith().equals(this.optionsConflictsWith())) {
            return false;
        }
        if (other.persistent() == null ^ this.persistent() == null) {
            return false;
        }
        if (other.persistent() != null && !other.persistent().equals(this.persistent())) {
            return false;
        }
        if (other.permanent() == null ^ this.permanent() == null) {
            return false;
        }
        if (other.permanent() != null && !other.permanent().equals(this.permanent())) {
            return false;
        }
        if (other.optionGroupOptionSettings() == null ^ this.optionGroupOptionSettings() == null) {
            return false;
        }
        if (other.optionGroupOptionSettings() != null && !other.optionGroupOptionSettings().equals(this.optionGroupOptionSettings())) {
            return false;
        }
        if (other.optionGroupOptionVersions() == null ^ this.optionGroupOptionVersions() == null) {
            return false;
        }
        return other.optionGroupOptionVersions() == null || other.optionGroupOptionVersions().equals(this.optionGroupOptionVersions());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.engineName() != null) {
            sb.append("EngineName: ").append(this.engineName()).append(",");
        }
        if (this.majorEngineVersion() != null) {
            sb.append("MajorEngineVersion: ").append(this.majorEngineVersion()).append(",");
        }
        if (this.minimumRequiredMinorEngineVersion() != null) {
            sb.append("MinimumRequiredMinorEngineVersion: ").append(this.minimumRequiredMinorEngineVersion()).append(",");
        }
        if (this.portRequired() != null) {
            sb.append("PortRequired: ").append(this.portRequired()).append(",");
        }
        if (this.defaultPort() != null) {
            sb.append("DefaultPort: ").append(this.defaultPort()).append(",");
        }
        if (this.optionsDependedOn() != null) {
            sb.append("OptionsDependedOn: ").append(this.optionsDependedOn()).append(",");
        }
        if (this.optionsConflictsWith() != null) {
            sb.append("OptionsConflictsWith: ").append(this.optionsConflictsWith()).append(",");
        }
        if (this.persistent() != null) {
            sb.append("Persistent: ").append(this.persistent()).append(",");
        }
        if (this.permanent() != null) {
            sb.append("Permanent: ").append(this.permanent()).append(",");
        }
        if (this.optionGroupOptionSettings() != null) {
            sb.append("OptionGroupOptionSettings: ").append(this.optionGroupOptionSettings()).append(",");
        }
        if (this.optionGroupOptionVersions() != null) {
            sb.append("OptionGroupOptionVersions: ").append(this.optionGroupOptionVersions()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String engineName;
        private String majorEngineVersion;
        private String minimumRequiredMinorEngineVersion;
        private Boolean portRequired;
        private Integer defaultPort;
        private List<String> optionsDependedOn;
        private List<String> optionsConflictsWith;
        private Boolean persistent;
        private Boolean permanent;
        private List<OptionGroupOptionSetting> optionGroupOptionSettings;
        private List<OptionVersion> optionGroupOptionVersions;

        private BuilderImpl() {
        }

        private BuilderImpl(OptionGroupOption model) {
            this.setName(model.name);
            this.setDescription(model.description);
            this.setEngineName(model.engineName);
            this.setMajorEngineVersion(model.majorEngineVersion);
            this.setMinimumRequiredMinorEngineVersion(model.minimumRequiredMinorEngineVersion);
            this.setPortRequired(model.portRequired);
            this.setDefaultPort(model.defaultPort);
            this.setOptionsDependedOn(model.optionsDependedOn);
            this.setOptionsConflictsWith(model.optionsConflictsWith);
            this.setPersistent(model.persistent);
            this.setPermanent(model.permanent);
            this.setOptionGroupOptionSettings(model.optionGroupOptionSettings);
            this.setOptionGroupOptionVersions(model.optionGroupOptionVersions);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getEngineName() {
            return this.engineName;
        }

        @Override
        public final Builder engineName(String engineName) {
            this.engineName = engineName;
            return this;
        }

        public final void setEngineName(String engineName) {
            this.engineName = engineName;
        }

        public final String getMajorEngineVersion() {
            return this.majorEngineVersion;
        }

        @Override
        public final Builder majorEngineVersion(String majorEngineVersion) {
            this.majorEngineVersion = majorEngineVersion;
            return this;
        }

        public final void setMajorEngineVersion(String majorEngineVersion) {
            this.majorEngineVersion = majorEngineVersion;
        }

        public final String getMinimumRequiredMinorEngineVersion() {
            return this.minimumRequiredMinorEngineVersion;
        }

        @Override
        public final Builder minimumRequiredMinorEngineVersion(String minimumRequiredMinorEngineVersion) {
            this.minimumRequiredMinorEngineVersion = minimumRequiredMinorEngineVersion;
            return this;
        }

        public final void setMinimumRequiredMinorEngineVersion(String minimumRequiredMinorEngineVersion) {
            this.minimumRequiredMinorEngineVersion = minimumRequiredMinorEngineVersion;
        }

        public final Boolean getPortRequired() {
            return this.portRequired;
        }

        @Override
        public final Builder portRequired(Boolean portRequired) {
            this.portRequired = portRequired;
            return this;
        }

        public final void setPortRequired(Boolean portRequired) {
            this.portRequired = portRequired;
        }

        public final Integer getDefaultPort() {
            return this.defaultPort;
        }

        @Override
        public final Builder defaultPort(Integer defaultPort) {
            this.defaultPort = defaultPort;
            return this;
        }

        public final void setDefaultPort(Integer defaultPort) {
            this.defaultPort = defaultPort;
        }

        public final Collection<String> getOptionsDependedOn() {
            return this.optionsDependedOn;
        }

        @Override
        public final Builder optionsDependedOn(Collection<String> optionsDependedOn) {
            this.optionsDependedOn = OptionsDependedOnCopier.copy(optionsDependedOn);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionsDependedOn(String ... optionsDependedOn) {
            this.optionsDependedOn(Arrays.asList(optionsDependedOn));
            return this;
        }

        public final void setOptionsDependedOn(Collection<String> optionsDependedOn) {
            this.optionsDependedOn = OptionsDependedOnCopier.copy(optionsDependedOn);
        }

        public final Collection<String> getOptionsConflictsWith() {
            return this.optionsConflictsWith;
        }

        @Override
        public final Builder optionsConflictsWith(Collection<String> optionsConflictsWith) {
            this.optionsConflictsWith = OptionsConflictsWithCopier.copy(optionsConflictsWith);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionsConflictsWith(String ... optionsConflictsWith) {
            this.optionsConflictsWith(Arrays.asList(optionsConflictsWith));
            return this;
        }

        public final void setOptionsConflictsWith(Collection<String> optionsConflictsWith) {
            this.optionsConflictsWith = OptionsConflictsWithCopier.copy(optionsConflictsWith);
        }

        public final Boolean getPersistent() {
            return this.persistent;
        }

        @Override
        public final Builder persistent(Boolean persistent) {
            this.persistent = persistent;
            return this;
        }

        public final void setPersistent(Boolean persistent) {
            this.persistent = persistent;
        }

        public final Boolean getPermanent() {
            return this.permanent;
        }

        @Override
        public final Builder permanent(Boolean permanent) {
            this.permanent = permanent;
            return this;
        }

        public final void setPermanent(Boolean permanent) {
            this.permanent = permanent;
        }

        public final Collection<OptionGroupOptionSetting> getOptionGroupOptionSettings() {
            return this.optionGroupOptionSettings;
        }

        @Override
        public final Builder optionGroupOptionSettings(Collection<OptionGroupOptionSetting> optionGroupOptionSettings) {
            this.optionGroupOptionSettings = OptionGroupOptionSettingsListCopier.copy(optionGroupOptionSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionGroupOptionSettings(OptionGroupOptionSetting ... optionGroupOptionSettings) {
            this.optionGroupOptionSettings(Arrays.asList(optionGroupOptionSettings));
            return this;
        }

        public final void setOptionGroupOptionSettings(Collection<OptionGroupOptionSetting> optionGroupOptionSettings) {
            this.optionGroupOptionSettings = OptionGroupOptionSettingsListCopier.copy(optionGroupOptionSettings);
        }

        public final Collection<OptionVersion> getOptionGroupOptionVersions() {
            return this.optionGroupOptionVersions;
        }

        @Override
        public final Builder optionGroupOptionVersions(Collection<OptionVersion> optionGroupOptionVersions) {
            this.optionGroupOptionVersions = OptionGroupOptionVersionsListCopier.copy(optionGroupOptionVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionGroupOptionVersions(OptionVersion ... optionGroupOptionVersions) {
            this.optionGroupOptionVersions(Arrays.asList(optionGroupOptionVersions));
            return this;
        }

        public final void setOptionGroupOptionVersions(Collection<OptionVersion> optionGroupOptionVersions) {
            this.optionGroupOptionVersions = OptionGroupOptionVersionsListCopier.copy(optionGroupOptionVersions);
        }

        public OptionGroupOption build() {
            return new OptionGroupOption(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, OptionGroupOption> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder engineName(String var1);

        public Builder majorEngineVersion(String var1);

        public Builder minimumRequiredMinorEngineVersion(String var1);

        public Builder portRequired(Boolean var1);

        public Builder defaultPort(Integer var1);

        public Builder optionsDependedOn(Collection<String> var1);

        public Builder optionsDependedOn(String ... var1);

        public Builder optionsConflictsWith(Collection<String> var1);

        public Builder optionsConflictsWith(String ... var1);

        public Builder persistent(Boolean var1);

        public Builder permanent(Boolean var1);

        public Builder optionGroupOptionSettings(Collection<OptionGroupOptionSetting> var1);

        public Builder optionGroupOptionSettings(OptionGroupOptionSetting ... var1);

        public Builder optionGroupOptionVersions(Collection<OptionVersion> var1);

        public Builder optionGroupOptionVersions(OptionVersion ... var1);
    }
}

