/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.rds.model.DBClusterParameterGroup;
import software.amazon.awssdk.services.rds.model.DBClusterParameterGroupListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeDBClusterParameterGroupsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeDBClusterParameterGroupsResponse> {
    private final String marker;
    private final List<DBClusterParameterGroup> dbClusterParameterGroups;

    private DescribeDBClusterParameterGroupsResponse(BuilderImpl builder) {
        this.marker = builder.marker;
        this.dbClusterParameterGroups = builder.dbClusterParameterGroups;
    }

    public String marker() {
        return this.marker;
    }

    public List<DBClusterParameterGroup> dbClusterParameterGroups() {
        return this.dbClusterParameterGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        hashCode = 31 * hashCode + (this.dbClusterParameterGroups() == null ? 0 : this.dbClusterParameterGroups().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDBClusterParameterGroupsResponse)) {
            return false;
        }
        DescribeDBClusterParameterGroupsResponse other = (DescribeDBClusterParameterGroupsResponse)((Object)obj);
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        if (other.marker() != null && !other.marker().equals(this.marker())) {
            return false;
        }
        if (other.dbClusterParameterGroups() == null ^ this.dbClusterParameterGroups() == null) {
            return false;
        }
        return other.dbClusterParameterGroups() == null || other.dbClusterParameterGroups().equals(this.dbClusterParameterGroups());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.dbClusterParameterGroups() != null) {
            sb.append("DBClusterParameterGroups: ").append(this.dbClusterParameterGroups()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String marker;
        private List<DBClusterParameterGroup> dbClusterParameterGroups;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDBClusterParameterGroupsResponse model) {
            this.setMarker(model.marker);
            this.setDBClusterParameterGroups(model.dbClusterParameterGroups);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<DBClusterParameterGroup> getDBClusterParameterGroups() {
            return this.dbClusterParameterGroups;
        }

        @Override
        public final Builder dbClusterParameterGroups(Collection<DBClusterParameterGroup> dbClusterParameterGroups) {
            this.dbClusterParameterGroups = DBClusterParameterGroupListCopier.copy(dbClusterParameterGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbClusterParameterGroups(DBClusterParameterGroup ... dbClusterParameterGroups) {
            this.dbClusterParameterGroups(Arrays.asList(dbClusterParameterGroups));
            return this;
        }

        public final void setDBClusterParameterGroups(Collection<DBClusterParameterGroup> dbClusterParameterGroups) {
            this.dbClusterParameterGroups = DBClusterParameterGroupListCopier.copy(dbClusterParameterGroups);
        }

        public DescribeDBClusterParameterGroupsResponse build() {
            return new DescribeDBClusterParameterGroupsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeDBClusterParameterGroupsResponse> {
        public Builder marker(String var1);

        public Builder dbClusterParameterGroups(Collection<DBClusterParameterGroup> var1);

        public Builder dbClusterParameterGroups(DBClusterParameterGroup ... var1);
    }
}

