/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.rds.model.StartDBInstanceRequest;
import software.amazon.awssdk.util.StringUtils;

public class StartDBInstanceRequestMarshaller
implements Marshaller<Request<StartDBInstanceRequest>, StartDBInstanceRequest> {
    public Request<StartDBInstanceRequest> marshall(StartDBInstanceRequest startDBInstanceRequest) {
        if (startDBInstanceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)startDBInstanceRequest, "RDSClient");
        request.addParameter("Action", "StartDBInstance");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (startDBInstanceRequest.dbInstanceIdentifier() != null) {
            request.addParameter("DBInstanceIdentifier", StringUtils.fromString((String)startDBInstanceRequest.dbInstanceIdentifier()));
        }
        return request;
    }
}

