/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.rds.model.ModifyDBSnapshotRequest;
import software.amazon.awssdk.util.StringUtils;

public class ModifyDBSnapshotRequestMarshaller
implements Marshaller<Request<ModifyDBSnapshotRequest>, ModifyDBSnapshotRequest> {
    public Request<ModifyDBSnapshotRequest> marshall(ModifyDBSnapshotRequest modifyDBSnapshotRequest) {
        if (modifyDBSnapshotRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyDBSnapshotRequest, "RDSClient");
        request.addParameter("Action", "ModifyDBSnapshot");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyDBSnapshotRequest.dbSnapshotIdentifier() != null) {
            request.addParameter("DBSnapshotIdentifier", StringUtils.fromString((String)modifyDBSnapshotRequest.dbSnapshotIdentifier()));
        }
        if (modifyDBSnapshotRequest.engineVersion() != null) {
            request.addParameter("EngineVersion", StringUtils.fromString((String)modifyDBSnapshotRequest.engineVersion()));
        }
        return request;
    }
}

