/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.rds.model.AuthorizeDBSecurityGroupIngressRequest;
import software.amazon.awssdk.util.StringUtils;

public class AuthorizeDBSecurityGroupIngressRequestMarshaller
implements Marshaller<Request<AuthorizeDBSecurityGroupIngressRequest>, AuthorizeDBSecurityGroupIngressRequest> {
    public Request<AuthorizeDBSecurityGroupIngressRequest> marshall(AuthorizeDBSecurityGroupIngressRequest authorizeDBSecurityGroupIngressRequest) {
        if (authorizeDBSecurityGroupIngressRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)authorizeDBSecurityGroupIngressRequest, "RDSClient");
        request.addParameter("Action", "AuthorizeDBSecurityGroupIngress");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (authorizeDBSecurityGroupIngressRequest.dbSecurityGroupName() != null) {
            request.addParameter("DBSecurityGroupName", StringUtils.fromString((String)authorizeDBSecurityGroupIngressRequest.dbSecurityGroupName()));
        }
        if (authorizeDBSecurityGroupIngressRequest.cidrip() != null) {
            request.addParameter("CIDRIP", StringUtils.fromString((String)authorizeDBSecurityGroupIngressRequest.cidrip()));
        }
        if (authorizeDBSecurityGroupIngressRequest.ec2SecurityGroupName() != null) {
            request.addParameter("EC2SecurityGroupName", StringUtils.fromString((String)authorizeDBSecurityGroupIngressRequest.ec2SecurityGroupName()));
        }
        if (authorizeDBSecurityGroupIngressRequest.ec2SecurityGroupId() != null) {
            request.addParameter("EC2SecurityGroupId", StringUtils.fromString((String)authorizeDBSecurityGroupIngressRequest.ec2SecurityGroupId()));
        }
        if (authorizeDBSecurityGroupIngressRequest.ec2SecurityGroupOwnerId() != null) {
            request.addParameter("EC2SecurityGroupOwnerId", StringUtils.fromString((String)authorizeDBSecurityGroupIngressRequest.ec2SecurityGroupOwnerId()));
        }
        return request;
    }
}

