/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.rds.model.Event;
import software.amazon.awssdk.services.rds.model.EventListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeEventsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeEventsResponse> {
    private final String marker;
    private final List<Event> events;

    private DescribeEventsResponse(BuilderImpl builder) {
        this.marker = builder.marker;
        this.events = builder.events;
    }

    public String marker() {
        return this.marker;
    }

    public List<Event> events() {
        return this.events;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        hashCode = 31 * hashCode + (this.events() == null ? 0 : this.events().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEventsResponse)) {
            return false;
        }
        DescribeEventsResponse other = (DescribeEventsResponse)((Object)obj);
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        if (other.marker() != null && !other.marker().equals(this.marker())) {
            return false;
        }
        if (other.events() == null ^ this.events() == null) {
            return false;
        }
        return other.events() == null || other.events().equals(this.events());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.events() != null) {
            sb.append("Events: ").append(this.events()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String marker;
        private List<Event> events;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEventsResponse model) {
            this.setMarker(model.marker);
            this.setEvents(model.events);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<Event> getEvents() {
            return this.events;
        }

        @Override
        public final Builder events(Collection<Event> events) {
            this.events = EventListCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(Event ... events) {
            this.events(Arrays.asList(events));
            return this;
        }

        public final void setEvents(Collection<Event> events) {
            this.events = EventListCopier.copy(events);
        }

        public DescribeEventsResponse build() {
            return new DescribeEventsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeEventsResponse> {
        public Builder marker(String var1);

        public Builder events(Collection<Event> var1);

        public Builder events(Event ... var1);
    }
}

