/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.rds.model.Filter;
import software.amazon.awssdk.services.rds.model.FilterListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeDBEngineVersionsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeDBEngineVersionsRequest> {
    private final String engine;
    private final String engineVersion;
    private final String dbParameterGroupFamily;
    private final List<Filter> filters;
    private final Integer maxRecords;
    private final String marker;
    private final Boolean defaultOnly;
    private final Boolean listSupportedCharacterSets;
    private final Boolean listSupportedTimezones;

    private DescribeDBEngineVersionsRequest(BuilderImpl builder) {
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.dbParameterGroupFamily = builder.dbParameterGroupFamily;
        this.filters = builder.filters;
        this.maxRecords = builder.maxRecords;
        this.marker = builder.marker;
        this.defaultOnly = builder.defaultOnly;
        this.listSupportedCharacterSets = builder.listSupportedCharacterSets;
        this.listSupportedTimezones = builder.listSupportedTimezones;
    }

    public String engine() {
        return this.engine;
    }

    public String engineVersion() {
        return this.engineVersion;
    }

    public String dbParameterGroupFamily() {
        return this.dbParameterGroupFamily;
    }

    public List<Filter> filters() {
        return this.filters;
    }

    public Integer maxRecords() {
        return this.maxRecords;
    }

    public String marker() {
        return this.marker;
    }

    public Boolean defaultOnly() {
        return this.defaultOnly;
    }

    public Boolean listSupportedCharacterSets() {
        return this.listSupportedCharacterSets;
    }

    public Boolean listSupportedTimezones() {
        return this.listSupportedTimezones;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.engine() == null ? 0 : this.engine().hashCode());
        hashCode = 31 * hashCode + (this.engineVersion() == null ? 0 : this.engineVersion().hashCode());
        hashCode = 31 * hashCode + (this.dbParameterGroupFamily() == null ? 0 : this.dbParameterGroupFamily().hashCode());
        hashCode = 31 * hashCode + (this.filters() == null ? 0 : this.filters().hashCode());
        hashCode = 31 * hashCode + (this.maxRecords() == null ? 0 : this.maxRecords().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        hashCode = 31 * hashCode + (this.defaultOnly() == null ? 0 : this.defaultOnly().hashCode());
        hashCode = 31 * hashCode + (this.listSupportedCharacterSets() == null ? 0 : this.listSupportedCharacterSets().hashCode());
        hashCode = 31 * hashCode + (this.listSupportedTimezones() == null ? 0 : this.listSupportedTimezones().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDBEngineVersionsRequest)) {
            return false;
        }
        DescribeDBEngineVersionsRequest other = (DescribeDBEngineVersionsRequest)((Object)obj);
        if (other.engine() == null ^ this.engine() == null) {
            return false;
        }
        if (other.engine() != null && !other.engine().equals(this.engine())) {
            return false;
        }
        if (other.engineVersion() == null ^ this.engineVersion() == null) {
            return false;
        }
        if (other.engineVersion() != null && !other.engineVersion().equals(this.engineVersion())) {
            return false;
        }
        if (other.dbParameterGroupFamily() == null ^ this.dbParameterGroupFamily() == null) {
            return false;
        }
        if (other.dbParameterGroupFamily() != null && !other.dbParameterGroupFamily().equals(this.dbParameterGroupFamily())) {
            return false;
        }
        if (other.filters() == null ^ this.filters() == null) {
            return false;
        }
        if (other.filters() != null && !other.filters().equals(this.filters())) {
            return false;
        }
        if (other.maxRecords() == null ^ this.maxRecords() == null) {
            return false;
        }
        if (other.maxRecords() != null && !other.maxRecords().equals(this.maxRecords())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        if (other.marker() != null && !other.marker().equals(this.marker())) {
            return false;
        }
        if (other.defaultOnly() == null ^ this.defaultOnly() == null) {
            return false;
        }
        if (other.defaultOnly() != null && !other.defaultOnly().equals(this.defaultOnly())) {
            return false;
        }
        if (other.listSupportedCharacterSets() == null ^ this.listSupportedCharacterSets() == null) {
            return false;
        }
        if (other.listSupportedCharacterSets() != null && !other.listSupportedCharacterSets().equals(this.listSupportedCharacterSets())) {
            return false;
        }
        if (other.listSupportedTimezones() == null ^ this.listSupportedTimezones() == null) {
            return false;
        }
        return other.listSupportedTimezones() == null || other.listSupportedTimezones().equals(this.listSupportedTimezones());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.engine() != null) {
            sb.append("Engine: ").append(this.engine()).append(",");
        }
        if (this.engineVersion() != null) {
            sb.append("EngineVersion: ").append(this.engineVersion()).append(",");
        }
        if (this.dbParameterGroupFamily() != null) {
            sb.append("DBParameterGroupFamily: ").append(this.dbParameterGroupFamily()).append(",");
        }
        if (this.filters() != null) {
            sb.append("Filters: ").append(this.filters()).append(",");
        }
        if (this.maxRecords() != null) {
            sb.append("MaxRecords: ").append(this.maxRecords()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.defaultOnly() != null) {
            sb.append("DefaultOnly: ").append(this.defaultOnly()).append(",");
        }
        if (this.listSupportedCharacterSets() != null) {
            sb.append("ListSupportedCharacterSets: ").append(this.listSupportedCharacterSets()).append(",");
        }
        if (this.listSupportedTimezones() != null) {
            sb.append("ListSupportedTimezones: ").append(this.listSupportedTimezones()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String engine;
        private String engineVersion;
        private String dbParameterGroupFamily;
        private List<Filter> filters;
        private Integer maxRecords;
        private String marker;
        private Boolean defaultOnly;
        private Boolean listSupportedCharacterSets;
        private Boolean listSupportedTimezones;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDBEngineVersionsRequest model) {
            this.setEngine(model.engine);
            this.setEngineVersion(model.engineVersion);
            this.setDBParameterGroupFamily(model.dbParameterGroupFamily);
            this.setFilters(model.filters);
            this.setMaxRecords(model.maxRecords);
            this.setMarker(model.marker);
            this.setDefaultOnly(model.defaultOnly);
            this.setListSupportedCharacterSets(model.listSupportedCharacterSets);
            this.setListSupportedTimezones(model.listSupportedTimezones);
        }

        public final String getEngine() {
            return this.engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final String getDBParameterGroupFamily() {
            return this.dbParameterGroupFamily;
        }

        @Override
        public final Builder dbParameterGroupFamily(String dbParameterGroupFamily) {
            this.dbParameterGroupFamily = dbParameterGroupFamily;
            return this;
        }

        public final void setDBParameterGroupFamily(String dbParameterGroupFamily) {
            this.dbParameterGroupFamily = dbParameterGroupFamily;
        }

        public final Collection<Filter> getFilters() {
            return this.filters;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
        }

        public final Integer getMaxRecords() {
            return this.maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Boolean getDefaultOnly() {
            return this.defaultOnly;
        }

        @Override
        public final Builder defaultOnly(Boolean defaultOnly) {
            this.defaultOnly = defaultOnly;
            return this;
        }

        public final void setDefaultOnly(Boolean defaultOnly) {
            this.defaultOnly = defaultOnly;
        }

        public final Boolean getListSupportedCharacterSets() {
            return this.listSupportedCharacterSets;
        }

        @Override
        public final Builder listSupportedCharacterSets(Boolean listSupportedCharacterSets) {
            this.listSupportedCharacterSets = listSupportedCharacterSets;
            return this;
        }

        public final void setListSupportedCharacterSets(Boolean listSupportedCharacterSets) {
            this.listSupportedCharacterSets = listSupportedCharacterSets;
        }

        public final Boolean getListSupportedTimezones() {
            return this.listSupportedTimezones;
        }

        @Override
        public final Builder listSupportedTimezones(Boolean listSupportedTimezones) {
            this.listSupportedTimezones = listSupportedTimezones;
            return this;
        }

        public final void setListSupportedTimezones(Boolean listSupportedTimezones) {
            this.listSupportedTimezones = listSupportedTimezones;
        }

        public DescribeDBEngineVersionsRequest build() {
            return new DescribeDBEngineVersionsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeDBEngineVersionsRequest> {
        public Builder engine(String var1);

        public Builder engineVersion(String var1);

        public Builder dbParameterGroupFamily(String var1);

        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder maxRecords(Integer var1);

        public Builder marker(String var1);

        public Builder defaultOnly(Boolean var1);

        public Builder listSupportedCharacterSets(Boolean var1);

        public Builder listSupportedTimezones(Boolean var1);
    }
}

