/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds;

import java.util.Date;
import software.amazon.awssdk.annotation.SdkTestInternalApi;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpFullRequestAdapter;
import software.amazon.awssdk.services.rds.RdsPresignInterceptor;
import software.amazon.awssdk.services.rds.model.CopyDBSnapshotRequest;
import software.amazon.awssdk.services.rds.transform.CopyDBSnapshotRequestMarshaller;
import software.amazon.awssdk.util.ImmutableObjectUtils;

public class CopyDbSnapshotPresignInterceptor
extends RdsPresignInterceptor<CopyDBSnapshotRequest> {
    public CopyDbSnapshotPresignInterceptor() {
        super(CopyDBSnapshotRequest.class);
    }

    @SdkTestInternalApi
    CopyDbSnapshotPresignInterceptor(Date signingOverrideDate) {
        super(CopyDBSnapshotRequest.class, signingOverrideDate);
    }

    @Override
    protected RdsPresignInterceptor.PresignableRequest adaptRequest(final CopyDBSnapshotRequest originalRequest) {
        return new RdsPresignInterceptor.PresignableRequest(){

            @Override
            public void setPreSignedUrl(String preSignedUrl) {
                ImmutableObjectUtils.setObjectMember((Object)((Object)originalRequest), (String)"preSignedUrl", (Object)preSignedUrl);
            }

            @Override
            public String getSourceRegion() {
                return originalRequest.sourceRegion();
            }

            @Override
            public SdkHttpFullRequest.Builder marshall() {
                return SdkHttpFullRequestAdapter.toMutableHttpFullRequest(new CopyDBSnapshotRequestMarshaller().marshall(originalRequest));
            }
        };
    }
}

