/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.rds.model.EventCategoriesMap;

public class EventCategoriesMapUnmarshaller
implements Unmarshaller<EventCategoriesMap, StaxUnmarshallerContext> {
    private static EventCategoriesMapUnmarshaller INSTANCE;

    public EventCategoriesMap unmarshall(StaxUnmarshallerContext context) throws Exception {
        EventCategoriesMap.Builder eventCategoriesMap;
        block6: {
            eventCategoriesMap = EventCategoriesMap.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                targetDepth += 3;
            }
            ArrayList<String> eventCategories = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    eventCategoriesMap.eventCategories(eventCategories);
                    break block6;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("SourceType", targetDepth)) {
                        eventCategoriesMap.sourceType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("EventCategories", targetDepth)) {
                        eventCategories = new ArrayList<String>();
                        continue;
                    }
                    if (!context.testExpression("EventCategories/EventCategory", targetDepth)) continue;
                    eventCategories.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            eventCategoriesMap.eventCategories(eventCategories);
        }
        return (EventCategoriesMap)eventCategoriesMap.build();
    }

    public static EventCategoriesMapUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new EventCategoriesMapUnmarshaller();
        }
        return INSTANCE;
    }
}

