/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.rds.model.DescribeDBLogFilesRequest;
import software.amazon.awssdk.services.rds.model.Filter;
import software.amazon.awssdk.util.StringUtils;

public class DescribeDBLogFilesRequestMarshaller
implements Marshaller<Request<DescribeDBLogFilesRequest>, DescribeDBLogFilesRequest> {
    public Request<DescribeDBLogFilesRequest> marshall(DescribeDBLogFilesRequest describeDBLogFilesRequest) {
        List<Filter> filtersList;
        if (describeDBLogFilesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeDBLogFilesRequest, "RDSClient");
        request.addParameter("Action", "DescribeDBLogFiles");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeDBLogFilesRequest.dbInstanceIdentifier() != null) {
            request.addParameter("DBInstanceIdentifier", StringUtils.fromString((String)describeDBLogFilesRequest.dbInstanceIdentifier()));
        }
        if (describeDBLogFilesRequest.filenameContains() != null) {
            request.addParameter("FilenameContains", StringUtils.fromString((String)describeDBLogFilesRequest.filenameContains()));
        }
        if (describeDBLogFilesRequest.fileLastWritten() != null) {
            request.addParameter("FileLastWritten", StringUtils.fromLong((Long)describeDBLogFilesRequest.fileLastWritten()));
        }
        if (describeDBLogFilesRequest.fileSize() != null) {
            request.addParameter("FileSize", StringUtils.fromLong((Long)describeDBLogFilesRequest.fileSize()));
        }
        if ((filtersList = describeDBLogFilesRequest.filters()) != null) {
            if (!filtersList.isEmpty()) {
                int filtersListIndex = 1;
                for (Filter filtersListValue : filtersList) {
                    List<String> valuesList;
                    if (filtersListValue.name() != null) {
                        request.addParameter("Filters.Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)filtersListValue.name()));
                    }
                    if ((valuesList = filtersListValue.values()) != null) {
                        if (!valuesList.isEmpty()) {
                            int valuesListIndex = 1;
                            for (String valuesListValue : valuesList) {
                                if (valuesListValue != null) {
                                    request.addParameter("Filters.Filter." + filtersListIndex + ".Values.Value." + valuesListIndex, StringUtils.fromString((String)valuesListValue));
                                }
                                ++valuesListIndex;
                            }
                        } else {
                            request.addParameter("Filters.Filter." + filtersListIndex + ".Values", "");
                        }
                    }
                    ++filtersListIndex;
                }
            } else {
                request.addParameter("Filters", "");
            }
        }
        if (describeDBLogFilesRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeDBLogFilesRequest.maxRecords()));
        }
        if (describeDBLogFilesRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeDBLogFilesRequest.marker()));
        }
        return request;
    }
}

