/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.rds.model.EventSubscription;
import software.amazon.awssdk.services.rds.model.EventSubscriptionsListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeEventSubscriptionsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeEventSubscriptionsResponse> {
    private final String marker;
    private final List<EventSubscription> eventSubscriptionsList;

    private DescribeEventSubscriptionsResponse(BuilderImpl builder) {
        this.marker = builder.marker;
        this.eventSubscriptionsList = builder.eventSubscriptionsList;
    }

    public String marker() {
        return this.marker;
    }

    public List<EventSubscription> eventSubscriptionsList() {
        return this.eventSubscriptionsList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        hashCode = 31 * hashCode + (this.eventSubscriptionsList() == null ? 0 : this.eventSubscriptionsList().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEventSubscriptionsResponse)) {
            return false;
        }
        DescribeEventSubscriptionsResponse other = (DescribeEventSubscriptionsResponse)((Object)obj);
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        if (other.marker() != null && !other.marker().equals(this.marker())) {
            return false;
        }
        if (other.eventSubscriptionsList() == null ^ this.eventSubscriptionsList() == null) {
            return false;
        }
        return other.eventSubscriptionsList() == null || other.eventSubscriptionsList().equals(this.eventSubscriptionsList());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.eventSubscriptionsList() != null) {
            sb.append("EventSubscriptionsList: ").append(this.eventSubscriptionsList()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String marker;
        private List<EventSubscription> eventSubscriptionsList;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEventSubscriptionsResponse model) {
            this.setMarker(model.marker);
            this.setEventSubscriptionsList(model.eventSubscriptionsList);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<EventSubscription> getEventSubscriptionsList() {
            return this.eventSubscriptionsList;
        }

        @Override
        public final Builder eventSubscriptionsList(Collection<EventSubscription> eventSubscriptionsList) {
            this.eventSubscriptionsList = EventSubscriptionsListCopier.copy(eventSubscriptionsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventSubscriptionsList(EventSubscription ... eventSubscriptionsList) {
            this.eventSubscriptionsList(Arrays.asList(eventSubscriptionsList));
            return this;
        }

        public final void setEventSubscriptionsList(Collection<EventSubscription> eventSubscriptionsList) {
            this.eventSubscriptionsList = EventSubscriptionsListCopier.copy(eventSubscriptionsList);
        }

        @SafeVarargs
        public final void setEventSubscriptionsList(EventSubscription ... eventSubscriptionsList) {
            this.eventSubscriptionsList(Arrays.asList(eventSubscriptionsList));
        }

        public DescribeEventSubscriptionsResponse build() {
            return new DescribeEventSubscriptionsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeEventSubscriptionsResponse> {
        public Builder marker(String var1);

        public Builder eventSubscriptionsList(Collection<EventSubscription> var1);

        public Builder eventSubscriptionsList(EventSubscription ... var1);
    }
}

