/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.rds.model.Filter;
import software.amazon.awssdk.services.rds.model.FilterListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeDBLogFilesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeDBLogFilesRequest> {
    private final String dbInstanceIdentifier;
    private final String filenameContains;
    private final Long fileLastWritten;
    private final Long fileSize;
    private final List<Filter> filters;
    private final Integer maxRecords;
    private final String marker;

    private DescribeDBLogFilesRequest(BuilderImpl builder) {
        this.dbInstanceIdentifier = builder.dbInstanceIdentifier;
        this.filenameContains = builder.filenameContains;
        this.fileLastWritten = builder.fileLastWritten;
        this.fileSize = builder.fileSize;
        this.filters = builder.filters;
        this.maxRecords = builder.maxRecords;
        this.marker = builder.marker;
    }

    public String dbInstanceIdentifier() {
        return this.dbInstanceIdentifier;
    }

    public String filenameContains() {
        return this.filenameContains;
    }

    public Long fileLastWritten() {
        return this.fileLastWritten;
    }

    public Long fileSize() {
        return this.fileSize;
    }

    public List<Filter> filters() {
        return this.filters;
    }

    public Integer maxRecords() {
        return this.maxRecords;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.dbInstanceIdentifier() == null ? 0 : this.dbInstanceIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.filenameContains() == null ? 0 : this.filenameContains().hashCode());
        hashCode = 31 * hashCode + (this.fileLastWritten() == null ? 0 : this.fileLastWritten().hashCode());
        hashCode = 31 * hashCode + (this.fileSize() == null ? 0 : this.fileSize().hashCode());
        hashCode = 31 * hashCode + (this.filters() == null ? 0 : this.filters().hashCode());
        hashCode = 31 * hashCode + (this.maxRecords() == null ? 0 : this.maxRecords().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDBLogFilesRequest)) {
            return false;
        }
        DescribeDBLogFilesRequest other = (DescribeDBLogFilesRequest)((Object)obj);
        if (other.dbInstanceIdentifier() == null ^ this.dbInstanceIdentifier() == null) {
            return false;
        }
        if (other.dbInstanceIdentifier() != null && !other.dbInstanceIdentifier().equals(this.dbInstanceIdentifier())) {
            return false;
        }
        if (other.filenameContains() == null ^ this.filenameContains() == null) {
            return false;
        }
        if (other.filenameContains() != null && !other.filenameContains().equals(this.filenameContains())) {
            return false;
        }
        if (other.fileLastWritten() == null ^ this.fileLastWritten() == null) {
            return false;
        }
        if (other.fileLastWritten() != null && !other.fileLastWritten().equals(this.fileLastWritten())) {
            return false;
        }
        if (other.fileSize() == null ^ this.fileSize() == null) {
            return false;
        }
        if (other.fileSize() != null && !other.fileSize().equals(this.fileSize())) {
            return false;
        }
        if (other.filters() == null ^ this.filters() == null) {
            return false;
        }
        if (other.filters() != null && !other.filters().equals(this.filters())) {
            return false;
        }
        if (other.maxRecords() == null ^ this.maxRecords() == null) {
            return false;
        }
        if (other.maxRecords() != null && !other.maxRecords().equals(this.maxRecords())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        return other.marker() == null || other.marker().equals(this.marker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.dbInstanceIdentifier() != null) {
            sb.append("DBInstanceIdentifier: ").append(this.dbInstanceIdentifier()).append(",");
        }
        if (this.filenameContains() != null) {
            sb.append("FilenameContains: ").append(this.filenameContains()).append(",");
        }
        if (this.fileLastWritten() != null) {
            sb.append("FileLastWritten: ").append(this.fileLastWritten()).append(",");
        }
        if (this.fileSize() != null) {
            sb.append("FileSize: ").append(this.fileSize()).append(",");
        }
        if (this.filters() != null) {
            sb.append("Filters: ").append(this.filters()).append(",");
        }
        if (this.maxRecords() != null) {
            sb.append("MaxRecords: ").append(this.maxRecords()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String dbInstanceIdentifier;
        private String filenameContains;
        private Long fileLastWritten;
        private Long fileSize;
        private List<Filter> filters;
        private Integer maxRecords;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDBLogFilesRequest model) {
            this.setDBInstanceIdentifier(model.dbInstanceIdentifier);
            this.setFilenameContains(model.filenameContains);
            this.setFileLastWritten(model.fileLastWritten);
            this.setFileSize(model.fileSize);
            this.setFilters(model.filters);
            this.setMaxRecords(model.maxRecords);
            this.setMarker(model.marker);
        }

        public final String getDBInstanceIdentifier() {
            return this.dbInstanceIdentifier;
        }

        @Override
        public final Builder dbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
            return this;
        }

        public final void setDBInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
        }

        public final String getFilenameContains() {
            return this.filenameContains;
        }

        @Override
        public final Builder filenameContains(String filenameContains) {
            this.filenameContains = filenameContains;
            return this;
        }

        public final void setFilenameContains(String filenameContains) {
            this.filenameContains = filenameContains;
        }

        public final Long getFileLastWritten() {
            return this.fileLastWritten;
        }

        @Override
        public final Builder fileLastWritten(Long fileLastWritten) {
            this.fileLastWritten = fileLastWritten;
            return this;
        }

        public final void setFileLastWritten(Long fileLastWritten) {
            this.fileLastWritten = fileLastWritten;
        }

        public final Long getFileSize() {
            return this.fileSize;
        }

        @Override
        public final Builder fileSize(Long fileSize) {
            this.fileSize = fileSize;
            return this;
        }

        public final void setFileSize(Long fileSize) {
            this.fileSize = fileSize;
        }

        public final Collection<Filter> getFilters() {
            return this.filters;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
        }

        @SafeVarargs
        public final void setFilters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
        }

        public final Integer getMaxRecords() {
            return this.maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public DescribeDBLogFilesRequest build() {
            return new DescribeDBLogFilesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeDBLogFilesRequest> {
        public Builder dbInstanceIdentifier(String var1);

        public Builder filenameContains(String var1);

        public Builder fileLastWritten(Long var1);

        public Builder fileSize(Long var1);

        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder maxRecords(Integer var1);

        public Builder marker(String var1);
    }
}

