/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.rds.model.AvailabilityZonesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DBClusterSnapshot
implements ToCopyableBuilder<Builder, DBClusterSnapshot> {
    private final List<String> availabilityZones;
    private final String dbClusterSnapshotIdentifier;
    private final String dbClusterIdentifier;
    private final Instant snapshotCreateTime;
    private final String engine;
    private final Integer allocatedStorage;
    private final String status;
    private final Integer port;
    private final String vpcId;
    private final Instant clusterCreateTime;
    private final String masterUsername;
    private final String engineVersion;
    private final String licenseModel;
    private final String snapshotType;
    private final Integer percentProgress;
    private final Boolean storageEncrypted;
    private final String kmsKeyId;
    private final String dbClusterSnapshotArn;
    private final String sourceDBClusterSnapshotArn;
    private final Boolean iamDatabaseAuthenticationEnabled;

    private DBClusterSnapshot(BuilderImpl builder) {
        this.availabilityZones = builder.availabilityZones;
        this.dbClusterSnapshotIdentifier = builder.dbClusterSnapshotIdentifier;
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.snapshotCreateTime = builder.snapshotCreateTime;
        this.engine = builder.engine;
        this.allocatedStorage = builder.allocatedStorage;
        this.status = builder.status;
        this.port = builder.port;
        this.vpcId = builder.vpcId;
        this.clusterCreateTime = builder.clusterCreateTime;
        this.masterUsername = builder.masterUsername;
        this.engineVersion = builder.engineVersion;
        this.licenseModel = builder.licenseModel;
        this.snapshotType = builder.snapshotType;
        this.percentProgress = builder.percentProgress;
        this.storageEncrypted = builder.storageEncrypted;
        this.kmsKeyId = builder.kmsKeyId;
        this.dbClusterSnapshotArn = builder.dbClusterSnapshotArn;
        this.sourceDBClusterSnapshotArn = builder.sourceDBClusterSnapshotArn;
        this.iamDatabaseAuthenticationEnabled = builder.iamDatabaseAuthenticationEnabled;
    }

    public List<String> availabilityZones() {
        return this.availabilityZones;
    }

    public String dbClusterSnapshotIdentifier() {
        return this.dbClusterSnapshotIdentifier;
    }

    public String dbClusterIdentifier() {
        return this.dbClusterIdentifier;
    }

    public Instant snapshotCreateTime() {
        return this.snapshotCreateTime;
    }

    public String engine() {
        return this.engine;
    }

    public Integer allocatedStorage() {
        return this.allocatedStorage;
    }

    public String status() {
        return this.status;
    }

    public Integer port() {
        return this.port;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public Instant clusterCreateTime() {
        return this.clusterCreateTime;
    }

    public String masterUsername() {
        return this.masterUsername;
    }

    public String engineVersion() {
        return this.engineVersion;
    }

    public String licenseModel() {
        return this.licenseModel;
    }

    public String snapshotType() {
        return this.snapshotType;
    }

    public Integer percentProgress() {
        return this.percentProgress;
    }

    public Boolean storageEncrypted() {
        return this.storageEncrypted;
    }

    public String kmsKeyId() {
        return this.kmsKeyId;
    }

    public String dbClusterSnapshotArn() {
        return this.dbClusterSnapshotArn;
    }

    public String sourceDBClusterSnapshotArn() {
        return this.sourceDBClusterSnapshotArn;
    }

    public Boolean iamDatabaseAuthenticationEnabled() {
        return this.iamDatabaseAuthenticationEnabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.availabilityZones() == null ? 0 : this.availabilityZones().hashCode());
        hashCode = 31 * hashCode + (this.dbClusterSnapshotIdentifier() == null ? 0 : this.dbClusterSnapshotIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.dbClusterIdentifier() == null ? 0 : this.dbClusterIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.snapshotCreateTime() == null ? 0 : this.snapshotCreateTime().hashCode());
        hashCode = 31 * hashCode + (this.engine() == null ? 0 : this.engine().hashCode());
        hashCode = 31 * hashCode + (this.allocatedStorage() == null ? 0 : this.allocatedStorage().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.port() == null ? 0 : this.port().hashCode());
        hashCode = 31 * hashCode + (this.vpcId() == null ? 0 : this.vpcId().hashCode());
        hashCode = 31 * hashCode + (this.clusterCreateTime() == null ? 0 : this.clusterCreateTime().hashCode());
        hashCode = 31 * hashCode + (this.masterUsername() == null ? 0 : this.masterUsername().hashCode());
        hashCode = 31 * hashCode + (this.engineVersion() == null ? 0 : this.engineVersion().hashCode());
        hashCode = 31 * hashCode + (this.licenseModel() == null ? 0 : this.licenseModel().hashCode());
        hashCode = 31 * hashCode + (this.snapshotType() == null ? 0 : this.snapshotType().hashCode());
        hashCode = 31 * hashCode + (this.percentProgress() == null ? 0 : this.percentProgress().hashCode());
        hashCode = 31 * hashCode + (this.storageEncrypted() == null ? 0 : this.storageEncrypted().hashCode());
        hashCode = 31 * hashCode + (this.kmsKeyId() == null ? 0 : this.kmsKeyId().hashCode());
        hashCode = 31 * hashCode + (this.dbClusterSnapshotArn() == null ? 0 : this.dbClusterSnapshotArn().hashCode());
        hashCode = 31 * hashCode + (this.sourceDBClusterSnapshotArn() == null ? 0 : this.sourceDBClusterSnapshotArn().hashCode());
        hashCode = 31 * hashCode + (this.iamDatabaseAuthenticationEnabled() == null ? 0 : this.iamDatabaseAuthenticationEnabled().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBClusterSnapshot)) {
            return false;
        }
        DBClusterSnapshot other = (DBClusterSnapshot)obj;
        if (other.availabilityZones() == null ^ this.availabilityZones() == null) {
            return false;
        }
        if (other.availabilityZones() != null && !other.availabilityZones().equals(this.availabilityZones())) {
            return false;
        }
        if (other.dbClusterSnapshotIdentifier() == null ^ this.dbClusterSnapshotIdentifier() == null) {
            return false;
        }
        if (other.dbClusterSnapshotIdentifier() != null && !other.dbClusterSnapshotIdentifier().equals(this.dbClusterSnapshotIdentifier())) {
            return false;
        }
        if (other.dbClusterIdentifier() == null ^ this.dbClusterIdentifier() == null) {
            return false;
        }
        if (other.dbClusterIdentifier() != null && !other.dbClusterIdentifier().equals(this.dbClusterIdentifier())) {
            return false;
        }
        if (other.snapshotCreateTime() == null ^ this.snapshotCreateTime() == null) {
            return false;
        }
        if (other.snapshotCreateTime() != null && !other.snapshotCreateTime().equals(this.snapshotCreateTime())) {
            return false;
        }
        if (other.engine() == null ^ this.engine() == null) {
            return false;
        }
        if (other.engine() != null && !other.engine().equals(this.engine())) {
            return false;
        }
        if (other.allocatedStorage() == null ^ this.allocatedStorage() == null) {
            return false;
        }
        if (other.allocatedStorage() != null && !other.allocatedStorage().equals(this.allocatedStorage())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.port() == null ^ this.port() == null) {
            return false;
        }
        if (other.port() != null && !other.port().equals(this.port())) {
            return false;
        }
        if (other.vpcId() == null ^ this.vpcId() == null) {
            return false;
        }
        if (other.vpcId() != null && !other.vpcId().equals(this.vpcId())) {
            return false;
        }
        if (other.clusterCreateTime() == null ^ this.clusterCreateTime() == null) {
            return false;
        }
        if (other.clusterCreateTime() != null && !other.clusterCreateTime().equals(this.clusterCreateTime())) {
            return false;
        }
        if (other.masterUsername() == null ^ this.masterUsername() == null) {
            return false;
        }
        if (other.masterUsername() != null && !other.masterUsername().equals(this.masterUsername())) {
            return false;
        }
        if (other.engineVersion() == null ^ this.engineVersion() == null) {
            return false;
        }
        if (other.engineVersion() != null && !other.engineVersion().equals(this.engineVersion())) {
            return false;
        }
        if (other.licenseModel() == null ^ this.licenseModel() == null) {
            return false;
        }
        if (other.licenseModel() != null && !other.licenseModel().equals(this.licenseModel())) {
            return false;
        }
        if (other.snapshotType() == null ^ this.snapshotType() == null) {
            return false;
        }
        if (other.snapshotType() != null && !other.snapshotType().equals(this.snapshotType())) {
            return false;
        }
        if (other.percentProgress() == null ^ this.percentProgress() == null) {
            return false;
        }
        if (other.percentProgress() != null && !other.percentProgress().equals(this.percentProgress())) {
            return false;
        }
        if (other.storageEncrypted() == null ^ this.storageEncrypted() == null) {
            return false;
        }
        if (other.storageEncrypted() != null && !other.storageEncrypted().equals(this.storageEncrypted())) {
            return false;
        }
        if (other.kmsKeyId() == null ^ this.kmsKeyId() == null) {
            return false;
        }
        if (other.kmsKeyId() != null && !other.kmsKeyId().equals(this.kmsKeyId())) {
            return false;
        }
        if (other.dbClusterSnapshotArn() == null ^ this.dbClusterSnapshotArn() == null) {
            return false;
        }
        if (other.dbClusterSnapshotArn() != null && !other.dbClusterSnapshotArn().equals(this.dbClusterSnapshotArn())) {
            return false;
        }
        if (other.sourceDBClusterSnapshotArn() == null ^ this.sourceDBClusterSnapshotArn() == null) {
            return false;
        }
        if (other.sourceDBClusterSnapshotArn() != null && !other.sourceDBClusterSnapshotArn().equals(this.sourceDBClusterSnapshotArn())) {
            return false;
        }
        if (other.iamDatabaseAuthenticationEnabled() == null ^ this.iamDatabaseAuthenticationEnabled() == null) {
            return false;
        }
        return other.iamDatabaseAuthenticationEnabled() == null || other.iamDatabaseAuthenticationEnabled().equals(this.iamDatabaseAuthenticationEnabled());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.availabilityZones() != null) {
            sb.append("AvailabilityZones: ").append(this.availabilityZones()).append(",");
        }
        if (this.dbClusterSnapshotIdentifier() != null) {
            sb.append("DBClusterSnapshotIdentifier: ").append(this.dbClusterSnapshotIdentifier()).append(",");
        }
        if (this.dbClusterIdentifier() != null) {
            sb.append("DBClusterIdentifier: ").append(this.dbClusterIdentifier()).append(",");
        }
        if (this.snapshotCreateTime() != null) {
            sb.append("SnapshotCreateTime: ").append(this.snapshotCreateTime()).append(",");
        }
        if (this.engine() != null) {
            sb.append("Engine: ").append(this.engine()).append(",");
        }
        if (this.allocatedStorage() != null) {
            sb.append("AllocatedStorage: ").append(this.allocatedStorage()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.port() != null) {
            sb.append("Port: ").append(this.port()).append(",");
        }
        if (this.vpcId() != null) {
            sb.append("VpcId: ").append(this.vpcId()).append(",");
        }
        if (this.clusterCreateTime() != null) {
            sb.append("ClusterCreateTime: ").append(this.clusterCreateTime()).append(",");
        }
        if (this.masterUsername() != null) {
            sb.append("MasterUsername: ").append(this.masterUsername()).append(",");
        }
        if (this.engineVersion() != null) {
            sb.append("EngineVersion: ").append(this.engineVersion()).append(",");
        }
        if (this.licenseModel() != null) {
            sb.append("LicenseModel: ").append(this.licenseModel()).append(",");
        }
        if (this.snapshotType() != null) {
            sb.append("SnapshotType: ").append(this.snapshotType()).append(",");
        }
        if (this.percentProgress() != null) {
            sb.append("PercentProgress: ").append(this.percentProgress()).append(",");
        }
        if (this.storageEncrypted() != null) {
            sb.append("StorageEncrypted: ").append(this.storageEncrypted()).append(",");
        }
        if (this.kmsKeyId() != null) {
            sb.append("KmsKeyId: ").append(this.kmsKeyId()).append(",");
        }
        if (this.dbClusterSnapshotArn() != null) {
            sb.append("DBClusterSnapshotArn: ").append(this.dbClusterSnapshotArn()).append(",");
        }
        if (this.sourceDBClusterSnapshotArn() != null) {
            sb.append("SourceDBClusterSnapshotArn: ").append(this.sourceDBClusterSnapshotArn()).append(",");
        }
        if (this.iamDatabaseAuthenticationEnabled() != null) {
            sb.append("IAMDatabaseAuthenticationEnabled: ").append(this.iamDatabaseAuthenticationEnabled()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> availabilityZones;
        private String dbClusterSnapshotIdentifier;
        private String dbClusterIdentifier;
        private Instant snapshotCreateTime;
        private String engine;
        private Integer allocatedStorage;
        private String status;
        private Integer port;
        private String vpcId;
        private Instant clusterCreateTime;
        private String masterUsername;
        private String engineVersion;
        private String licenseModel;
        private String snapshotType;
        private Integer percentProgress;
        private Boolean storageEncrypted;
        private String kmsKeyId;
        private String dbClusterSnapshotArn;
        private String sourceDBClusterSnapshotArn;
        private Boolean iamDatabaseAuthenticationEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(DBClusterSnapshot model) {
            this.setAvailabilityZones(model.availabilityZones);
            this.setDBClusterSnapshotIdentifier(model.dbClusterSnapshotIdentifier);
            this.setDBClusterIdentifier(model.dbClusterIdentifier);
            this.setSnapshotCreateTime(model.snapshotCreateTime);
            this.setEngine(model.engine);
            this.setAllocatedStorage(model.allocatedStorage);
            this.setStatus(model.status);
            this.setPort(model.port);
            this.setVpcId(model.vpcId);
            this.setClusterCreateTime(model.clusterCreateTime);
            this.setMasterUsername(model.masterUsername);
            this.setEngineVersion(model.engineVersion);
            this.setLicenseModel(model.licenseModel);
            this.setSnapshotType(model.snapshotType);
            this.setPercentProgress(model.percentProgress);
            this.setStorageEncrypted(model.storageEncrypted);
            this.setKmsKeyId(model.kmsKeyId);
            this.setDBClusterSnapshotArn(model.dbClusterSnapshotArn);
            this.setSourceDBClusterSnapshotArn(model.sourceDBClusterSnapshotArn);
            this.setIAMDatabaseAuthenticationEnabled(model.iamDatabaseAuthenticationEnabled);
        }

        public final Collection<String> getAvailabilityZones() {
            return this.availabilityZones;
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String ... availabilityZones) {
            this.availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
        }

        @SafeVarargs
        public final void setAvailabilityZones(String ... availabilityZones) {
            this.availabilityZones(Arrays.asList(availabilityZones));
        }

        public final String getDBClusterSnapshotIdentifier() {
            return this.dbClusterSnapshotIdentifier;
        }

        @Override
        public final Builder dbClusterSnapshotIdentifier(String dbClusterSnapshotIdentifier) {
            this.dbClusterSnapshotIdentifier = dbClusterSnapshotIdentifier;
            return this;
        }

        public final void setDBClusterSnapshotIdentifier(String dbClusterSnapshotIdentifier) {
            this.dbClusterSnapshotIdentifier = dbClusterSnapshotIdentifier;
        }

        public final String getDBClusterIdentifier() {
            return this.dbClusterIdentifier;
        }

        @Override
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final void setDBClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        public final Instant getSnapshotCreateTime() {
            return this.snapshotCreateTime;
        }

        @Override
        public final Builder snapshotCreateTime(Instant snapshotCreateTime) {
            this.snapshotCreateTime = snapshotCreateTime;
            return this;
        }

        public final void setSnapshotCreateTime(Instant snapshotCreateTime) {
            this.snapshotCreateTime = snapshotCreateTime;
        }

        public final String getEngine() {
            return this.engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final Integer getAllocatedStorage() {
            return this.allocatedStorage;
        }

        @Override
        public final Builder allocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
            return this;
        }

        public final void setAllocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Integer getPort() {
            return this.port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final Instant getClusterCreateTime() {
            return this.clusterCreateTime;
        }

        @Override
        public final Builder clusterCreateTime(Instant clusterCreateTime) {
            this.clusterCreateTime = clusterCreateTime;
            return this;
        }

        public final void setClusterCreateTime(Instant clusterCreateTime) {
            this.clusterCreateTime = clusterCreateTime;
        }

        public final String getMasterUsername() {
            return this.masterUsername;
        }

        @Override
        public final Builder masterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
            return this;
        }

        public final void setMasterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final String getLicenseModel() {
            return this.licenseModel;
        }

        @Override
        public final Builder licenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
            return this;
        }

        public final void setLicenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
        }

        public final String getSnapshotType() {
            return this.snapshotType;
        }

        @Override
        public final Builder snapshotType(String snapshotType) {
            this.snapshotType = snapshotType;
            return this;
        }

        public final void setSnapshotType(String snapshotType) {
            this.snapshotType = snapshotType;
        }

        public final Integer getPercentProgress() {
            return this.percentProgress;
        }

        @Override
        public final Builder percentProgress(Integer percentProgress) {
            this.percentProgress = percentProgress;
            return this;
        }

        public final void setPercentProgress(Integer percentProgress) {
            this.percentProgress = percentProgress;
        }

        public final Boolean getStorageEncrypted() {
            return this.storageEncrypted;
        }

        @Override
        public final Builder storageEncrypted(Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
            return this;
        }

        public final void setStorageEncrypted(Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final String getDBClusterSnapshotArn() {
            return this.dbClusterSnapshotArn;
        }

        @Override
        public final Builder dbClusterSnapshotArn(String dbClusterSnapshotArn) {
            this.dbClusterSnapshotArn = dbClusterSnapshotArn;
            return this;
        }

        public final void setDBClusterSnapshotArn(String dbClusterSnapshotArn) {
            this.dbClusterSnapshotArn = dbClusterSnapshotArn;
        }

        public final String getSourceDBClusterSnapshotArn() {
            return this.sourceDBClusterSnapshotArn;
        }

        @Override
        public final Builder sourceDBClusterSnapshotArn(String sourceDBClusterSnapshotArn) {
            this.sourceDBClusterSnapshotArn = sourceDBClusterSnapshotArn;
            return this;
        }

        public final void setSourceDBClusterSnapshotArn(String sourceDBClusterSnapshotArn) {
            this.sourceDBClusterSnapshotArn = sourceDBClusterSnapshotArn;
        }

        public final Boolean getIAMDatabaseAuthenticationEnabled() {
            return this.iamDatabaseAuthenticationEnabled;
        }

        @Override
        public final Builder iamDatabaseAuthenticationEnabled(Boolean iamDatabaseAuthenticationEnabled) {
            this.iamDatabaseAuthenticationEnabled = iamDatabaseAuthenticationEnabled;
            return this;
        }

        public final void setIAMDatabaseAuthenticationEnabled(Boolean iamDatabaseAuthenticationEnabled) {
            this.iamDatabaseAuthenticationEnabled = iamDatabaseAuthenticationEnabled;
        }

        public DBClusterSnapshot build() {
            return new DBClusterSnapshot(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DBClusterSnapshot> {
        public Builder availabilityZones(Collection<String> var1);

        public Builder availabilityZones(String ... var1);

        public Builder dbClusterSnapshotIdentifier(String var1);

        public Builder dbClusterIdentifier(String var1);

        public Builder snapshotCreateTime(Instant var1);

        public Builder engine(String var1);

        public Builder allocatedStorage(Integer var1);

        public Builder status(String var1);

        public Builder port(Integer var1);

        public Builder vpcId(String var1);

        public Builder clusterCreateTime(Instant var1);

        public Builder masterUsername(String var1);

        public Builder engineVersion(String var1);

        public Builder licenseModel(String var1);

        public Builder snapshotType(String var1);

        public Builder percentProgress(Integer var1);

        public Builder storageEncrypted(Boolean var1);

        public Builder kmsKeyId(String var1);

        public Builder dbClusterSnapshotArn(String var1);

        public Builder sourceDBClusterSnapshotArn(String var1);

        public Builder iamDatabaseAuthenticationEnabled(Boolean var1);
    }
}

