/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rds.RdsClient;
import software.amazon.awssdk.services.rds.model.DBParameterGroup;
import software.amazon.awssdk.services.rds.model.DescribeDbParameterGroupsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbParameterGroupsResponse;

public class DescribeDBParameterGroupsIterable
implements SdkIterable<DescribeDbParameterGroupsResponse> {
    private final RdsClient client;
    private final DescribeDbParameterGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeDBParameterGroupsIterable(RdsClient client, DescribeDbParameterGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeDbParameterGroupsResponseFetcher();
    }

    public Iterator<DescribeDbParameterGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DBParameterGroup> dbParameterGroups() {
        Function<DescribeDbParameterGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.dbParameterGroups() != null) {
                return response.dbParameterGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final DescribeDBParameterGroupsIterable resume(DescribeDbParameterGroupsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeDBParameterGroupsIterable(this.client, (DescribeDbParameterGroupsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeDBParameterGroupsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeDbParameterGroupsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeDbParameterGroupsResponseFetcher
    implements SyncPageFetcher<DescribeDbParameterGroupsResponse> {
        private DescribeDbParameterGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDbParameterGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeDbParameterGroupsResponse nextPage(DescribeDbParameterGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeDBParameterGroupsIterable.this.client.describeDBParameterGroups(DescribeDBParameterGroupsIterable.this.firstRequest);
            }
            return DescribeDBParameterGroupsIterable.this.client.describeDBParameterGroups((DescribeDbParameterGroupsRequest)((Object)DescribeDBParameterGroupsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

