/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSessionDataResponse extends QConnectResponse implements
        ToCopyableBuilder<UpdateSessionDataResponse.Builder, UpdateSessionDataResponse> {
    private static final SdkField<List<RuntimeSessionData>> DATA_FIELD = SdkField
            .<List<RuntimeSessionData>> builder(MarshallingType.LIST)
            .memberName("data")
            .getter(getter(UpdateSessionDataResponse::data))
            .setter(setter(Builder::data))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("data").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RuntimeSessionData> builder(MarshallingType.SDK_POJO)
                                            .constructor(RuntimeSessionData::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("namespace").getter(getter(UpdateSessionDataResponse::namespaceAsString))
            .setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespace").build()).build();

    private static final SdkField<String> SESSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionArn").getter(getter(UpdateSessionDataResponse::sessionArn)).setter(setter(Builder::sessionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionArn").build()).build();

    private static final SdkField<String> SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionId").getter(getter(UpdateSessionDataResponse::sessionId)).setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_FIELD, NAMESPACE_FIELD,
            SESSION_ARN_FIELD, SESSION_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<RuntimeSessionData> data;

    private final String namespace;

    private final String sessionArn;

    private final String sessionId;

    private UpdateSessionDataResponse(BuilderImpl builder) {
        super(builder);
        this.data = builder.data;
        this.namespace = builder.namespace;
        this.sessionArn = builder.sessionArn;
        this.sessionId = builder.sessionId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Data property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasData() {
        return data != null && !(data instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Data stored in the session.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasData} method.
     * </p>
     * 
     * @return Data stored in the session.
     */
    public final List<RuntimeSessionData> data() {
        return data;
    }

    /**
     * <p>
     * The namespace into which the session data is stored. Supported namespaces are: Custom
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #namespace} will
     * return {@link SessionDataNamespace#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #namespaceAsString}.
     * </p>
     * 
     * @return The namespace into which the session data is stored. Supported namespaces are: Custom
     * @see SessionDataNamespace
     */
    public final SessionDataNamespace namespace() {
        return SessionDataNamespace.fromValue(namespace);
    }

    /**
     * <p>
     * The namespace into which the session data is stored. Supported namespaces are: Custom
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #namespace} will
     * return {@link SessionDataNamespace#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #namespaceAsString}.
     * </p>
     * 
     * @return The namespace into which the session data is stored. Supported namespaces are: Custom
     * @see SessionDataNamespace
     */
    public final String namespaceAsString() {
        return namespace;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the session.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the session.
     */
    public final String sessionArn() {
        return sessionArn;
    }

    /**
     * <p>
     * The identifier of the session.
     * </p>
     * 
     * @return The identifier of the session.
     */
    public final String sessionId() {
        return sessionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasData() ? data() : null);
        hashCode = 31 * hashCode + Objects.hashCode(namespaceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sessionArn());
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSessionDataResponse)) {
            return false;
        }
        UpdateSessionDataResponse other = (UpdateSessionDataResponse) obj;
        return hasData() == other.hasData() && Objects.equals(data(), other.data())
                && Objects.equals(namespaceAsString(), other.namespaceAsString())
                && Objects.equals(sessionArn(), other.sessionArn()) && Objects.equals(sessionId(), other.sessionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateSessionDataResponse").add("Data", hasData() ? data() : null)
                .add("Namespace", namespaceAsString()).add("SessionArn", sessionArn()).add("SessionId", sessionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "data":
            return Optional.ofNullable(clazz.cast(data()));
        case "namespace":
            return Optional.ofNullable(clazz.cast(namespaceAsString()));
        case "sessionArn":
            return Optional.ofNullable(clazz.cast(sessionArn()));
        case "sessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("data", DATA_FIELD);
        map.put("namespace", NAMESPACE_FIELD);
        map.put("sessionArn", SESSION_ARN_FIELD);
        map.put("sessionId", SESSION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateSessionDataResponse, T> g) {
        return obj -> g.apply((UpdateSessionDataResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateSessionDataResponse> {
        /**
         * <p>
         * Data stored in the session.
         * </p>
         * 
         * @param data
         *        Data stored in the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder data(Collection<RuntimeSessionData> data);

        /**
         * <p>
         * Data stored in the session.
         * </p>
         * 
         * @param data
         *        Data stored in the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder data(RuntimeSessionData... data);

        /**
         * <p>
         * Data stored in the session.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qconnect.model.RuntimeSessionData.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.qconnect.model.RuntimeSessionData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qconnect.model.RuntimeSessionData.Builder#build()} is called
         * immediately and its result is passed to {@link #data(List<RuntimeSessionData>)}.
         * 
         * @param data
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qconnect.model.RuntimeSessionData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #data(java.util.Collection<RuntimeSessionData>)
         */
        Builder data(Consumer<RuntimeSessionData.Builder>... data);

        /**
         * <p>
         * The namespace into which the session data is stored. Supported namespaces are: Custom
         * </p>
         * 
         * @param namespace
         *        The namespace into which the session data is stored. Supported namespaces are: Custom
         * @see SessionDataNamespace
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SessionDataNamespace
         */
        Builder namespace(String namespace);

        /**
         * <p>
         * The namespace into which the session data is stored. Supported namespaces are: Custom
         * </p>
         * 
         * @param namespace
         *        The namespace into which the session data is stored. Supported namespaces are: Custom
         * @see SessionDataNamespace
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SessionDataNamespace
         */
        Builder namespace(SessionDataNamespace namespace);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the session.
         * </p>
         * 
         * @param sessionArn
         *        The Amazon Resource Name (ARN) of the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionArn(String sessionArn);

        /**
         * <p>
         * The identifier of the session.
         * </p>
         * 
         * @param sessionId
         *        The identifier of the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);
    }

    static final class BuilderImpl extends QConnectResponse.BuilderImpl implements Builder {
        private List<RuntimeSessionData> data = DefaultSdkAutoConstructList.getInstance();

        private String namespace;

        private String sessionArn;

        private String sessionId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSessionDataResponse model) {
            super(model);
            data(model.data);
            namespace(model.namespace);
            sessionArn(model.sessionArn);
            sessionId(model.sessionId);
        }

        public final List<RuntimeSessionData.Builder> getData() {
            List<RuntimeSessionData.Builder> result = RuntimeSessionDataListCopier.copyToBuilder(this.data);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setData(Collection<RuntimeSessionData.BuilderImpl> data) {
            this.data = RuntimeSessionDataListCopier.copyFromBuilder(data);
        }

        @Override
        public final Builder data(Collection<RuntimeSessionData> data) {
            this.data = RuntimeSessionDataListCopier.copy(data);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder data(RuntimeSessionData... data) {
            data(Arrays.asList(data));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder data(Consumer<RuntimeSessionData.Builder>... data) {
            data(Stream.of(data).map(c -> RuntimeSessionData.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNamespace() {
            return namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        @Override
        public final Builder namespace(SessionDataNamespace namespace) {
            this.namespace(namespace == null ? null : namespace.toString());
            return this;
        }

        public final String getSessionArn() {
            return sessionArn;
        }

        public final void setSessionArn(String sessionArn) {
            this.sessionArn = sessionArn;
        }

        @Override
        public final Builder sessionArn(String sessionArn) {
            this.sessionArn = sessionArn;
            return this;
        }

        public final String getSessionId() {
            return sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        @Override
        public UpdateSessionDataResponse build() {
            return new UpdateSessionDataResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
