/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateMessageTemplateMetadataRequest extends QConnectRequest implements
        ToCopyableBuilder<UpdateMessageTemplateMetadataRequest.Builder, UpdateMessageTemplateMetadataRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateMessageTemplateMetadataRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<GroupingConfiguration> GROUPING_CONFIGURATION_FIELD = SdkField
            .<GroupingConfiguration> builder(MarshallingType.SDK_POJO).memberName("groupingConfiguration")
            .getter(getter(UpdateMessageTemplateMetadataRequest::groupingConfiguration))
            .setter(setter(Builder::groupingConfiguration)).constructor(GroupingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupingConfiguration").build())
            .build();

    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("knowledgeBaseId").getter(getter(UpdateMessageTemplateMetadataRequest::knowledgeBaseId))
            .setter(setter(Builder::knowledgeBaseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("knowledgeBaseId").build()).build();

    private static final SdkField<String> MESSAGE_TEMPLATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("messageTemplateId").getter(getter(UpdateMessageTemplateMetadataRequest::messageTemplateId))
            .setter(setter(Builder::messageTemplateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("messageTemplateId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateMessageTemplateMetadataRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            GROUPING_CONFIGURATION_FIELD, KNOWLEDGE_BASE_ID_FIELD, MESSAGE_TEMPLATE_ID_FIELD, NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String description;

    private final GroupingConfiguration groupingConfiguration;

    private final String knowledgeBaseId;

    private final String messageTemplateId;

    private final String name;

    private UpdateMessageTemplateMetadataRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.groupingConfiguration = builder.groupingConfiguration;
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.messageTemplateId = builder.messageTemplateId;
        this.name = builder.name;
    }

    /**
     * <p>
     * The description of the message template.
     * </p>
     * 
     * @return The description of the message template.
     */
    public final String description() {
        return description;
    }

    /**
     * Returns the value of the GroupingConfiguration property for this object.
     * 
     * @return The value of the GroupingConfiguration property for this object.
     */
    public final GroupingConfiguration groupingConfiguration() {
        return groupingConfiguration;
    }

    /**
     * <p>
     * The identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.
     * </p>
     * 
     * @return The identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.
     */
    public final String knowledgeBaseId() {
        return knowledgeBaseId;
    }

    /**
     * <p>
     * The identifier of the message template. Can be either the ID or the ARN. It cannot contain any qualifier.
     * </p>
     * 
     * @return The identifier of the message template. Can be either the ID or the ARN. It cannot contain any qualifier.
     */
    public final String messageTemplateId() {
        return messageTemplateId;
    }

    /**
     * <p>
     * The name of the message template.
     * </p>
     * 
     * @return The name of the message template.
     */
    public final String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(groupingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(messageTemplateId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMessageTemplateMetadataRequest)) {
            return false;
        }
        UpdateMessageTemplateMetadataRequest other = (UpdateMessageTemplateMetadataRequest) obj;
        return Objects.equals(description(), other.description())
                && Objects.equals(groupingConfiguration(), other.groupingConfiguration())
                && Objects.equals(knowledgeBaseId(), other.knowledgeBaseId())
                && Objects.equals(messageTemplateId(), other.messageTemplateId()) && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateMessageTemplateMetadataRequest").add("Description", description())
                .add("GroupingConfiguration", groupingConfiguration()).add("KnowledgeBaseId", knowledgeBaseId())
                .add("MessageTemplateId", messageTemplateId()).add("Name", name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "groupingConfiguration":
            return Optional.ofNullable(clazz.cast(groupingConfiguration()));
        case "knowledgeBaseId":
            return Optional.ofNullable(clazz.cast(knowledgeBaseId()));
        case "messageTemplateId":
            return Optional.ofNullable(clazz.cast(messageTemplateId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("description", DESCRIPTION_FIELD);
        map.put("groupingConfiguration", GROUPING_CONFIGURATION_FIELD);
        map.put("knowledgeBaseId", KNOWLEDGE_BASE_ID_FIELD);
        map.put("messageTemplateId", MESSAGE_TEMPLATE_ID_FIELD);
        map.put("name", NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateMessageTemplateMetadataRequest, T> g) {
        return obj -> g.apply((UpdateMessageTemplateMetadataRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QConnectRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateMessageTemplateMetadataRequest> {
        /**
         * <p>
         * The description of the message template.
         * </p>
         * 
         * @param description
         *        The description of the message template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * Sets the value of the GroupingConfiguration property for this object.
         *
         * @param groupingConfiguration
         *        The new value for the GroupingConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupingConfiguration(GroupingConfiguration groupingConfiguration);

        /**
         * Sets the value of the GroupingConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link GroupingConfiguration.Builder} avoiding
         * the need to create one manually via {@link GroupingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GroupingConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #groupingConfiguration(GroupingConfiguration)}.
         * 
         * @param groupingConfiguration
         *        a consumer that will call methods on {@link GroupingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groupingConfiguration(GroupingConfiguration)
         */
        default Builder groupingConfiguration(Consumer<GroupingConfiguration.Builder> groupingConfiguration) {
            return groupingConfiguration(GroupingConfiguration.builder().applyMutation(groupingConfiguration).build());
        }

        /**
         * <p>
         * The identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.
         * </p>
         * 
         * @param knowledgeBaseId
         *        The identifier of the knowledge base. Can be either the ID or the ARN. URLs cannot contain the ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeBaseId(String knowledgeBaseId);

        /**
         * <p>
         * The identifier of the message template. Can be either the ID or the ARN. It cannot contain any qualifier.
         * </p>
         * 
         * @param messageTemplateId
         *        The identifier of the message template. Can be either the ID or the ARN. It cannot contain any
         *        qualifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageTemplateId(String messageTemplateId);

        /**
         * <p>
         * The name of the message template.
         * </p>
         * 
         * @param name
         *        The name of the message template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QConnectRequest.BuilderImpl implements Builder {
        private String description;

        private GroupingConfiguration groupingConfiguration;

        private String knowledgeBaseId;

        private String messageTemplateId;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMessageTemplateMetadataRequest model) {
            super(model);
            description(model.description);
            groupingConfiguration(model.groupingConfiguration);
            knowledgeBaseId(model.knowledgeBaseId);
            messageTemplateId(model.messageTemplateId);
            name(model.name);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final GroupingConfiguration.Builder getGroupingConfiguration() {
            return groupingConfiguration != null ? groupingConfiguration.toBuilder() : null;
        }

        public final void setGroupingConfiguration(GroupingConfiguration.BuilderImpl groupingConfiguration) {
            this.groupingConfiguration = groupingConfiguration != null ? groupingConfiguration.build() : null;
        }

        @Override
        public final Builder groupingConfiguration(GroupingConfiguration groupingConfiguration) {
            this.groupingConfiguration = groupingConfiguration;
            return this;
        }

        public final String getKnowledgeBaseId() {
            return knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final String getMessageTemplateId() {
            return messageTemplateId;
        }

        public final void setMessageTemplateId(String messageTemplateId) {
            this.messageTemplateId = messageTemplateId;
        }

        @Override
        public final Builder messageTemplateId(String messageTemplateId) {
            this.messageTemplateId = messageTemplateId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateMessageTemplateMetadataRequest build() {
            return new UpdateMessageTemplateMetadataRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
