/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAiGuardrailRequest extends QConnectRequest implements
        ToCopyableBuilder<UpdateAiGuardrailRequest.Builder, UpdateAiGuardrailRequest> {
    private static final SdkField<String> AI_GUARDRAIL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("aiGuardrailId").getter(getter(UpdateAiGuardrailRequest::aiGuardrailId))
            .setter(setter(Builder::aiGuardrailId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("aiGuardrailId").build()).build();

    private static final SdkField<String> ASSISTANT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assistantId").getter(getter(UpdateAiGuardrailRequest::assistantId)).setter(setter(Builder::assistantId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("assistantId").build()).build();

    private static final SdkField<String> BLOCKED_INPUT_MESSAGING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("blockedInputMessaging").getter(getter(UpdateAiGuardrailRequest::blockedInputMessaging))
            .setter(setter(Builder::blockedInputMessaging))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockedInputMessaging").build())
            .build();

    private static final SdkField<String> BLOCKED_OUTPUTS_MESSAGING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("blockedOutputsMessaging").getter(getter(UpdateAiGuardrailRequest::blockedOutputsMessaging))
            .setter(setter(Builder::blockedOutputsMessaging))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockedOutputsMessaging").build())
            .build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(UpdateAiGuardrailRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<AIGuardrailContentPolicyConfig> CONTENT_POLICY_CONFIG_FIELD = SdkField
            .<AIGuardrailContentPolicyConfig> builder(MarshallingType.SDK_POJO).memberName("contentPolicyConfig")
            .getter(getter(UpdateAiGuardrailRequest::contentPolicyConfig)).setter(setter(Builder::contentPolicyConfig))
            .constructor(AIGuardrailContentPolicyConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentPolicyConfig").build())
            .build();

    private static final SdkField<AIGuardrailContextualGroundingPolicyConfig> CONTEXTUAL_GROUNDING_POLICY_CONFIG_FIELD = SdkField
            .<AIGuardrailContextualGroundingPolicyConfig> builder(MarshallingType.SDK_POJO)
            .memberName("contextualGroundingPolicyConfig")
            .getter(getter(UpdateAiGuardrailRequest::contextualGroundingPolicyConfig))
            .setter(setter(Builder::contextualGroundingPolicyConfig))
            .constructor(AIGuardrailContextualGroundingPolicyConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contextualGroundingPolicyConfig")
                    .build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateAiGuardrailRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<AIGuardrailSensitiveInformationPolicyConfig> SENSITIVE_INFORMATION_POLICY_CONFIG_FIELD = SdkField
            .<AIGuardrailSensitiveInformationPolicyConfig> builder(MarshallingType.SDK_POJO)
            .memberName("sensitiveInformationPolicyConfig")
            .getter(getter(UpdateAiGuardrailRequest::sensitiveInformationPolicyConfig))
            .setter(setter(Builder::sensitiveInformationPolicyConfig))
            .constructor(AIGuardrailSensitiveInformationPolicyConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sensitiveInformationPolicyConfig")
                    .build()).build();

    private static final SdkField<AIGuardrailTopicPolicyConfig> TOPIC_POLICY_CONFIG_FIELD = SdkField
            .<AIGuardrailTopicPolicyConfig> builder(MarshallingType.SDK_POJO).memberName("topicPolicyConfig")
            .getter(getter(UpdateAiGuardrailRequest::topicPolicyConfig)).setter(setter(Builder::topicPolicyConfig))
            .constructor(AIGuardrailTopicPolicyConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topicPolicyConfig").build()).build();

    private static final SdkField<String> VISIBILITY_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("visibilityStatus").getter(getter(UpdateAiGuardrailRequest::visibilityStatusAsString))
            .setter(setter(Builder::visibilityStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("visibilityStatus").build()).build();

    private static final SdkField<AIGuardrailWordPolicyConfig> WORD_POLICY_CONFIG_FIELD = SdkField
            .<AIGuardrailWordPolicyConfig> builder(MarshallingType.SDK_POJO).memberName("wordPolicyConfig")
            .getter(getter(UpdateAiGuardrailRequest::wordPolicyConfig)).setter(setter(Builder::wordPolicyConfig))
            .constructor(AIGuardrailWordPolicyConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("wordPolicyConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AI_GUARDRAIL_ID_FIELD,
            ASSISTANT_ID_FIELD, BLOCKED_INPUT_MESSAGING_FIELD, BLOCKED_OUTPUTS_MESSAGING_FIELD, CLIENT_TOKEN_FIELD,
            CONTENT_POLICY_CONFIG_FIELD, CONTEXTUAL_GROUNDING_POLICY_CONFIG_FIELD, DESCRIPTION_FIELD,
            SENSITIVE_INFORMATION_POLICY_CONFIG_FIELD, TOPIC_POLICY_CONFIG_FIELD, VISIBILITY_STATUS_FIELD,
            WORD_POLICY_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String aiGuardrailId;

    private final String assistantId;

    private final String blockedInputMessaging;

    private final String blockedOutputsMessaging;

    private final String clientToken;

    private final AIGuardrailContentPolicyConfig contentPolicyConfig;

    private final AIGuardrailContextualGroundingPolicyConfig contextualGroundingPolicyConfig;

    private final String description;

    private final AIGuardrailSensitiveInformationPolicyConfig sensitiveInformationPolicyConfig;

    private final AIGuardrailTopicPolicyConfig topicPolicyConfig;

    private final String visibilityStatus;

    private final AIGuardrailWordPolicyConfig wordPolicyConfig;

    private UpdateAiGuardrailRequest(BuilderImpl builder) {
        super(builder);
        this.aiGuardrailId = builder.aiGuardrailId;
        this.assistantId = builder.assistantId;
        this.blockedInputMessaging = builder.blockedInputMessaging;
        this.blockedOutputsMessaging = builder.blockedOutputsMessaging;
        this.clientToken = builder.clientToken;
        this.contentPolicyConfig = builder.contentPolicyConfig;
        this.contextualGroundingPolicyConfig = builder.contextualGroundingPolicyConfig;
        this.description = builder.description;
        this.sensitiveInformationPolicyConfig = builder.sensitiveInformationPolicyConfig;
        this.topicPolicyConfig = builder.topicPolicyConfig;
        this.visibilityStatus = builder.visibilityStatus;
        this.wordPolicyConfig = builder.wordPolicyConfig;
    }

    /**
     * <p>
     * The identifier of the Amazon Q in Connect AI Guardrail.
     * </p>
     * 
     * @return The identifier of the Amazon Q in Connect AI Guardrail.
     */
    public final String aiGuardrailId() {
        return aiGuardrailId;
    }

    /**
     * <p>
     * The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain the
     * ARN.
     * </p>
     * 
     * @return The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain
     *         the ARN.
     */
    public final String assistantId() {
        return assistantId;
    }

    /**
     * <p>
     * The message to return when the AI Guardrail blocks a prompt.
     * </p>
     * 
     * @return The message to return when the AI Guardrail blocks a prompt.
     */
    public final String blockedInputMessaging() {
        return blockedInputMessaging;
    }

    /**
     * <p>
     * The message to return when the AI Guardrail blocks a model response.
     * </p>
     * 
     * @return The message to return when the AI Guardrail blocks a model response.
     */
    public final String blockedOutputsMessaging() {
        return blockedOutputsMessaging;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided,
     * the Amazon Web Services SDK populates this field. For more information about idempotency, see <a
     * href="http://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe with
     * idempotent APIs</a>..
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
     *         provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see
     *         <a href="http://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries
     *         safe with idempotent APIs</a>..
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The content filter policies to configure for the AI Guardrail.
     * </p>
     * 
     * @return The content filter policies to configure for the AI Guardrail.
     */
    public final AIGuardrailContentPolicyConfig contentPolicyConfig() {
        return contentPolicyConfig;
    }

    /**
     * <p>
     * The contextual grounding policy configuration used to create an AI Guardrail.
     * </p>
     * 
     * @return The contextual grounding policy configuration used to create an AI Guardrail.
     */
    public final AIGuardrailContextualGroundingPolicyConfig contextualGroundingPolicyConfig() {
        return contextualGroundingPolicyConfig;
    }

    /**
     * <p>
     * A description of the AI Guardrail.
     * </p>
     * 
     * @return A description of the AI Guardrail.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The sensitive information policy to configure for the AI Guardrail.
     * </p>
     * 
     * @return The sensitive information policy to configure for the AI Guardrail.
     */
    public final AIGuardrailSensitiveInformationPolicyConfig sensitiveInformationPolicyConfig() {
        return sensitiveInformationPolicyConfig;
    }

    /**
     * <p>
     * The topic policies to configure for the AI Guardrail.
     * </p>
     * 
     * @return The topic policies to configure for the AI Guardrail.
     */
    public final AIGuardrailTopicPolicyConfig topicPolicyConfig() {
        return topicPolicyConfig;
    }

    /**
     * <p>
     * The visibility status of the Amazon Q in Connect AI Guardrail.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibilityStatus}
     * will return {@link VisibilityStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #visibilityStatusAsString}.
     * </p>
     * 
     * @return The visibility status of the Amazon Q in Connect AI Guardrail.
     * @see VisibilityStatus
     */
    public final VisibilityStatus visibilityStatus() {
        return VisibilityStatus.fromValue(visibilityStatus);
    }

    /**
     * <p>
     * The visibility status of the Amazon Q in Connect AI Guardrail.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibilityStatus}
     * will return {@link VisibilityStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #visibilityStatusAsString}.
     * </p>
     * 
     * @return The visibility status of the Amazon Q in Connect AI Guardrail.
     * @see VisibilityStatus
     */
    public final String visibilityStatusAsString() {
        return visibilityStatus;
    }

    /**
     * <p>
     * The word policy you configure for the AI Guardrail.
     * </p>
     * 
     * @return The word policy you configure for the AI Guardrail.
     */
    public final AIGuardrailWordPolicyConfig wordPolicyConfig() {
        return wordPolicyConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(aiGuardrailId());
        hashCode = 31 * hashCode + Objects.hashCode(assistantId());
        hashCode = 31 * hashCode + Objects.hashCode(blockedInputMessaging());
        hashCode = 31 * hashCode + Objects.hashCode(blockedOutputsMessaging());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(contentPolicyConfig());
        hashCode = 31 * hashCode + Objects.hashCode(contextualGroundingPolicyConfig());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(sensitiveInformationPolicyConfig());
        hashCode = 31 * hashCode + Objects.hashCode(topicPolicyConfig());
        hashCode = 31 * hashCode + Objects.hashCode(visibilityStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(wordPolicyConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAiGuardrailRequest)) {
            return false;
        }
        UpdateAiGuardrailRequest other = (UpdateAiGuardrailRequest) obj;
        return Objects.equals(aiGuardrailId(), other.aiGuardrailId()) && Objects.equals(assistantId(), other.assistantId())
                && Objects.equals(blockedInputMessaging(), other.blockedInputMessaging())
                && Objects.equals(blockedOutputsMessaging(), other.blockedOutputsMessaging())
                && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(contentPolicyConfig(), other.contentPolicyConfig())
                && Objects.equals(contextualGroundingPolicyConfig(), other.contextualGroundingPolicyConfig())
                && Objects.equals(description(), other.description())
                && Objects.equals(sensitiveInformationPolicyConfig(), other.sensitiveInformationPolicyConfig())
                && Objects.equals(topicPolicyConfig(), other.topicPolicyConfig())
                && Objects.equals(visibilityStatusAsString(), other.visibilityStatusAsString())
                && Objects.equals(wordPolicyConfig(), other.wordPolicyConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAiGuardrailRequest").add("AiGuardrailId", aiGuardrailId())
                .add("AssistantId", assistantId())
                .add("BlockedInputMessaging", blockedInputMessaging() == null ? null : "*** Sensitive Data Redacted ***")
                .add("BlockedOutputsMessaging", blockedOutputsMessaging() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ClientToken", clientToken()).add("ContentPolicyConfig", contentPolicyConfig())
                .add("ContextualGroundingPolicyConfig", contextualGroundingPolicyConfig())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("SensitiveInformationPolicyConfig", sensitiveInformationPolicyConfig())
                .add("TopicPolicyConfig", topicPolicyConfig()).add("VisibilityStatus", visibilityStatusAsString())
                .add("WordPolicyConfig", wordPolicyConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "aiGuardrailId":
            return Optional.ofNullable(clazz.cast(aiGuardrailId()));
        case "assistantId":
            return Optional.ofNullable(clazz.cast(assistantId()));
        case "blockedInputMessaging":
            return Optional.ofNullable(clazz.cast(blockedInputMessaging()));
        case "blockedOutputsMessaging":
            return Optional.ofNullable(clazz.cast(blockedOutputsMessaging()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "contentPolicyConfig":
            return Optional.ofNullable(clazz.cast(contentPolicyConfig()));
        case "contextualGroundingPolicyConfig":
            return Optional.ofNullable(clazz.cast(contextualGroundingPolicyConfig()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "sensitiveInformationPolicyConfig":
            return Optional.ofNullable(clazz.cast(sensitiveInformationPolicyConfig()));
        case "topicPolicyConfig":
            return Optional.ofNullable(clazz.cast(topicPolicyConfig()));
        case "visibilityStatus":
            return Optional.ofNullable(clazz.cast(visibilityStatusAsString()));
        case "wordPolicyConfig":
            return Optional.ofNullable(clazz.cast(wordPolicyConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("aiGuardrailId", AI_GUARDRAIL_ID_FIELD);
        map.put("assistantId", ASSISTANT_ID_FIELD);
        map.put("blockedInputMessaging", BLOCKED_INPUT_MESSAGING_FIELD);
        map.put("blockedOutputsMessaging", BLOCKED_OUTPUTS_MESSAGING_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("contentPolicyConfig", CONTENT_POLICY_CONFIG_FIELD);
        map.put("contextualGroundingPolicyConfig", CONTEXTUAL_GROUNDING_POLICY_CONFIG_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("sensitiveInformationPolicyConfig", SENSITIVE_INFORMATION_POLICY_CONFIG_FIELD);
        map.put("topicPolicyConfig", TOPIC_POLICY_CONFIG_FIELD);
        map.put("visibilityStatus", VISIBILITY_STATUS_FIELD);
        map.put("wordPolicyConfig", WORD_POLICY_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAiGuardrailRequest, T> g) {
        return obj -> g.apply((UpdateAiGuardrailRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateAiGuardrailRequest> {
        /**
         * <p>
         * The identifier of the Amazon Q in Connect AI Guardrail.
         * </p>
         * 
         * @param aiGuardrailId
         *        The identifier of the Amazon Q in Connect AI Guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aiGuardrailId(String aiGuardrailId);

        /**
         * <p>
         * The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain the
         * ARN.
         * </p>
         * 
         * @param assistantId
         *        The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot
         *        contain the ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assistantId(String assistantId);

        /**
         * <p>
         * The message to return when the AI Guardrail blocks a prompt.
         * </p>
         * 
         * @param blockedInputMessaging
         *        The message to return when the AI Guardrail blocks a prompt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockedInputMessaging(String blockedInputMessaging);

        /**
         * <p>
         * The message to return when the AI Guardrail blocks a model response.
         * </p>
         * 
         * @param blockedOutputsMessaging
         *        The message to return when the AI Guardrail blocks a model response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockedOutputsMessaging(String blockedOutputsMessaging);

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
         * provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see <a
         * href="http://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe
         * with idempotent APIs</a>..
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
         *        provided, the Amazon Web Services SDK populates this field. For more information about idempotency,
         *        see <a href="http://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making
         *        retries safe with idempotent APIs</a>..
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The content filter policies to configure for the AI Guardrail.
         * </p>
         * 
         * @param contentPolicyConfig
         *        The content filter policies to configure for the AI Guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentPolicyConfig(AIGuardrailContentPolicyConfig contentPolicyConfig);

        /**
         * <p>
         * The content filter policies to configure for the AI Guardrail.
         * </p>
         * This is a convenience method that creates an instance of the {@link AIGuardrailContentPolicyConfig.Builder}
         * avoiding the need to create one manually via {@link AIGuardrailContentPolicyConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AIGuardrailContentPolicyConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #contentPolicyConfig(AIGuardrailContentPolicyConfig)}.
         * 
         * @param contentPolicyConfig
         *        a consumer that will call methods on {@link AIGuardrailContentPolicyConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contentPolicyConfig(AIGuardrailContentPolicyConfig)
         */
        default Builder contentPolicyConfig(Consumer<AIGuardrailContentPolicyConfig.Builder> contentPolicyConfig) {
            return contentPolicyConfig(AIGuardrailContentPolicyConfig.builder().applyMutation(contentPolicyConfig).build());
        }

        /**
         * <p>
         * The contextual grounding policy configuration used to create an AI Guardrail.
         * </p>
         * 
         * @param contextualGroundingPolicyConfig
         *        The contextual grounding policy configuration used to create an AI Guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contextualGroundingPolicyConfig(AIGuardrailContextualGroundingPolicyConfig contextualGroundingPolicyConfig);

        /**
         * <p>
         * The contextual grounding policy configuration used to create an AI Guardrail.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AIGuardrailContextualGroundingPolicyConfig.Builder} avoiding the need to create one manually via
         * {@link AIGuardrailContextualGroundingPolicyConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AIGuardrailContextualGroundingPolicyConfig.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #contextualGroundingPolicyConfig(AIGuardrailContextualGroundingPolicyConfig)}.
         * 
         * @param contextualGroundingPolicyConfig
         *        a consumer that will call methods on {@link AIGuardrailContextualGroundingPolicyConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contextualGroundingPolicyConfig(AIGuardrailContextualGroundingPolicyConfig)
         */
        default Builder contextualGroundingPolicyConfig(
                Consumer<AIGuardrailContextualGroundingPolicyConfig.Builder> contextualGroundingPolicyConfig) {
            return contextualGroundingPolicyConfig(AIGuardrailContextualGroundingPolicyConfig.builder()
                    .applyMutation(contextualGroundingPolicyConfig).build());
        }

        /**
         * <p>
         * A description of the AI Guardrail.
         * </p>
         * 
         * @param description
         *        A description of the AI Guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The sensitive information policy to configure for the AI Guardrail.
         * </p>
         * 
         * @param sensitiveInformationPolicyConfig
         *        The sensitive information policy to configure for the AI Guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sensitiveInformationPolicyConfig(AIGuardrailSensitiveInformationPolicyConfig sensitiveInformationPolicyConfig);

        /**
         * <p>
         * The sensitive information policy to configure for the AI Guardrail.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AIGuardrailSensitiveInformationPolicyConfig.Builder} avoiding the need to create one manually via
         * {@link AIGuardrailSensitiveInformationPolicyConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AIGuardrailSensitiveInformationPolicyConfig.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #sensitiveInformationPolicyConfig(AIGuardrailSensitiveInformationPolicyConfig)}.
         * 
         * @param sensitiveInformationPolicyConfig
         *        a consumer that will call methods on {@link AIGuardrailSensitiveInformationPolicyConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sensitiveInformationPolicyConfig(AIGuardrailSensitiveInformationPolicyConfig)
         */
        default Builder sensitiveInformationPolicyConfig(
                Consumer<AIGuardrailSensitiveInformationPolicyConfig.Builder> sensitiveInformationPolicyConfig) {
            return sensitiveInformationPolicyConfig(AIGuardrailSensitiveInformationPolicyConfig.builder()
                    .applyMutation(sensitiveInformationPolicyConfig).build());
        }

        /**
         * <p>
         * The topic policies to configure for the AI Guardrail.
         * </p>
         * 
         * @param topicPolicyConfig
         *        The topic policies to configure for the AI Guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicPolicyConfig(AIGuardrailTopicPolicyConfig topicPolicyConfig);

        /**
         * <p>
         * The topic policies to configure for the AI Guardrail.
         * </p>
         * This is a convenience method that creates an instance of the {@link AIGuardrailTopicPolicyConfig.Builder}
         * avoiding the need to create one manually via {@link AIGuardrailTopicPolicyConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AIGuardrailTopicPolicyConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #topicPolicyConfig(AIGuardrailTopicPolicyConfig)}.
         * 
         * @param topicPolicyConfig
         *        a consumer that will call methods on {@link AIGuardrailTopicPolicyConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #topicPolicyConfig(AIGuardrailTopicPolicyConfig)
         */
        default Builder topicPolicyConfig(Consumer<AIGuardrailTopicPolicyConfig.Builder> topicPolicyConfig) {
            return topicPolicyConfig(AIGuardrailTopicPolicyConfig.builder().applyMutation(topicPolicyConfig).build());
        }

        /**
         * <p>
         * The visibility status of the Amazon Q in Connect AI Guardrail.
         * </p>
         * 
         * @param visibilityStatus
         *        The visibility status of the Amazon Q in Connect AI Guardrail.
         * @see VisibilityStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VisibilityStatus
         */
        Builder visibilityStatus(String visibilityStatus);

        /**
         * <p>
         * The visibility status of the Amazon Q in Connect AI Guardrail.
         * </p>
         * 
         * @param visibilityStatus
         *        The visibility status of the Amazon Q in Connect AI Guardrail.
         * @see VisibilityStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VisibilityStatus
         */
        Builder visibilityStatus(VisibilityStatus visibilityStatus);

        /**
         * <p>
         * The word policy you configure for the AI Guardrail.
         * </p>
         * 
         * @param wordPolicyConfig
         *        The word policy you configure for the AI Guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wordPolicyConfig(AIGuardrailWordPolicyConfig wordPolicyConfig);

        /**
         * <p>
         * The word policy you configure for the AI Guardrail.
         * </p>
         * This is a convenience method that creates an instance of the {@link AIGuardrailWordPolicyConfig.Builder}
         * avoiding the need to create one manually via {@link AIGuardrailWordPolicyConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AIGuardrailWordPolicyConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #wordPolicyConfig(AIGuardrailWordPolicyConfig)}.
         * 
         * @param wordPolicyConfig
         *        a consumer that will call methods on {@link AIGuardrailWordPolicyConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #wordPolicyConfig(AIGuardrailWordPolicyConfig)
         */
        default Builder wordPolicyConfig(Consumer<AIGuardrailWordPolicyConfig.Builder> wordPolicyConfig) {
            return wordPolicyConfig(AIGuardrailWordPolicyConfig.builder().applyMutation(wordPolicyConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QConnectRequest.BuilderImpl implements Builder {
        private String aiGuardrailId;

        private String assistantId;

        private String blockedInputMessaging;

        private String blockedOutputsMessaging;

        private String clientToken;

        private AIGuardrailContentPolicyConfig contentPolicyConfig;

        private AIGuardrailContextualGroundingPolicyConfig contextualGroundingPolicyConfig;

        private String description;

        private AIGuardrailSensitiveInformationPolicyConfig sensitiveInformationPolicyConfig;

        private AIGuardrailTopicPolicyConfig topicPolicyConfig;

        private String visibilityStatus;

        private AIGuardrailWordPolicyConfig wordPolicyConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAiGuardrailRequest model) {
            super(model);
            aiGuardrailId(model.aiGuardrailId);
            assistantId(model.assistantId);
            blockedInputMessaging(model.blockedInputMessaging);
            blockedOutputsMessaging(model.blockedOutputsMessaging);
            clientToken(model.clientToken);
            contentPolicyConfig(model.contentPolicyConfig);
            contextualGroundingPolicyConfig(model.contextualGroundingPolicyConfig);
            description(model.description);
            sensitiveInformationPolicyConfig(model.sensitiveInformationPolicyConfig);
            topicPolicyConfig(model.topicPolicyConfig);
            visibilityStatus(model.visibilityStatus);
            wordPolicyConfig(model.wordPolicyConfig);
        }

        public final String getAiGuardrailId() {
            return aiGuardrailId;
        }

        public final void setAiGuardrailId(String aiGuardrailId) {
            this.aiGuardrailId = aiGuardrailId;
        }

        @Override
        public final Builder aiGuardrailId(String aiGuardrailId) {
            this.aiGuardrailId = aiGuardrailId;
            return this;
        }

        public final String getAssistantId() {
            return assistantId;
        }

        public final void setAssistantId(String assistantId) {
            this.assistantId = assistantId;
        }

        @Override
        public final Builder assistantId(String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        public final String getBlockedInputMessaging() {
            return blockedInputMessaging;
        }

        public final void setBlockedInputMessaging(String blockedInputMessaging) {
            this.blockedInputMessaging = blockedInputMessaging;
        }

        @Override
        public final Builder blockedInputMessaging(String blockedInputMessaging) {
            this.blockedInputMessaging = blockedInputMessaging;
            return this;
        }

        public final String getBlockedOutputsMessaging() {
            return blockedOutputsMessaging;
        }

        public final void setBlockedOutputsMessaging(String blockedOutputsMessaging) {
            this.blockedOutputsMessaging = blockedOutputsMessaging;
        }

        @Override
        public final Builder blockedOutputsMessaging(String blockedOutputsMessaging) {
            this.blockedOutputsMessaging = blockedOutputsMessaging;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final AIGuardrailContentPolicyConfig.Builder getContentPolicyConfig() {
            return contentPolicyConfig != null ? contentPolicyConfig.toBuilder() : null;
        }

        public final void setContentPolicyConfig(AIGuardrailContentPolicyConfig.BuilderImpl contentPolicyConfig) {
            this.contentPolicyConfig = contentPolicyConfig != null ? contentPolicyConfig.build() : null;
        }

        @Override
        public final Builder contentPolicyConfig(AIGuardrailContentPolicyConfig contentPolicyConfig) {
            this.contentPolicyConfig = contentPolicyConfig;
            return this;
        }

        public final AIGuardrailContextualGroundingPolicyConfig.Builder getContextualGroundingPolicyConfig() {
            return contextualGroundingPolicyConfig != null ? contextualGroundingPolicyConfig.toBuilder() : null;
        }

        public final void setContextualGroundingPolicyConfig(
                AIGuardrailContextualGroundingPolicyConfig.BuilderImpl contextualGroundingPolicyConfig) {
            this.contextualGroundingPolicyConfig = contextualGroundingPolicyConfig != null ? contextualGroundingPolicyConfig
                    .build() : null;
        }

        @Override
        public final Builder contextualGroundingPolicyConfig(
                AIGuardrailContextualGroundingPolicyConfig contextualGroundingPolicyConfig) {
            this.contextualGroundingPolicyConfig = contextualGroundingPolicyConfig;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final AIGuardrailSensitiveInformationPolicyConfig.Builder getSensitiveInformationPolicyConfig() {
            return sensitiveInformationPolicyConfig != null ? sensitiveInformationPolicyConfig.toBuilder() : null;
        }

        public final void setSensitiveInformationPolicyConfig(
                AIGuardrailSensitiveInformationPolicyConfig.BuilderImpl sensitiveInformationPolicyConfig) {
            this.sensitiveInformationPolicyConfig = sensitiveInformationPolicyConfig != null ? sensitiveInformationPolicyConfig
                    .build() : null;
        }

        @Override
        public final Builder sensitiveInformationPolicyConfig(
                AIGuardrailSensitiveInformationPolicyConfig sensitiveInformationPolicyConfig) {
            this.sensitiveInformationPolicyConfig = sensitiveInformationPolicyConfig;
            return this;
        }

        public final AIGuardrailTopicPolicyConfig.Builder getTopicPolicyConfig() {
            return topicPolicyConfig != null ? topicPolicyConfig.toBuilder() : null;
        }

        public final void setTopicPolicyConfig(AIGuardrailTopicPolicyConfig.BuilderImpl topicPolicyConfig) {
            this.topicPolicyConfig = topicPolicyConfig != null ? topicPolicyConfig.build() : null;
        }

        @Override
        public final Builder topicPolicyConfig(AIGuardrailTopicPolicyConfig topicPolicyConfig) {
            this.topicPolicyConfig = topicPolicyConfig;
            return this;
        }

        public final String getVisibilityStatus() {
            return visibilityStatus;
        }

        public final void setVisibilityStatus(String visibilityStatus) {
            this.visibilityStatus = visibilityStatus;
        }

        @Override
        public final Builder visibilityStatus(String visibilityStatus) {
            this.visibilityStatus = visibilityStatus;
            return this;
        }

        @Override
        public final Builder visibilityStatus(VisibilityStatus visibilityStatus) {
            this.visibilityStatus(visibilityStatus == null ? null : visibilityStatus.toString());
            return this;
        }

        public final AIGuardrailWordPolicyConfig.Builder getWordPolicyConfig() {
            return wordPolicyConfig != null ? wordPolicyConfig.toBuilder() : null;
        }

        public final void setWordPolicyConfig(AIGuardrailWordPolicyConfig.BuilderImpl wordPolicyConfig) {
            this.wordPolicyConfig = wordPolicyConfig != null ? wordPolicyConfig.build() : null;
        }

        @Override
        public final Builder wordPolicyConfig(AIGuardrailWordPolicyConfig wordPolicyConfig) {
            this.wordPolicyConfig = wordPolicyConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAiGuardrailRequest build() {
            return new UpdateAiGuardrailRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
