/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SendMessageResponse extends QConnectResponse implements
        ToCopyableBuilder<SendMessageResponse.Builder, SendMessageResponse> {
    private static final SdkField<String> NEXT_MESSAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextMessageToken").getter(getter(SendMessageResponse::nextMessageToken))
            .setter(setter(Builder::nextMessageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextMessageToken").build()).build();

    private static final SdkField<String> REQUEST_MESSAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("requestMessageId").getter(getter(SendMessageResponse::requestMessageId))
            .setter(setter(Builder::requestMessageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestMessageId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_MESSAGE_TOKEN_FIELD,
            REQUEST_MESSAGE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextMessageToken;

    private final String requestMessageId;

    private SendMessageResponse(BuilderImpl builder) {
        super(builder);
        this.nextMessageToken = builder.nextMessageToken;
        this.requestMessageId = builder.requestMessageId;
    }

    /**
     * <p>
     * The token for the next message, used by GetNextMessage.
     * </p>
     * 
     * @return The token for the next message, used by GetNextMessage.
     */
    public final String nextMessageToken() {
        return nextMessageToken;
    }

    /**
     * <p>
     * The identifier of the submitted message.
     * </p>
     * 
     * @return The identifier of the submitted message.
     */
    public final String requestMessageId() {
        return requestMessageId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextMessageToken());
        hashCode = 31 * hashCode + Objects.hashCode(requestMessageId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendMessageResponse)) {
            return false;
        }
        SendMessageResponse other = (SendMessageResponse) obj;
        return Objects.equals(nextMessageToken(), other.nextMessageToken())
                && Objects.equals(requestMessageId(), other.requestMessageId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SendMessageResponse").add("NextMessageToken", nextMessageToken())
                .add("RequestMessageId", requestMessageId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextMessageToken":
            return Optional.ofNullable(clazz.cast(nextMessageToken()));
        case "requestMessageId":
            return Optional.ofNullable(clazz.cast(requestMessageId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextMessageToken", NEXT_MESSAGE_TOKEN_FIELD);
        map.put("requestMessageId", REQUEST_MESSAGE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SendMessageResponse, T> g) {
        return obj -> g.apply((SendMessageResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, SendMessageResponse> {
        /**
         * <p>
         * The token for the next message, used by GetNextMessage.
         * </p>
         * 
         * @param nextMessageToken
         *        The token for the next message, used by GetNextMessage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMessageToken(String nextMessageToken);

        /**
         * <p>
         * The identifier of the submitted message.
         * </p>
         * 
         * @param requestMessageId
         *        The identifier of the submitted message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestMessageId(String requestMessageId);
    }

    static final class BuilderImpl extends QConnectResponse.BuilderImpl implements Builder {
        private String nextMessageToken;

        private String requestMessageId;

        private BuilderImpl() {
        }

        private BuilderImpl(SendMessageResponse model) {
            super(model);
            nextMessageToken(model.nextMessageToken);
            requestMessageId(model.requestMessageId);
        }

        public final String getNextMessageToken() {
            return nextMessageToken;
        }

        public final void setNextMessageToken(String nextMessageToken) {
            this.nextMessageToken = nextMessageToken;
        }

        @Override
        public final Builder nextMessageToken(String nextMessageToken) {
            this.nextMessageToken = nextMessageToken;
            return this;
        }

        public final String getRequestMessageId() {
            return requestMessageId;
        }

        public final void setRequestMessageId(String requestMessageId) {
            this.requestMessageId = requestMessageId;
        }

        @Override
        public final Builder requestMessageId(String requestMessageId) {
            this.requestMessageId = requestMessageId;
            return this;
        }

        @Override
        public SendMessageResponse build() {
            return new SendMessageResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
