/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The body to use in SMS messages.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SMSMessageTemplateContentBody implements SdkPojo, Serializable,
        ToCopyableBuilder<SMSMessageTemplateContentBody.Builder, SMSMessageTemplateContentBody> {
    private static final SdkField<MessageTemplateBodyContentProvider> PLAIN_TEXT_FIELD = SdkField
            .<MessageTemplateBodyContentProvider> builder(MarshallingType.SDK_POJO).memberName("plainText")
            .getter(getter(SMSMessageTemplateContentBody::plainText)).setter(setter(Builder::plainText))
            .constructor(MessageTemplateBodyContentProvider::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("plainText").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLAIN_TEXT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final MessageTemplateBodyContentProvider plainText;

    private SMSMessageTemplateContentBody(BuilderImpl builder) {
        this.plainText = builder.plainText;
    }

    /**
     * <p>
     * The message body to use in SMS messages.
     * </p>
     * 
     * @return The message body to use in SMS messages.
     */
    public final MessageTemplateBodyContentProvider plainText() {
        return plainText;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(plainText());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SMSMessageTemplateContentBody)) {
            return false;
        }
        SMSMessageTemplateContentBody other = (SMSMessageTemplateContentBody) obj;
        return Objects.equals(plainText(), other.plainText());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SMSMessageTemplateContentBody").add("PlainText", plainText()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "plainText":
            return Optional.ofNullable(clazz.cast(plainText()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("plainText", PLAIN_TEXT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SMSMessageTemplateContentBody, T> g) {
        return obj -> g.apply((SMSMessageTemplateContentBody) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SMSMessageTemplateContentBody> {
        /**
         * <p>
         * The message body to use in SMS messages.
         * </p>
         * 
         * @param plainText
         *        The message body to use in SMS messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder plainText(MessageTemplateBodyContentProvider plainText);

        /**
         * <p>
         * The message body to use in SMS messages.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link MessageTemplateBodyContentProvider.Builder} avoiding the need to create one manually via
         * {@link MessageTemplateBodyContentProvider#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MessageTemplateBodyContentProvider.Builder#build()} is called
         * immediately and its result is passed to {@link #plainText(MessageTemplateBodyContentProvider)}.
         * 
         * @param plainText
         *        a consumer that will call methods on {@link MessageTemplateBodyContentProvider.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #plainText(MessageTemplateBodyContentProvider)
         */
        default Builder plainText(Consumer<MessageTemplateBodyContentProvider.Builder> plainText) {
            return plainText(MessageTemplateBodyContentProvider.builder().applyMutation(plainText).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private MessageTemplateBodyContentProvider plainText;

        private BuilderImpl() {
        }

        private BuilderImpl(SMSMessageTemplateContentBody model) {
            plainText(model.plainText);
        }

        public final MessageTemplateBodyContentProvider.Builder getPlainText() {
            return plainText != null ? plainText.toBuilder() : null;
        }

        public final void setPlainText(MessageTemplateBodyContentProvider.BuilderImpl plainText) {
            this.plainText = plainText != null ? plainText.build() : null;
        }

        @Override
        public final Builder plainText(MessageTemplateBodyContentProvider plainText) {
            this.plainText = plainText;
            return this;
        }

        @Override
        public SMSMessageTemplateContentBody build() {
            return new SMSMessageTemplateContentBody(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
