/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about how to query content.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QueryCondition implements SdkPojo, Serializable, ToCopyableBuilder<QueryCondition.Builder, QueryCondition> {
    private static final SdkField<QueryConditionItem> SINGLE_FIELD = SdkField
            .<QueryConditionItem> builder(MarshallingType.SDK_POJO).memberName("single").getter(getter(QueryCondition::single))
            .setter(setter(Builder::single)).constructor(QueryConditionItem::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("single").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SINGLE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final QueryConditionItem single;

    private final Type type;

    private QueryCondition(BuilderImpl builder) {
        this.single = builder.single;
        this.type = builder.type;
    }

    /**
     * <p>
     * The condition for the query.
     * </p>
     * 
     * @return The condition for the query.
     */
    public final QueryConditionItem single() {
        return single;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(single());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryCondition)) {
            return false;
        }
        QueryCondition other = (QueryCondition) obj;
        return Objects.equals(single(), other.single());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QueryCondition").add("Single", single()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "single":
            return Optional.ofNullable(clazz.cast(single()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #single()} initialized to the given value.
     *
     * <p>
     * The condition for the query.
     * </p>
     * 
     * @param single
     *        The condition for the query.
     */
    public static QueryCondition fromSingle(QueryConditionItem single) {
        return builder().single(single).build();
    }

    /**
     * Create an instance of this class with {@link #single()} initialized to the given value.
     *
     * <p>
     * The condition for the query.
     * </p>
     * 
     * @param single
     *        The condition for the query.
     */
    public static QueryCondition fromSingle(Consumer<QueryConditionItem.Builder> single) {
        QueryConditionItem.Builder builder = QueryConditionItem.builder();
        single.accept(builder);
        return fromSingle(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("single", SINGLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<QueryCondition, T> g) {
        return obj -> g.apply((QueryCondition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QueryCondition> {
        /**
         * <p>
         * The condition for the query.
         * </p>
         * 
         * @param single
         *        The condition for the query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder single(QueryConditionItem single);

        /**
         * <p>
         * The condition for the query.
         * </p>
         * This is a convenience method that creates an instance of the {@link QueryConditionItem.Builder} avoiding the
         * need to create one manually via {@link QueryConditionItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link QueryConditionItem.Builder#build()} is called immediately and its
         * result is passed to {@link #single(QueryConditionItem)}.
         * 
         * @param single
         *        a consumer that will call methods on {@link QueryConditionItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #single(QueryConditionItem)
         */
        default Builder single(Consumer<QueryConditionItem.Builder> single) {
            return single(QueryConditionItem.builder().applyMutation(single).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private QueryConditionItem single;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(QueryCondition model) {
            single(model.single);
        }

        public final QueryConditionItem.Builder getSingle() {
            return single != null ? single.toBuilder() : null;
        }

        public final void setSingle(QueryConditionItem.BuilderImpl single) {
            Object oldValue = this.single;
            this.single = single != null ? single.build() : null;
            handleUnionValueChange(Type.SINGLE, oldValue, this.single);
        }

        @Override
        public final Builder single(QueryConditionItem single) {
            Object oldValue = this.single;
            this.single = single;
            handleUnionValueChange(Type.SINGLE, oldValue, this.single);
            return this;
        }

        @Override
        public QueryCondition build() {
            return new QueryCondition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see QueryCondition#type()
     */
    public enum Type {
        SINGLE,

        UNKNOWN_TO_SDK_VERSION
    }
}
