/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutFeedbackRequest extends QConnectRequest implements
        ToCopyableBuilder<PutFeedbackRequest.Builder, PutFeedbackRequest> {
    private static final SdkField<String> ASSISTANT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assistantId").getter(getter(PutFeedbackRequest::assistantId)).setter(setter(Builder::assistantId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("assistantId").build()).build();

    private static final SdkField<ContentFeedbackData> CONTENT_FEEDBACK_FIELD = SdkField
            .<ContentFeedbackData> builder(MarshallingType.SDK_POJO).memberName("contentFeedback")
            .getter(getter(PutFeedbackRequest::contentFeedback)).setter(setter(Builder::contentFeedback))
            .constructor(ContentFeedbackData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentFeedback").build()).build();

    private static final SdkField<String> TARGET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetId").getter(getter(PutFeedbackRequest::targetId)).setter(setter(Builder::targetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetId").build()).build();

    private static final SdkField<String> TARGET_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetType").getter(getter(PutFeedbackRequest::targetTypeAsString)).setter(setter(Builder::targetType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSISTANT_ID_FIELD,
            CONTENT_FEEDBACK_FIELD, TARGET_ID_FIELD, TARGET_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String assistantId;

    private final ContentFeedbackData contentFeedback;

    private final String targetId;

    private final String targetType;

    private PutFeedbackRequest(BuilderImpl builder) {
        super(builder);
        this.assistantId = builder.assistantId;
        this.contentFeedback = builder.contentFeedback;
        this.targetId = builder.targetId;
        this.targetType = builder.targetType;
    }

    /**
     * <p>
     * The identifier of the Amazon Q in Connect assistant.
     * </p>
     * 
     * @return The identifier of the Amazon Q in Connect assistant.
     */
    public final String assistantId() {
        return assistantId;
    }

    /**
     * <p>
     * Information about the feedback provided.
     * </p>
     * 
     * @return Information about the feedback provided.
     */
    public final ContentFeedbackData contentFeedback() {
        return contentFeedback;
    }

    /**
     * <p>
     * The identifier of the feedback target.
     * </p>
     * 
     * @return The identifier of the feedback target.
     */
    public final String targetId() {
        return targetId;
    }

    /**
     * <p>
     * The type of the feedback target.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetType} will
     * return {@link TargetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #targetTypeAsString}.
     * </p>
     * 
     * @return The type of the feedback target.
     * @see TargetType
     */
    public final TargetType targetType() {
        return TargetType.fromValue(targetType);
    }

    /**
     * <p>
     * The type of the feedback target.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetType} will
     * return {@link TargetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #targetTypeAsString}.
     * </p>
     * 
     * @return The type of the feedback target.
     * @see TargetType
     */
    public final String targetTypeAsString() {
        return targetType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assistantId());
        hashCode = 31 * hashCode + Objects.hashCode(contentFeedback());
        hashCode = 31 * hashCode + Objects.hashCode(targetId());
        hashCode = 31 * hashCode + Objects.hashCode(targetTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutFeedbackRequest)) {
            return false;
        }
        PutFeedbackRequest other = (PutFeedbackRequest) obj;
        return Objects.equals(assistantId(), other.assistantId()) && Objects.equals(contentFeedback(), other.contentFeedback())
                && Objects.equals(targetId(), other.targetId())
                && Objects.equals(targetTypeAsString(), other.targetTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutFeedbackRequest").add("AssistantId", assistantId()).add("ContentFeedback", contentFeedback())
                .add("TargetId", targetId()).add("TargetType", targetTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assistantId":
            return Optional.ofNullable(clazz.cast(assistantId()));
        case "contentFeedback":
            return Optional.ofNullable(clazz.cast(contentFeedback()));
        case "targetId":
            return Optional.ofNullable(clazz.cast(targetId()));
        case "targetType":
            return Optional.ofNullable(clazz.cast(targetTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("assistantId", ASSISTANT_ID_FIELD);
        map.put("contentFeedback", CONTENT_FEEDBACK_FIELD);
        map.put("targetId", TARGET_ID_FIELD);
        map.put("targetType", TARGET_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutFeedbackRequest, T> g) {
        return obj -> g.apply((PutFeedbackRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutFeedbackRequest> {
        /**
         * <p>
         * The identifier of the Amazon Q in Connect assistant.
         * </p>
         * 
         * @param assistantId
         *        The identifier of the Amazon Q in Connect assistant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assistantId(String assistantId);

        /**
         * <p>
         * Information about the feedback provided.
         * </p>
         * 
         * @param contentFeedback
         *        Information about the feedback provided.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentFeedback(ContentFeedbackData contentFeedback);

        /**
         * <p>
         * Information about the feedback provided.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContentFeedbackData.Builder} avoiding the
         * need to create one manually via {@link ContentFeedbackData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContentFeedbackData.Builder#build()} is called immediately and
         * its result is passed to {@link #contentFeedback(ContentFeedbackData)}.
         * 
         * @param contentFeedback
         *        a consumer that will call methods on {@link ContentFeedbackData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contentFeedback(ContentFeedbackData)
         */
        default Builder contentFeedback(Consumer<ContentFeedbackData.Builder> contentFeedback) {
            return contentFeedback(ContentFeedbackData.builder().applyMutation(contentFeedback).build());
        }

        /**
         * <p>
         * The identifier of the feedback target.
         * </p>
         * 
         * @param targetId
         *        The identifier of the feedback target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetId(String targetId);

        /**
         * <p>
         * The type of the feedback target.
         * </p>
         * 
         * @param targetType
         *        The type of the feedback target.
         * @see TargetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetType
         */
        Builder targetType(String targetType);

        /**
         * <p>
         * The type of the feedback target.
         * </p>
         * 
         * @param targetType
         *        The type of the feedback target.
         * @see TargetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetType
         */
        Builder targetType(TargetType targetType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QConnectRequest.BuilderImpl implements Builder {
        private String assistantId;

        private ContentFeedbackData contentFeedback;

        private String targetId;

        private String targetType;

        private BuilderImpl() {
        }

        private BuilderImpl(PutFeedbackRequest model) {
            super(model);
            assistantId(model.assistantId);
            contentFeedback(model.contentFeedback);
            targetId(model.targetId);
            targetType(model.targetType);
        }

        public final String getAssistantId() {
            return assistantId;
        }

        public final void setAssistantId(String assistantId) {
            this.assistantId = assistantId;
        }

        @Override
        public final Builder assistantId(String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        public final ContentFeedbackData.Builder getContentFeedback() {
            return contentFeedback != null ? contentFeedback.toBuilder() : null;
        }

        public final void setContentFeedback(ContentFeedbackData.BuilderImpl contentFeedback) {
            this.contentFeedback = contentFeedback != null ? contentFeedback.build() : null;
        }

        @Override
        public final Builder contentFeedback(ContentFeedbackData contentFeedback) {
            this.contentFeedback = contentFeedback;
            return this;
        }

        public final String getTargetId() {
            return targetId;
        }

        public final void setTargetId(String targetId) {
            this.targetId = targetId;
        }

        @Override
        public final Builder targetId(String targetId) {
            this.targetId = targetId;
            return this;
        }

        public final String getTargetType() {
            return targetType;
        }

        public final void setTargetType(String targetType) {
            this.targetType = targetType;
        }

        @Override
        public final Builder targetType(String targetType) {
            this.targetType = targetType;
            return this;
        }

        @Override
        public final Builder targetType(TargetType targetType) {
            this.targetType(targetType == null ? null : targetType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutFeedbackRequest build() {
            return new PutFeedbackRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
