/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of conditions which would be applied together with an <code>OR</code> condition.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OrCondition implements SdkPojo, Serializable, ToCopyableBuilder<OrCondition.Builder, OrCondition> {
    private static final SdkField<List<TagCondition>> AND_CONDITIONS_FIELD = SdkField
            .<List<TagCondition>> builder(MarshallingType.LIST)
            .memberName("andConditions")
            .getter(getter(OrCondition::andConditions))
            .setter(setter(Builder::andConditions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("andConditions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TagCondition> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagCondition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<TagCondition> TAG_CONDITION_FIELD = SdkField.<TagCondition> builder(MarshallingType.SDK_POJO)
            .memberName("tagCondition").getter(getter(OrCondition::tagCondition)).setter(setter(Builder::tagCondition))
            .constructor(TagCondition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tagCondition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AND_CONDITIONS_FIELD,
            TAG_CONDITION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<TagCondition> andConditions;

    private final TagCondition tagCondition;

    private final Type type;

    private OrCondition(BuilderImpl builder) {
        this.andConditions = builder.andConditions;
        this.tagCondition = builder.tagCondition;
        this.type = builder.type;
    }

    /**
     * For responses, this returns true if the service returned a value for the AndConditions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAndConditions() {
        return andConditions != null && !(andConditions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of conditions which would be applied together with an <code>AND</code> condition.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAndConditions} method.
     * </p>
     * 
     * @return A list of conditions which would be applied together with an <code>AND</code> condition.
     */
    public final List<TagCondition> andConditions() {
        return andConditions;
    }

    /**
     * <p>
     * A leaf node condition which can be used to specify a tag condition.
     * </p>
     * 
     * @return A leaf node condition which can be used to specify a tag condition.
     */
    public final TagCondition tagCondition() {
        return tagCondition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAndConditions() ? andConditions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(tagCondition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrCondition)) {
            return false;
        }
        OrCondition other = (OrCondition) obj;
        return hasAndConditions() == other.hasAndConditions() && Objects.equals(andConditions(), other.andConditions())
                && Objects.equals(tagCondition(), other.tagCondition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OrCondition").add("AndConditions", hasAndConditions() ? andConditions() : null)
                .add("TagCondition", tagCondition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "andConditions":
            return Optional.ofNullable(clazz.cast(andConditions()));
        case "tagCondition":
            return Optional.ofNullable(clazz.cast(tagCondition()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #andConditions()} initialized to the given value.
     *
     * <p>
     * A list of conditions which would be applied together with an <code>AND</code> condition.
     * </p>
     * 
     * @param andConditions
     *        A list of conditions which would be applied together with an <code>AND</code> condition.
     */
    public static OrCondition fromAndConditions(List<TagCondition> andConditions) {
        return builder().andConditions(andConditions).build();
    }

    /**
     * Create an instance of this class with {@link #tagCondition()} initialized to the given value.
     *
     * <p>
     * A leaf node condition which can be used to specify a tag condition.
     * </p>
     * 
     * @param tagCondition
     *        A leaf node condition which can be used to specify a tag condition.
     */
    public static OrCondition fromTagCondition(TagCondition tagCondition) {
        return builder().tagCondition(tagCondition).build();
    }

    /**
     * Create an instance of this class with {@link #tagCondition()} initialized to the given value.
     *
     * <p>
     * A leaf node condition which can be used to specify a tag condition.
     * </p>
     * 
     * @param tagCondition
     *        A leaf node condition which can be used to specify a tag condition.
     */
    public static OrCondition fromTagCondition(Consumer<TagCondition.Builder> tagCondition) {
        TagCondition.Builder builder = TagCondition.builder();
        tagCondition.accept(builder);
        return fromTagCondition(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("andConditions", AND_CONDITIONS_FIELD);
        map.put("tagCondition", TAG_CONDITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OrCondition, T> g) {
        return obj -> g.apply((OrCondition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OrCondition> {
        /**
         * <p>
         * A list of conditions which would be applied together with an <code>AND</code> condition.
         * </p>
         * 
         * @param andConditions
         *        A list of conditions which would be applied together with an <code>AND</code> condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder andConditions(Collection<TagCondition> andConditions);

        /**
         * <p>
         * A list of conditions which would be applied together with an <code>AND</code> condition.
         * </p>
         * 
         * @param andConditions
         *        A list of conditions which would be applied together with an <code>AND</code> condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder andConditions(TagCondition... andConditions);

        /**
         * <p>
         * A list of conditions which would be applied together with an <code>AND</code> condition.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qconnect.model.TagCondition.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.qconnect.model.TagCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qconnect.model.TagCondition.Builder#build()} is called immediately and
         * its result is passed to {@link #andConditions(List<TagCondition>)}.
         * 
         * @param andConditions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qconnect.model.TagCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #andConditions(java.util.Collection<TagCondition>)
         */
        Builder andConditions(Consumer<TagCondition.Builder>... andConditions);

        /**
         * <p>
         * A leaf node condition which can be used to specify a tag condition.
         * </p>
         * 
         * @param tagCondition
         *        A leaf node condition which can be used to specify a tag condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagCondition(TagCondition tagCondition);

        /**
         * <p>
         * A leaf node condition which can be used to specify a tag condition.
         * </p>
         * This is a convenience method that creates an instance of the {@link TagCondition.Builder} avoiding the need
         * to create one manually via {@link TagCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TagCondition.Builder#build()} is called immediately and its
         * result is passed to {@link #tagCondition(TagCondition)}.
         * 
         * @param tagCondition
         *        a consumer that will call methods on {@link TagCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagCondition(TagCondition)
         */
        default Builder tagCondition(Consumer<TagCondition.Builder> tagCondition) {
            return tagCondition(TagCondition.builder().applyMutation(tagCondition).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<TagCondition> andConditions = DefaultSdkAutoConstructList.getInstance();

        private TagCondition tagCondition;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(OrCondition model) {
            andConditions(model.andConditions);
            tagCondition(model.tagCondition);
        }

        public final List<TagCondition.Builder> getAndConditions() {
            List<TagCondition.Builder> result = AndConditionsCopier.copyToBuilder(this.andConditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAndConditions(Collection<TagCondition.BuilderImpl> andConditions) {
            Object oldValue = this.andConditions;
            this.andConditions = AndConditionsCopier.copyFromBuilder(andConditions);
            handleUnionValueChange(Type.AND_CONDITIONS, oldValue, this.andConditions);
        }

        @Override
        public final Builder andConditions(Collection<TagCondition> andConditions) {
            Object oldValue = this.andConditions;
            this.andConditions = AndConditionsCopier.copy(andConditions);
            handleUnionValueChange(Type.AND_CONDITIONS, oldValue, this.andConditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder andConditions(TagCondition... andConditions) {
            andConditions(Arrays.asList(andConditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder andConditions(Consumer<TagCondition.Builder>... andConditions) {
            andConditions(Stream.of(andConditions).map(c -> TagCondition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final TagCondition.Builder getTagCondition() {
            return tagCondition != null ? tagCondition.toBuilder() : null;
        }

        public final void setTagCondition(TagCondition.BuilderImpl tagCondition) {
            Object oldValue = this.tagCondition;
            this.tagCondition = tagCondition != null ? tagCondition.build() : null;
            handleUnionValueChange(Type.TAG_CONDITION, oldValue, this.tagCondition);
        }

        @Override
        public final Builder tagCondition(TagCondition tagCondition) {
            Object oldValue = this.tagCondition;
            this.tagCondition = tagCondition;
            handleUnionValueChange(Type.TAG_CONDITION, oldValue, this.tagCondition);
            return this;
        }

        @Override
        public OrCondition build() {
            return new OrCondition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see OrCondition#type()
     */
    public enum Type {
        AND_CONDITIONS,

        TAG_CONDITION,

        UNKNOWN_TO_SDK_VERSION
    }
}
