/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the message template attachment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MessageTemplateAttachment implements SdkPojo, Serializable,
        ToCopyableBuilder<MessageTemplateAttachment.Builder, MessageTemplateAttachment> {
    private static final SdkField<String> ATTACHMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("attachmentId").getter(getter(MessageTemplateAttachment::attachmentId))
            .setter(setter(Builder::attachmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachmentId").build()).build();

    private static final SdkField<String> CONTENT_DISPOSITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("contentDisposition").getter(getter(MessageTemplateAttachment::contentDispositionAsString))
            .setter(setter(Builder::contentDisposition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentDisposition").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(MessageTemplateAttachment::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Instant> UPLOADED_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("uploadedTime")
            .getter(getter(MessageTemplateAttachment::uploadedTime))
            .setter(setter(Builder::uploadedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uploadedTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> URL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("url")
            .getter(getter(MessageTemplateAttachment::url)).setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("url").build()).build();

    private static final SdkField<Instant> URL_EXPIRY_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("urlExpiry")
            .getter(getter(MessageTemplateAttachment::urlExpiry))
            .setter(setter(Builder::urlExpiry))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("urlExpiry").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACHMENT_ID_FIELD,
            CONTENT_DISPOSITION_FIELD, NAME_FIELD, UPLOADED_TIME_FIELD, URL_FIELD, URL_EXPIRY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String attachmentId;

    private final String contentDisposition;

    private final String name;

    private final Instant uploadedTime;

    private final String url;

    private final Instant urlExpiry;

    private MessageTemplateAttachment(BuilderImpl builder) {
        this.attachmentId = builder.attachmentId;
        this.contentDisposition = builder.contentDisposition;
        this.name = builder.name;
        this.uploadedTime = builder.uploadedTime;
        this.url = builder.url;
        this.urlExpiry = builder.urlExpiry;
    }

    /**
     * <p>
     * The identifier of the attachment file.
     * </p>
     * 
     * @return The identifier of the attachment file.
     */
    public final String attachmentId() {
        return attachmentId;
    }

    /**
     * <p>
     * The presentation information for the attachment file.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #contentDisposition} will return {@link ContentDisposition#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #contentDispositionAsString}.
     * </p>
     * 
     * @return The presentation information for the attachment file.
     * @see ContentDisposition
     */
    public final ContentDisposition contentDisposition() {
        return ContentDisposition.fromValue(contentDisposition);
    }

    /**
     * <p>
     * The presentation information for the attachment file.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #contentDisposition} will return {@link ContentDisposition#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #contentDispositionAsString}.
     * </p>
     * 
     * @return The presentation information for the attachment file.
     * @see ContentDisposition
     */
    public final String contentDispositionAsString() {
        return contentDisposition;
    }

    /**
     * <p>
     * The name of the attachment file being uploaded. The name should include the file extension.
     * </p>
     * 
     * @return The name of the attachment file being uploaded. The name should include the file extension.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The timestamp when the attachment file was uploaded.
     * </p>
     * 
     * @return The timestamp when the attachment file was uploaded.
     */
    public final Instant uploadedTime() {
        return uploadedTime;
    }

    /**
     * <p>
     * A pre-signed Amazon S3 URL that can be used to download the attachment file.
     * </p>
     * 
     * @return A pre-signed Amazon S3 URL that can be used to download the attachment file.
     */
    public final String url() {
        return url;
    }

    /**
     * <p>
     * The expiration time of the pre-signed Amazon S3 URL.
     * </p>
     * 
     * @return The expiration time of the pre-signed Amazon S3 URL.
     */
    public final Instant urlExpiry() {
        return urlExpiry;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(contentDispositionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(uploadedTime());
        hashCode = 31 * hashCode + Objects.hashCode(url());
        hashCode = 31 * hashCode + Objects.hashCode(urlExpiry());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MessageTemplateAttachment)) {
            return false;
        }
        MessageTemplateAttachment other = (MessageTemplateAttachment) obj;
        return Objects.equals(attachmentId(), other.attachmentId())
                && Objects.equals(contentDispositionAsString(), other.contentDispositionAsString())
                && Objects.equals(name(), other.name()) && Objects.equals(uploadedTime(), other.uploadedTime())
                && Objects.equals(url(), other.url()) && Objects.equals(urlExpiry(), other.urlExpiry());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MessageTemplateAttachment").add("AttachmentId", attachmentId())
                .add("ContentDisposition", contentDispositionAsString())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***").add("UploadedTime", uploadedTime())
                .add("Url", url() == null ? null : "*** Sensitive Data Redacted ***").add("UrlExpiry", urlExpiry()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "attachmentId":
            return Optional.ofNullable(clazz.cast(attachmentId()));
        case "contentDisposition":
            return Optional.ofNullable(clazz.cast(contentDispositionAsString()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "uploadedTime":
            return Optional.ofNullable(clazz.cast(uploadedTime()));
        case "url":
            return Optional.ofNullable(clazz.cast(url()));
        case "urlExpiry":
            return Optional.ofNullable(clazz.cast(urlExpiry()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("attachmentId", ATTACHMENT_ID_FIELD);
        map.put("contentDisposition", CONTENT_DISPOSITION_FIELD);
        map.put("name", NAME_FIELD);
        map.put("uploadedTime", UPLOADED_TIME_FIELD);
        map.put("url", URL_FIELD);
        map.put("urlExpiry", URL_EXPIRY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MessageTemplateAttachment, T> g) {
        return obj -> g.apply((MessageTemplateAttachment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MessageTemplateAttachment> {
        /**
         * <p>
         * The identifier of the attachment file.
         * </p>
         * 
         * @param attachmentId
         *        The identifier of the attachment file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachmentId(String attachmentId);

        /**
         * <p>
         * The presentation information for the attachment file.
         * </p>
         * 
         * @param contentDisposition
         *        The presentation information for the attachment file.
         * @see ContentDisposition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContentDisposition
         */
        Builder contentDisposition(String contentDisposition);

        /**
         * <p>
         * The presentation information for the attachment file.
         * </p>
         * 
         * @param contentDisposition
         *        The presentation information for the attachment file.
         * @see ContentDisposition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ContentDisposition
         */
        Builder contentDisposition(ContentDisposition contentDisposition);

        /**
         * <p>
         * The name of the attachment file being uploaded. The name should include the file extension.
         * </p>
         * 
         * @param name
         *        The name of the attachment file being uploaded. The name should include the file extension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The timestamp when the attachment file was uploaded.
         * </p>
         * 
         * @param uploadedTime
         *        The timestamp when the attachment file was uploaded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uploadedTime(Instant uploadedTime);

        /**
         * <p>
         * A pre-signed Amazon S3 URL that can be used to download the attachment file.
         * </p>
         * 
         * @param url
         *        A pre-signed Amazon S3 URL that can be used to download the attachment file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);

        /**
         * <p>
         * The expiration time of the pre-signed Amazon S3 URL.
         * </p>
         * 
         * @param urlExpiry
         *        The expiration time of the pre-signed Amazon S3 URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder urlExpiry(Instant urlExpiry);
    }

    static final class BuilderImpl implements Builder {
        private String attachmentId;

        private String contentDisposition;

        private String name;

        private Instant uploadedTime;

        private String url;

        private Instant urlExpiry;

        private BuilderImpl() {
        }

        private BuilderImpl(MessageTemplateAttachment model) {
            attachmentId(model.attachmentId);
            contentDisposition(model.contentDisposition);
            name(model.name);
            uploadedTime(model.uploadedTime);
            url(model.url);
            urlExpiry(model.urlExpiry);
        }

        public final String getAttachmentId() {
            return attachmentId;
        }

        public final void setAttachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
        }

        @Override
        public final Builder attachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
            return this;
        }

        public final String getContentDisposition() {
            return contentDisposition;
        }

        public final void setContentDisposition(String contentDisposition) {
            this.contentDisposition = contentDisposition;
        }

        @Override
        public final Builder contentDisposition(String contentDisposition) {
            this.contentDisposition = contentDisposition;
            return this;
        }

        @Override
        public final Builder contentDisposition(ContentDisposition contentDisposition) {
            this.contentDisposition(contentDisposition == null ? null : contentDisposition.toString());
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Instant getUploadedTime() {
            return uploadedTime;
        }

        public final void setUploadedTime(Instant uploadedTime) {
            this.uploadedTime = uploadedTime;
        }

        @Override
        public final Builder uploadedTime(Instant uploadedTime) {
            this.uploadedTime = uploadedTime;
            return this;
        }

        public final String getUrl() {
            return url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final Instant getUrlExpiry() {
            return urlExpiry;
        }

        public final void setUrlExpiry(Instant urlExpiry) {
            this.urlExpiry = urlExpiry;
        }

        @Override
        public final Builder urlExpiry(Instant urlExpiry) {
            this.urlExpiry = urlExpiry;
            return this;
        }

        @Override
        public MessageTemplateAttachment build() {
            return new MessageTemplateAttachment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
