/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The message input.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MessageInput implements SdkPojo, Serializable, ToCopyableBuilder<MessageInput.Builder, MessageInput> {
    private static final SdkField<MessageData> VALUE_FIELD = SdkField.<MessageData> builder(MarshallingType.SDK_POJO)
            .memberName("value").getter(getter(MessageInput::value)).setter(setter(Builder::value))
            .constructor(MessageData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final MessageData value;

    private MessageInput(BuilderImpl builder) {
        this.value = builder.value;
    }

    /**
     * <p>
     * The message input value.
     * </p>
     * 
     * @return The message input value.
     */
    public final MessageData value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MessageInput)) {
            return false;
        }
        MessageInput other = (MessageInput) obj;
        return Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MessageInput").add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("value", VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MessageInput, T> g) {
        return obj -> g.apply((MessageInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MessageInput> {
        /**
         * <p>
         * The message input value.
         * </p>
         * 
         * @param value
         *        The message input value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(MessageData value);

        /**
         * <p>
         * The message input value.
         * </p>
         * This is a convenience method that creates an instance of the {@link MessageData.Builder} avoiding the need to
         * create one manually via {@link MessageData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MessageData.Builder#build()} is called immediately and its result
         * is passed to {@link #value(MessageData)}.
         * 
         * @param value
         *        a consumer that will call methods on {@link MessageData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #value(MessageData)
         */
        default Builder value(Consumer<MessageData.Builder> value) {
            return value(MessageData.builder().applyMutation(value).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private MessageData value;

        private BuilderImpl() {
        }

        private BuilderImpl(MessageInput model) {
            value(model.value);
        }

        public final MessageData.Builder getValue() {
            return value != null ? value.toBuilder() : null;
        }

        public final void setValue(MessageData.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        @Override
        public final Builder value(MessageData value) {
            this.value = value;
            return this;
        }

        @Override
        public MessageInput build() {
            return new MessageInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
