/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAiGuardrailVersionsResponse extends QConnectResponse implements
        ToCopyableBuilder<ListAiGuardrailVersionsResponse.Builder, ListAiGuardrailVersionsResponse> {
    private static final SdkField<List<AIGuardrailVersionSummary>> AI_GUARDRAIL_VERSION_SUMMARIES_FIELD = SdkField
            .<List<AIGuardrailVersionSummary>> builder(MarshallingType.LIST)
            .memberName("aiGuardrailVersionSummaries")
            .getter(getter(ListAiGuardrailVersionsResponse::aiGuardrailVersionSummaries))
            .setter(setter(Builder::aiGuardrailVersionSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aiGuardrailVersionSummaries")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AIGuardrailVersionSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(AIGuardrailVersionSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListAiGuardrailVersionsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AI_GUARDRAIL_VERSION_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<AIGuardrailVersionSummary> aiGuardrailVersionSummaries;

    private final String nextToken;

    private ListAiGuardrailVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.aiGuardrailVersionSummaries = builder.aiGuardrailVersionSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the AiGuardrailVersionSummaries property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAiGuardrailVersionSummaries() {
        return aiGuardrailVersionSummaries != null && !(aiGuardrailVersionSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The summaries of the AI Guardrail versions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAiGuardrailVersionSummaries} method.
     * </p>
     * 
     * @return The summaries of the AI Guardrail versions.
     */
    public final List<AIGuardrailVersionSummary> aiGuardrailVersionSummaries() {
        return aiGuardrailVersionSummaries;
    }

    /**
     * <p>
     * The token for the next set of results. Use the value returned in the previous response in the next request to
     * retrieve the next set of results.
     * </p>
     * 
     * @return The token for the next set of results. Use the value returned in the previous response in the next
     *         request to retrieve the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAiGuardrailVersionSummaries() ? aiGuardrailVersionSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAiGuardrailVersionsResponse)) {
            return false;
        }
        ListAiGuardrailVersionsResponse other = (ListAiGuardrailVersionsResponse) obj;
        return hasAiGuardrailVersionSummaries() == other.hasAiGuardrailVersionSummaries()
                && Objects.equals(aiGuardrailVersionSummaries(), other.aiGuardrailVersionSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAiGuardrailVersionsResponse")
                .add("AiGuardrailVersionSummaries", hasAiGuardrailVersionSummaries() ? aiGuardrailVersionSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "aiGuardrailVersionSummaries":
            return Optional.ofNullable(clazz.cast(aiGuardrailVersionSummaries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("aiGuardrailVersionSummaries", AI_GUARDRAIL_VERSION_SUMMARIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAiGuardrailVersionsResponse, T> g) {
        return obj -> g.apply((ListAiGuardrailVersionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListAiGuardrailVersionsResponse> {
        /**
         * <p>
         * The summaries of the AI Guardrail versions.
         * </p>
         * 
         * @param aiGuardrailVersionSummaries
         *        The summaries of the AI Guardrail versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aiGuardrailVersionSummaries(Collection<AIGuardrailVersionSummary> aiGuardrailVersionSummaries);

        /**
         * <p>
         * The summaries of the AI Guardrail versions.
         * </p>
         * 
         * @param aiGuardrailVersionSummaries
         *        The summaries of the AI Guardrail versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aiGuardrailVersionSummaries(AIGuardrailVersionSummary... aiGuardrailVersionSummaries);

        /**
         * <p>
         * The summaries of the AI Guardrail versions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.qconnect.model.AIGuardrailVersionSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.qconnect.model.AIGuardrailVersionSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.qconnect.model.AIGuardrailVersionSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #aiGuardrailVersionSummaries(List<AIGuardrailVersionSummary>)}.
         * 
         * @param aiGuardrailVersionSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.qconnect.model.AIGuardrailVersionSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aiGuardrailVersionSummaries(java.util.Collection<AIGuardrailVersionSummary>)
         */
        Builder aiGuardrailVersionSummaries(Consumer<AIGuardrailVersionSummary.Builder>... aiGuardrailVersionSummaries);

        /**
         * <p>
         * The token for the next set of results. Use the value returned in the previous response in the next request to
         * retrieve the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results. Use the value returned in the previous response in the next
         *        request to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends QConnectResponse.BuilderImpl implements Builder {
        private List<AIGuardrailVersionSummary> aiGuardrailVersionSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAiGuardrailVersionsResponse model) {
            super(model);
            aiGuardrailVersionSummaries(model.aiGuardrailVersionSummaries);
            nextToken(model.nextToken);
        }

        public final List<AIGuardrailVersionSummary.Builder> getAiGuardrailVersionSummaries() {
            List<AIGuardrailVersionSummary.Builder> result = AIGuardrailVersionSummariesListCopier
                    .copyToBuilder(this.aiGuardrailVersionSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAiGuardrailVersionSummaries(
                Collection<AIGuardrailVersionSummary.BuilderImpl> aiGuardrailVersionSummaries) {
            this.aiGuardrailVersionSummaries = AIGuardrailVersionSummariesListCopier.copyFromBuilder(aiGuardrailVersionSummaries);
        }

        @Override
        public final Builder aiGuardrailVersionSummaries(Collection<AIGuardrailVersionSummary> aiGuardrailVersionSummaries) {
            this.aiGuardrailVersionSummaries = AIGuardrailVersionSummariesListCopier.copy(aiGuardrailVersionSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aiGuardrailVersionSummaries(AIGuardrailVersionSummary... aiGuardrailVersionSummaries) {
            aiGuardrailVersionSummaries(Arrays.asList(aiGuardrailVersionSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aiGuardrailVersionSummaries(
                Consumer<AIGuardrailVersionSummary.Builder>... aiGuardrailVersionSummaries) {
            aiGuardrailVersionSummaries(Stream.of(aiGuardrailVersionSummaries)
                    .map(c -> AIGuardrailVersionSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAiGuardrailVersionsResponse build() {
            return new ListAiGuardrailVersionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
