/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetContentAssociationResponse extends QConnectResponse implements
        ToCopyableBuilder<GetContentAssociationResponse.Builder, GetContentAssociationResponse> {
    private static final SdkField<ContentAssociationData> CONTENT_ASSOCIATION_FIELD = SdkField
            .<ContentAssociationData> builder(MarshallingType.SDK_POJO).memberName("contentAssociation")
            .getter(getter(GetContentAssociationResponse::contentAssociation)).setter(setter(Builder::contentAssociation))
            .constructor(ContentAssociationData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentAssociation").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_ASSOCIATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ContentAssociationData contentAssociation;

    private GetContentAssociationResponse(BuilderImpl builder) {
        super(builder);
        this.contentAssociation = builder.contentAssociation;
    }

    /**
     * <p>
     * The association between Amazon Q in Connect content and another resource.
     * </p>
     * 
     * @return The association between Amazon Q in Connect content and another resource.
     */
    public final ContentAssociationData contentAssociation() {
        return contentAssociation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(contentAssociation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetContentAssociationResponse)) {
            return false;
        }
        GetContentAssociationResponse other = (GetContentAssociationResponse) obj;
        return Objects.equals(contentAssociation(), other.contentAssociation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetContentAssociationResponse").add("ContentAssociation", contentAssociation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "contentAssociation":
            return Optional.ofNullable(clazz.cast(contentAssociation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("contentAssociation", CONTENT_ASSOCIATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetContentAssociationResponse, T> g) {
        return obj -> g.apply((GetContentAssociationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetContentAssociationResponse> {
        /**
         * <p>
         * The association between Amazon Q in Connect content and another resource.
         * </p>
         * 
         * @param contentAssociation
         *        The association between Amazon Q in Connect content and another resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentAssociation(ContentAssociationData contentAssociation);

        /**
         * <p>
         * The association between Amazon Q in Connect content and another resource.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContentAssociationData.Builder} avoiding
         * the need to create one manually via {@link ContentAssociationData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContentAssociationData.Builder#build()} is called immediately and
         * its result is passed to {@link #contentAssociation(ContentAssociationData)}.
         * 
         * @param contentAssociation
         *        a consumer that will call methods on {@link ContentAssociationData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contentAssociation(ContentAssociationData)
         */
        default Builder contentAssociation(Consumer<ContentAssociationData.Builder> contentAssociation) {
            return contentAssociation(ContentAssociationData.builder().applyMutation(contentAssociation).build());
        }
    }

    static final class BuilderImpl extends QConnectResponse.BuilderImpl implements Builder {
        private ContentAssociationData contentAssociation;

        private BuilderImpl() {
        }

        private BuilderImpl(GetContentAssociationResponse model) {
            super(model);
            contentAssociation(model.contentAssociation);
        }

        public final ContentAssociationData.Builder getContentAssociation() {
            return contentAssociation != null ? contentAssociation.toBuilder() : null;
        }

        public final void setContentAssociation(ContentAssociationData.BuilderImpl contentAssociation) {
            this.contentAssociation = contentAssociation != null ? contentAssociation.build() : null;
        }

        @Override
        public final Builder contentAssociation(ContentAssociationData contentAssociation) {
            this.contentAssociation = contentAssociation;
            return this;
        }

        @Override
        public GetContentAssociationResponse build() {
            return new GetContentAssociationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
