/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The feedback information for a generative target type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GenerativeContentFeedbackData implements SdkPojo, Serializable,
        ToCopyableBuilder<GenerativeContentFeedbackData.Builder, GenerativeContentFeedbackData> {
    private static final SdkField<String> RELEVANCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("relevance").getter(getter(GenerativeContentFeedbackData::relevanceAsString))
            .setter(setter(Builder::relevance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relevance").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RELEVANCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String relevance;

    private GenerativeContentFeedbackData(BuilderImpl builder) {
        this.relevance = builder.relevance;
    }

    /**
     * <p>
     * The relevance of the feedback.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #relevance} will
     * return {@link Relevance#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #relevanceAsString}.
     * </p>
     * 
     * @return The relevance of the feedback.
     * @see Relevance
     */
    public final Relevance relevance() {
        return Relevance.fromValue(relevance);
    }

    /**
     * <p>
     * The relevance of the feedback.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #relevance} will
     * return {@link Relevance#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #relevanceAsString}.
     * </p>
     * 
     * @return The relevance of the feedback.
     * @see Relevance
     */
    public final String relevanceAsString() {
        return relevance;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(relevanceAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenerativeContentFeedbackData)) {
            return false;
        }
        GenerativeContentFeedbackData other = (GenerativeContentFeedbackData) obj;
        return Objects.equals(relevanceAsString(), other.relevanceAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GenerativeContentFeedbackData").add("Relevance", relevanceAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "relevance":
            return Optional.ofNullable(clazz.cast(relevanceAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("relevance", RELEVANCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GenerativeContentFeedbackData, T> g) {
        return obj -> g.apply((GenerativeContentFeedbackData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GenerativeContentFeedbackData> {
        /**
         * <p>
         * The relevance of the feedback.
         * </p>
         * 
         * @param relevance
         *        The relevance of the feedback.
         * @see Relevance
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Relevance
         */
        Builder relevance(String relevance);

        /**
         * <p>
         * The relevance of the feedback.
         * </p>
         * 
         * @param relevance
         *        The relevance of the feedback.
         * @see Relevance
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Relevance
         */
        Builder relevance(Relevance relevance);
    }

    static final class BuilderImpl implements Builder {
        private String relevance;

        private BuilderImpl() {
        }

        private BuilderImpl(GenerativeContentFeedbackData model) {
            relevance(model.relevance);
        }

        public final String getRelevance() {
            return relevance;
        }

        public final void setRelevance(String relevance) {
            this.relevance = relevance;
        }

        @Override
        public final Builder relevance(String relevance) {
            this.relevance = relevance;
            return this;
        }

        @Override
        public final Builder relevance(Relevance relevance) {
            this.relevance(relevance == null ? null : relevance.toString());
            return this;
        }

        @Override
        public GenerativeContentFeedbackData build() {
            return new GenerativeContentFeedbackData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
