/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The customer profile attributes that are used with the message template.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomerProfileAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomerProfileAttributes.Builder, CustomerProfileAttributes> {
    private static final SdkField<String> ACCOUNT_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountNumber").getter(getter(CustomerProfileAttributes::accountNumber))
            .setter(setter(Builder::accountNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountNumber").build()).build();

    private static final SdkField<String> ADDITIONAL_INFORMATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("additionalInformation").getter(getter(CustomerProfileAttributes::additionalInformation))
            .setter(setter(Builder::additionalInformation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalInformation").build())
            .build();

    private static final SdkField<String> ADDRESS1_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("address1").getter(getter(CustomerProfileAttributes::address1)).setter(setter(Builder::address1))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("address1").build()).build();

    private static final SdkField<String> ADDRESS2_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("address2").getter(getter(CustomerProfileAttributes::address2)).setter(setter(Builder::address2))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("address2").build()).build();

    private static final SdkField<String> ADDRESS3_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("address3").getter(getter(CustomerProfileAttributes::address3)).setter(setter(Builder::address3))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("address3").build()).build();

    private static final SdkField<String> ADDRESS4_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("address4").getter(getter(CustomerProfileAttributes::address4)).setter(setter(Builder::address4))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("address4").build()).build();

    private static final SdkField<String> BILLING_ADDRESS1_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("billingAddress1").getter(getter(CustomerProfileAttributes::billingAddress1))
            .setter(setter(Builder::billingAddress1))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("billingAddress1").build()).build();

    private static final SdkField<String> BILLING_ADDRESS2_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("billingAddress2").getter(getter(CustomerProfileAttributes::billingAddress2))
            .setter(setter(Builder::billingAddress2))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("billingAddress2").build()).build();

    private static final SdkField<String> BILLING_ADDRESS3_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("billingAddress3").getter(getter(CustomerProfileAttributes::billingAddress3))
            .setter(setter(Builder::billingAddress3))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("billingAddress3").build()).build();

    private static final SdkField<String> BILLING_ADDRESS4_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("billingAddress4").getter(getter(CustomerProfileAttributes::billingAddress4))
            .setter(setter(Builder::billingAddress4))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("billingAddress4").build()).build();

    private static final SdkField<String> BILLING_CITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("billingCity").getter(getter(CustomerProfileAttributes::billingCity))
            .setter(setter(Builder::billingCity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("billingCity").build()).build();

    private static final SdkField<String> BILLING_COUNTRY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("billingCountry").getter(getter(CustomerProfileAttributes::billingCountry))
            .setter(setter(Builder::billingCountry))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("billingCountry").build()).build();

    private static final SdkField<String> BILLING_COUNTY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("billingCounty").getter(getter(CustomerProfileAttributes::billingCounty))
            .setter(setter(Builder::billingCounty))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("billingCounty").build()).build();

    private static final SdkField<String> BILLING_POSTAL_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("billingPostalCode").getter(getter(CustomerProfileAttributes::billingPostalCode))
            .setter(setter(Builder::billingPostalCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("billingPostalCode").build()).build();

    private static final SdkField<String> BILLING_PROVINCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("billingProvince").getter(getter(CustomerProfileAttributes::billingProvince))
            .setter(setter(Builder::billingProvince))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("billingProvince").build()).build();

    private static final SdkField<String> BILLING_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("billingState").getter(getter(CustomerProfileAttributes::billingState))
            .setter(setter(Builder::billingState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("billingState").build()).build();

    private static final SdkField<String> BIRTH_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("birthDate").getter(getter(CustomerProfileAttributes::birthDate)).setter(setter(Builder::birthDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("birthDate").build()).build();

    private static final SdkField<String> BUSINESS_EMAIL_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("businessEmailAddress").getter(getter(CustomerProfileAttributes::businessEmailAddress))
            .setter(setter(Builder::businessEmailAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("businessEmailAddress").build())
            .build();

    private static final SdkField<String> BUSINESS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("businessName").getter(getter(CustomerProfileAttributes::businessName))
            .setter(setter(Builder::businessName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("businessName").build()).build();

    private static final SdkField<String> BUSINESS_PHONE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("businessPhoneNumber").getter(getter(CustomerProfileAttributes::businessPhoneNumber))
            .setter(setter(Builder::businessPhoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("businessPhoneNumber").build())
            .build();

    private static final SdkField<String> CITY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("city")
            .getter(getter(CustomerProfileAttributes::city)).setter(setter(Builder::city))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("city").build()).build();

    private static final SdkField<String> COUNTRY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("country")
            .getter(getter(CustomerProfileAttributes::country)).setter(setter(Builder::country))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("country").build()).build();

    private static final SdkField<String> COUNTY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("county")
            .getter(getter(CustomerProfileAttributes::county)).setter(setter(Builder::county))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("county").build()).build();

    private static final SdkField<Map<String, String>> CUSTOM_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("custom")
            .getter(getter(CustomerProfileAttributes::custom))
            .setter(setter(Builder::custom))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("custom").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> EMAIL_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("emailAddress").getter(getter(CustomerProfileAttributes::emailAddress))
            .setter(setter(Builder::emailAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("emailAddress").build()).build();

    private static final SdkField<String> FIRST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("firstName").getter(getter(CustomerProfileAttributes::firstName)).setter(setter(Builder::firstName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firstName").build()).build();

    private static final SdkField<String> GENDER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("gender")
            .getter(getter(CustomerProfileAttributes::gender)).setter(setter(Builder::gender))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gender").build()).build();

    private static final SdkField<String> HOME_PHONE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("homePhoneNumber").getter(getter(CustomerProfileAttributes::homePhoneNumber))
            .setter(setter(Builder::homePhoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("homePhoneNumber").build()).build();

    private static final SdkField<String> LAST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lastName").getter(getter(CustomerProfileAttributes::lastName)).setter(setter(Builder::lastName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastName").build()).build();

    private static final SdkField<String> MAILING_ADDRESS1_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mailingAddress1").getter(getter(CustomerProfileAttributes::mailingAddress1))
            .setter(setter(Builder::mailingAddress1))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mailingAddress1").build()).build();

    private static final SdkField<String> MAILING_ADDRESS2_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mailingAddress2").getter(getter(CustomerProfileAttributes::mailingAddress2))
            .setter(setter(Builder::mailingAddress2))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mailingAddress2").build()).build();

    private static final SdkField<String> MAILING_ADDRESS3_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mailingAddress3").getter(getter(CustomerProfileAttributes::mailingAddress3))
            .setter(setter(Builder::mailingAddress3))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mailingAddress3").build()).build();

    private static final SdkField<String> MAILING_ADDRESS4_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mailingAddress4").getter(getter(CustomerProfileAttributes::mailingAddress4))
            .setter(setter(Builder::mailingAddress4))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mailingAddress4").build()).build();

    private static final SdkField<String> MAILING_CITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mailingCity").getter(getter(CustomerProfileAttributes::mailingCity))
            .setter(setter(Builder::mailingCity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mailingCity").build()).build();

    private static final SdkField<String> MAILING_COUNTRY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mailingCountry").getter(getter(CustomerProfileAttributes::mailingCountry))
            .setter(setter(Builder::mailingCountry))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mailingCountry").build()).build();

    private static final SdkField<String> MAILING_COUNTY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mailingCounty").getter(getter(CustomerProfileAttributes::mailingCounty))
            .setter(setter(Builder::mailingCounty))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mailingCounty").build()).build();

    private static final SdkField<String> MAILING_POSTAL_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mailingPostalCode").getter(getter(CustomerProfileAttributes::mailingPostalCode))
            .setter(setter(Builder::mailingPostalCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mailingPostalCode").build()).build();

    private static final SdkField<String> MAILING_PROVINCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mailingProvince").getter(getter(CustomerProfileAttributes::mailingProvince))
            .setter(setter(Builder::mailingProvince))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mailingProvince").build()).build();

    private static final SdkField<String> MAILING_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mailingState").getter(getter(CustomerProfileAttributes::mailingState))
            .setter(setter(Builder::mailingState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mailingState").build()).build();

    private static final SdkField<String> MIDDLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("middleName").getter(getter(CustomerProfileAttributes::middleName)).setter(setter(Builder::middleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("middleName").build()).build();

    private static final SdkField<String> MOBILE_PHONE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mobilePhoneNumber").getter(getter(CustomerProfileAttributes::mobilePhoneNumber))
            .setter(setter(Builder::mobilePhoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mobilePhoneNumber").build()).build();

    private static final SdkField<String> PARTY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("partyType").getter(getter(CustomerProfileAttributes::partyType)).setter(setter(Builder::partyType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("partyType").build()).build();

    private static final SdkField<String> PHONE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("phoneNumber").getter(getter(CustomerProfileAttributes::phoneNumber))
            .setter(setter(Builder::phoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("phoneNumber").build()).build();

    private static final SdkField<String> POSTAL_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("postalCode").getter(getter(CustomerProfileAttributes::postalCode)).setter(setter(Builder::postalCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("postalCode").build()).build();

    private static final SdkField<String> PROFILE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("profileARN").getter(getter(CustomerProfileAttributes::profileARN)).setter(setter(Builder::profileARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profileARN").build()).build();

    private static final SdkField<String> PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("profileId").getter(getter(CustomerProfileAttributes::profileId)).setter(setter(Builder::profileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profileId").build()).build();

    private static final SdkField<String> PROVINCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("province").getter(getter(CustomerProfileAttributes::province)).setter(setter(Builder::province))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("province").build()).build();

    private static final SdkField<String> SHIPPING_ADDRESS1_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("shippingAddress1").getter(getter(CustomerProfileAttributes::shippingAddress1))
            .setter(setter(Builder::shippingAddress1))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shippingAddress1").build()).build();

    private static final SdkField<String> SHIPPING_ADDRESS2_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("shippingAddress2").getter(getter(CustomerProfileAttributes::shippingAddress2))
            .setter(setter(Builder::shippingAddress2))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shippingAddress2").build()).build();

    private static final SdkField<String> SHIPPING_ADDRESS3_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("shippingAddress3").getter(getter(CustomerProfileAttributes::shippingAddress3))
            .setter(setter(Builder::shippingAddress3))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shippingAddress3").build()).build();

    private static final SdkField<String> SHIPPING_ADDRESS4_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("shippingAddress4").getter(getter(CustomerProfileAttributes::shippingAddress4))
            .setter(setter(Builder::shippingAddress4))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shippingAddress4").build()).build();

    private static final SdkField<String> SHIPPING_CITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("shippingCity").getter(getter(CustomerProfileAttributes::shippingCity))
            .setter(setter(Builder::shippingCity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shippingCity").build()).build();

    private static final SdkField<String> SHIPPING_COUNTRY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("shippingCountry").getter(getter(CustomerProfileAttributes::shippingCountry))
            .setter(setter(Builder::shippingCountry))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shippingCountry").build()).build();

    private static final SdkField<String> SHIPPING_COUNTY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("shippingCounty").getter(getter(CustomerProfileAttributes::shippingCounty))
            .setter(setter(Builder::shippingCounty))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shippingCounty").build()).build();

    private static final SdkField<String> SHIPPING_POSTAL_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("shippingPostalCode").getter(getter(CustomerProfileAttributes::shippingPostalCode))
            .setter(setter(Builder::shippingPostalCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shippingPostalCode").build())
            .build();

    private static final SdkField<String> SHIPPING_PROVINCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("shippingProvince").getter(getter(CustomerProfileAttributes::shippingProvince))
            .setter(setter(Builder::shippingProvince))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shippingProvince").build()).build();

    private static final SdkField<String> SHIPPING_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("shippingState").getter(getter(CustomerProfileAttributes::shippingState))
            .setter(setter(Builder::shippingState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shippingState").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("state")
            .getter(getter(CustomerProfileAttributes::state)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_NUMBER_FIELD,
            ADDITIONAL_INFORMATION_FIELD, ADDRESS1_FIELD, ADDRESS2_FIELD, ADDRESS3_FIELD, ADDRESS4_FIELD, BILLING_ADDRESS1_FIELD,
            BILLING_ADDRESS2_FIELD, BILLING_ADDRESS3_FIELD, BILLING_ADDRESS4_FIELD, BILLING_CITY_FIELD, BILLING_COUNTRY_FIELD,
            BILLING_COUNTY_FIELD, BILLING_POSTAL_CODE_FIELD, BILLING_PROVINCE_FIELD, BILLING_STATE_FIELD, BIRTH_DATE_FIELD,
            BUSINESS_EMAIL_ADDRESS_FIELD, BUSINESS_NAME_FIELD, BUSINESS_PHONE_NUMBER_FIELD, CITY_FIELD, COUNTRY_FIELD,
            COUNTY_FIELD, CUSTOM_FIELD, EMAIL_ADDRESS_FIELD, FIRST_NAME_FIELD, GENDER_FIELD, HOME_PHONE_NUMBER_FIELD,
            LAST_NAME_FIELD, MAILING_ADDRESS1_FIELD, MAILING_ADDRESS2_FIELD, MAILING_ADDRESS3_FIELD, MAILING_ADDRESS4_FIELD,
            MAILING_CITY_FIELD, MAILING_COUNTRY_FIELD, MAILING_COUNTY_FIELD, MAILING_POSTAL_CODE_FIELD, MAILING_PROVINCE_FIELD,
            MAILING_STATE_FIELD, MIDDLE_NAME_FIELD, MOBILE_PHONE_NUMBER_FIELD, PARTY_TYPE_FIELD, PHONE_NUMBER_FIELD,
            POSTAL_CODE_FIELD, PROFILE_ARN_FIELD, PROFILE_ID_FIELD, PROVINCE_FIELD, SHIPPING_ADDRESS1_FIELD,
            SHIPPING_ADDRESS2_FIELD, SHIPPING_ADDRESS3_FIELD, SHIPPING_ADDRESS4_FIELD, SHIPPING_CITY_FIELD,
            SHIPPING_COUNTRY_FIELD, SHIPPING_COUNTY_FIELD, SHIPPING_POSTAL_CODE_FIELD, SHIPPING_PROVINCE_FIELD,
            SHIPPING_STATE_FIELD, STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String accountNumber;

    private final String additionalInformation;

    private final String address1;

    private final String address2;

    private final String address3;

    private final String address4;

    private final String billingAddress1;

    private final String billingAddress2;

    private final String billingAddress3;

    private final String billingAddress4;

    private final String billingCity;

    private final String billingCountry;

    private final String billingCounty;

    private final String billingPostalCode;

    private final String billingProvince;

    private final String billingState;

    private final String birthDate;

    private final String businessEmailAddress;

    private final String businessName;

    private final String businessPhoneNumber;

    private final String city;

    private final String country;

    private final String county;

    private final Map<String, String> custom;

    private final String emailAddress;

    private final String firstName;

    private final String gender;

    private final String homePhoneNumber;

    private final String lastName;

    private final String mailingAddress1;

    private final String mailingAddress2;

    private final String mailingAddress3;

    private final String mailingAddress4;

    private final String mailingCity;

    private final String mailingCountry;

    private final String mailingCounty;

    private final String mailingPostalCode;

    private final String mailingProvince;

    private final String mailingState;

    private final String middleName;

    private final String mobilePhoneNumber;

    private final String partyType;

    private final String phoneNumber;

    private final String postalCode;

    private final String profileARN;

    private final String profileId;

    private final String province;

    private final String shippingAddress1;

    private final String shippingAddress2;

    private final String shippingAddress3;

    private final String shippingAddress4;

    private final String shippingCity;

    private final String shippingCountry;

    private final String shippingCounty;

    private final String shippingPostalCode;

    private final String shippingProvince;

    private final String shippingState;

    private final String state;

    private CustomerProfileAttributes(BuilderImpl builder) {
        this.accountNumber = builder.accountNumber;
        this.additionalInformation = builder.additionalInformation;
        this.address1 = builder.address1;
        this.address2 = builder.address2;
        this.address3 = builder.address3;
        this.address4 = builder.address4;
        this.billingAddress1 = builder.billingAddress1;
        this.billingAddress2 = builder.billingAddress2;
        this.billingAddress3 = builder.billingAddress3;
        this.billingAddress4 = builder.billingAddress4;
        this.billingCity = builder.billingCity;
        this.billingCountry = builder.billingCountry;
        this.billingCounty = builder.billingCounty;
        this.billingPostalCode = builder.billingPostalCode;
        this.billingProvince = builder.billingProvince;
        this.billingState = builder.billingState;
        this.birthDate = builder.birthDate;
        this.businessEmailAddress = builder.businessEmailAddress;
        this.businessName = builder.businessName;
        this.businessPhoneNumber = builder.businessPhoneNumber;
        this.city = builder.city;
        this.country = builder.country;
        this.county = builder.county;
        this.custom = builder.custom;
        this.emailAddress = builder.emailAddress;
        this.firstName = builder.firstName;
        this.gender = builder.gender;
        this.homePhoneNumber = builder.homePhoneNumber;
        this.lastName = builder.lastName;
        this.mailingAddress1 = builder.mailingAddress1;
        this.mailingAddress2 = builder.mailingAddress2;
        this.mailingAddress3 = builder.mailingAddress3;
        this.mailingAddress4 = builder.mailingAddress4;
        this.mailingCity = builder.mailingCity;
        this.mailingCountry = builder.mailingCountry;
        this.mailingCounty = builder.mailingCounty;
        this.mailingPostalCode = builder.mailingPostalCode;
        this.mailingProvince = builder.mailingProvince;
        this.mailingState = builder.mailingState;
        this.middleName = builder.middleName;
        this.mobilePhoneNumber = builder.mobilePhoneNumber;
        this.partyType = builder.partyType;
        this.phoneNumber = builder.phoneNumber;
        this.postalCode = builder.postalCode;
        this.profileARN = builder.profileARN;
        this.profileId = builder.profileId;
        this.province = builder.province;
        this.shippingAddress1 = builder.shippingAddress1;
        this.shippingAddress2 = builder.shippingAddress2;
        this.shippingAddress3 = builder.shippingAddress3;
        this.shippingAddress4 = builder.shippingAddress4;
        this.shippingCity = builder.shippingCity;
        this.shippingCountry = builder.shippingCountry;
        this.shippingCounty = builder.shippingCounty;
        this.shippingPostalCode = builder.shippingPostalCode;
        this.shippingProvince = builder.shippingProvince;
        this.shippingState = builder.shippingState;
        this.state = builder.state;
    }

    /**
     * <p>
     * A unique account number that you have given to the customer.
     * </p>
     * 
     * @return A unique account number that you have given to the customer.
     */
    public final String accountNumber() {
        return accountNumber;
    }

    /**
     * <p>
     * Any additional information relevant to the customer's profile.
     * </p>
     * 
     * @return Any additional information relevant to the customer's profile.
     */
    public final String additionalInformation() {
        return additionalInformation;
    }

    /**
     * <p>
     * The first line of a customer address.
     * </p>
     * 
     * @return The first line of a customer address.
     */
    public final String address1() {
        return address1;
    }

    /**
     * <p>
     * The second line of a customer address.
     * </p>
     * 
     * @return The second line of a customer address.
     */
    public final String address2() {
        return address2;
    }

    /**
     * <p>
     * The third line of a customer address.
     * </p>
     * 
     * @return The third line of a customer address.
     */
    public final String address3() {
        return address3;
    }

    /**
     * <p>
     * The fourth line of a customer address.
     * </p>
     * 
     * @return The fourth line of a customer address.
     */
    public final String address4() {
        return address4;
    }

    /**
     * <p>
     * The first line of a customer’s billing address.
     * </p>
     * 
     * @return The first line of a customer’s billing address.
     */
    public final String billingAddress1() {
        return billingAddress1;
    }

    /**
     * <p>
     * The second line of a customer’s billing address.
     * </p>
     * 
     * @return The second line of a customer’s billing address.
     */
    public final String billingAddress2() {
        return billingAddress2;
    }

    /**
     * <p>
     * The third line of a customer’s billing address.
     * </p>
     * 
     * @return The third line of a customer’s billing address.
     */
    public final String billingAddress3() {
        return billingAddress3;
    }

    /**
     * <p>
     * The fourth line of a customer’s billing address.
     * </p>
     * 
     * @return The fourth line of a customer’s billing address.
     */
    public final String billingAddress4() {
        return billingAddress4;
    }

    /**
     * <p>
     * The city of a customer’s billing address.
     * </p>
     * 
     * @return The city of a customer’s billing address.
     */
    public final String billingCity() {
        return billingCity;
    }

    /**
     * <p>
     * The country of a customer’s billing address.
     * </p>
     * 
     * @return The country of a customer’s billing address.
     */
    public final String billingCountry() {
        return billingCountry;
    }

    /**
     * <p>
     * The county of a customer’s billing address.
     * </p>
     * 
     * @return The county of a customer’s billing address.
     */
    public final String billingCounty() {
        return billingCounty;
    }

    /**
     * <p>
     * The postal code of a customer’s billing address.
     * </p>
     * 
     * @return The postal code of a customer’s billing address.
     */
    public final String billingPostalCode() {
        return billingPostalCode;
    }

    /**
     * <p>
     * The province of a customer’s billing address.
     * </p>
     * 
     * @return The province of a customer’s billing address.
     */
    public final String billingProvince() {
        return billingProvince;
    }

    /**
     * <p>
     * The state of a customer’s billing address.
     * </p>
     * 
     * @return The state of a customer’s billing address.
     */
    public final String billingState() {
        return billingState;
    }

    /**
     * <p>
     * The customer's birth date.
     * </p>
     * 
     * @return The customer's birth date.
     */
    public final String birthDate() {
        return birthDate;
    }

    /**
     * <p>
     * The customer's business email address.
     * </p>
     * 
     * @return The customer's business email address.
     */
    public final String businessEmailAddress() {
        return businessEmailAddress;
    }

    /**
     * <p>
     * The name of the customer's business.
     * </p>
     * 
     * @return The name of the customer's business.
     */
    public final String businessName() {
        return businessName;
    }

    /**
     * <p>
     * The customer's business phone number.
     * </p>
     * 
     * @return The customer's business phone number.
     */
    public final String businessPhoneNumber() {
        return businessPhoneNumber;
    }

    /**
     * <p>
     * The city in which a customer lives.
     * </p>
     * 
     * @return The city in which a customer lives.
     */
    public final String city() {
        return city;
    }

    /**
     * <p>
     * The country in which a customer lives.
     * </p>
     * 
     * @return The country in which a customer lives.
     */
    public final String country() {
        return country;
    }

    /**
     * <p>
     * The county in which a customer lives.
     * </p>
     * 
     * @return The county in which a customer lives.
     */
    public final String county() {
        return county;
    }

    /**
     * For responses, this returns true if the service returned a value for the Custom property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasCustom() {
        return custom != null && !(custom instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The custom attributes in customer profile attributes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCustom} method.
     * </p>
     * 
     * @return The custom attributes in customer profile attributes.
     */
    public final Map<String, String> custom() {
        return custom;
    }

    /**
     * <p>
     * The customer's email address, which has not been specified as a personal or business address.
     * </p>
     * 
     * @return The customer's email address, which has not been specified as a personal or business address.
     */
    public final String emailAddress() {
        return emailAddress;
    }

    /**
     * <p>
     * The customer's first name.
     * </p>
     * 
     * @return The customer's first name.
     */
    public final String firstName() {
        return firstName;
    }

    /**
     * <p>
     * The customer's gender.
     * </p>
     * 
     * @return The customer's gender.
     */
    public final String gender() {
        return gender;
    }

    /**
     * <p>
     * The customer's mobile phone number.
     * </p>
     * 
     * @return The customer's mobile phone number.
     */
    public final String homePhoneNumber() {
        return homePhoneNumber;
    }

    /**
     * <p>
     * The customer's last name.
     * </p>
     * 
     * @return The customer's last name.
     */
    public final String lastName() {
        return lastName;
    }

    /**
     * <p>
     * The first line of a customer’s mailing address.
     * </p>
     * 
     * @return The first line of a customer’s mailing address.
     */
    public final String mailingAddress1() {
        return mailingAddress1;
    }

    /**
     * <p>
     * The second line of a customer’s mailing address.
     * </p>
     * 
     * @return The second line of a customer’s mailing address.
     */
    public final String mailingAddress2() {
        return mailingAddress2;
    }

    /**
     * <p>
     * The third line of a customer’s mailing address.
     * </p>
     * 
     * @return The third line of a customer’s mailing address.
     */
    public final String mailingAddress3() {
        return mailingAddress3;
    }

    /**
     * <p>
     * The fourth line of a customer’s mailing address.
     * </p>
     * 
     * @return The fourth line of a customer’s mailing address.
     */
    public final String mailingAddress4() {
        return mailingAddress4;
    }

    /**
     * <p>
     * The city of a customer’s mailing address.
     * </p>
     * 
     * @return The city of a customer’s mailing address.
     */
    public final String mailingCity() {
        return mailingCity;
    }

    /**
     * <p>
     * The country of a customer’s mailing address.
     * </p>
     * 
     * @return The country of a customer’s mailing address.
     */
    public final String mailingCountry() {
        return mailingCountry;
    }

    /**
     * <p>
     * The county of a customer’s mailing address.
     * </p>
     * 
     * @return The county of a customer’s mailing address.
     */
    public final String mailingCounty() {
        return mailingCounty;
    }

    /**
     * <p>
     * The postal code of a customer’s mailing address.
     * </p>
     * 
     * @return The postal code of a customer’s mailing address.
     */
    public final String mailingPostalCode() {
        return mailingPostalCode;
    }

    /**
     * <p>
     * The province of a customer’s mailing address.
     * </p>
     * 
     * @return The province of a customer’s mailing address.
     */
    public final String mailingProvince() {
        return mailingProvince;
    }

    /**
     * <p>
     * The state of a customer’s mailing address.
     * </p>
     * 
     * @return The state of a customer’s mailing address.
     */
    public final String mailingState() {
        return mailingState;
    }

    /**
     * <p>
     * The customer's middle name.
     * </p>
     * 
     * @return The customer's middle name.
     */
    public final String middleName() {
        return middleName;
    }

    /**
     * <p>
     * The customer's mobile phone number.
     * </p>
     * 
     * @return The customer's mobile phone number.
     */
    public final String mobilePhoneNumber() {
        return mobilePhoneNumber;
    }

    /**
     * <p>
     * The customer's party type.
     * </p>
     * 
     * @return The customer's party type.
     */
    public final String partyType() {
        return partyType;
    }

    /**
     * <p>
     * The customer's phone number, which has not been specified as a mobile, home, or business number.
     * </p>
     * 
     * @return The customer's phone number, which has not been specified as a mobile, home, or business number.
     */
    public final String phoneNumber() {
        return phoneNumber;
    }

    /**
     * <p>
     * The postal code of a customer address.
     * </p>
     * 
     * @return The postal code of a customer address.
     */
    public final String postalCode() {
        return postalCode;
    }

    /**
     * <p>
     * The ARN of a customer profile.
     * </p>
     * 
     * @return The ARN of a customer profile.
     */
    public final String profileARN() {
        return profileARN;
    }

    /**
     * <p>
     * The unique identifier of a customer profile.
     * </p>
     * 
     * @return The unique identifier of a customer profile.
     */
    public final String profileId() {
        return profileId;
    }

    /**
     * <p>
     * The province in which a customer lives.
     * </p>
     * 
     * @return The province in which a customer lives.
     */
    public final String province() {
        return province;
    }

    /**
     * <p>
     * The first line of a customer’s shipping address.
     * </p>
     * 
     * @return The first line of a customer’s shipping address.
     */
    public final String shippingAddress1() {
        return shippingAddress1;
    }

    /**
     * <p>
     * The second line of a customer’s shipping address.
     * </p>
     * 
     * @return The second line of a customer’s shipping address.
     */
    public final String shippingAddress2() {
        return shippingAddress2;
    }

    /**
     * <p>
     * The third line of a customer’s shipping address.
     * </p>
     * 
     * @return The third line of a customer’s shipping address.
     */
    public final String shippingAddress3() {
        return shippingAddress3;
    }

    /**
     * <p>
     * The fourth line of a customer’s shipping address.
     * </p>
     * 
     * @return The fourth line of a customer’s shipping address.
     */
    public final String shippingAddress4() {
        return shippingAddress4;
    }

    /**
     * <p>
     * The city of a customer’s shipping address.
     * </p>
     * 
     * @return The city of a customer’s shipping address.
     */
    public final String shippingCity() {
        return shippingCity;
    }

    /**
     * <p>
     * The country of a customer’s shipping address.
     * </p>
     * 
     * @return The country of a customer’s shipping address.
     */
    public final String shippingCountry() {
        return shippingCountry;
    }

    /**
     * <p>
     * The county of a customer’s shipping address.
     * </p>
     * 
     * @return The county of a customer’s shipping address.
     */
    public final String shippingCounty() {
        return shippingCounty;
    }

    /**
     * <p>
     * The postal code of a customer’s shipping address.
     * </p>
     * 
     * @return The postal code of a customer’s shipping address.
     */
    public final String shippingPostalCode() {
        return shippingPostalCode;
    }

    /**
     * <p>
     * The province of a customer’s shipping address.
     * </p>
     * 
     * @return The province of a customer’s shipping address.
     */
    public final String shippingProvince() {
        return shippingProvince;
    }

    /**
     * <p>
     * The state of a customer’s shipping address.
     * </p>
     * 
     * @return The state of a customer’s shipping address.
     */
    public final String shippingState() {
        return shippingState;
    }

    /**
     * <p>
     * The state in which a customer lives.
     * </p>
     * 
     * @return The state in which a customer lives.
     */
    public final String state() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountNumber());
        hashCode = 31 * hashCode + Objects.hashCode(additionalInformation());
        hashCode = 31 * hashCode + Objects.hashCode(address1());
        hashCode = 31 * hashCode + Objects.hashCode(address2());
        hashCode = 31 * hashCode + Objects.hashCode(address3());
        hashCode = 31 * hashCode + Objects.hashCode(address4());
        hashCode = 31 * hashCode + Objects.hashCode(billingAddress1());
        hashCode = 31 * hashCode + Objects.hashCode(billingAddress2());
        hashCode = 31 * hashCode + Objects.hashCode(billingAddress3());
        hashCode = 31 * hashCode + Objects.hashCode(billingAddress4());
        hashCode = 31 * hashCode + Objects.hashCode(billingCity());
        hashCode = 31 * hashCode + Objects.hashCode(billingCountry());
        hashCode = 31 * hashCode + Objects.hashCode(billingCounty());
        hashCode = 31 * hashCode + Objects.hashCode(billingPostalCode());
        hashCode = 31 * hashCode + Objects.hashCode(billingProvince());
        hashCode = 31 * hashCode + Objects.hashCode(billingState());
        hashCode = 31 * hashCode + Objects.hashCode(birthDate());
        hashCode = 31 * hashCode + Objects.hashCode(businessEmailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(businessName());
        hashCode = 31 * hashCode + Objects.hashCode(businessPhoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(city());
        hashCode = 31 * hashCode + Objects.hashCode(country());
        hashCode = 31 * hashCode + Objects.hashCode(county());
        hashCode = 31 * hashCode + Objects.hashCode(hasCustom() ? custom() : null);
        hashCode = 31 * hashCode + Objects.hashCode(emailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(firstName());
        hashCode = 31 * hashCode + Objects.hashCode(gender());
        hashCode = 31 * hashCode + Objects.hashCode(homePhoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(lastName());
        hashCode = 31 * hashCode + Objects.hashCode(mailingAddress1());
        hashCode = 31 * hashCode + Objects.hashCode(mailingAddress2());
        hashCode = 31 * hashCode + Objects.hashCode(mailingAddress3());
        hashCode = 31 * hashCode + Objects.hashCode(mailingAddress4());
        hashCode = 31 * hashCode + Objects.hashCode(mailingCity());
        hashCode = 31 * hashCode + Objects.hashCode(mailingCountry());
        hashCode = 31 * hashCode + Objects.hashCode(mailingCounty());
        hashCode = 31 * hashCode + Objects.hashCode(mailingPostalCode());
        hashCode = 31 * hashCode + Objects.hashCode(mailingProvince());
        hashCode = 31 * hashCode + Objects.hashCode(mailingState());
        hashCode = 31 * hashCode + Objects.hashCode(middleName());
        hashCode = 31 * hashCode + Objects.hashCode(mobilePhoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(partyType());
        hashCode = 31 * hashCode + Objects.hashCode(phoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(postalCode());
        hashCode = 31 * hashCode + Objects.hashCode(profileARN());
        hashCode = 31 * hashCode + Objects.hashCode(profileId());
        hashCode = 31 * hashCode + Objects.hashCode(province());
        hashCode = 31 * hashCode + Objects.hashCode(shippingAddress1());
        hashCode = 31 * hashCode + Objects.hashCode(shippingAddress2());
        hashCode = 31 * hashCode + Objects.hashCode(shippingAddress3());
        hashCode = 31 * hashCode + Objects.hashCode(shippingAddress4());
        hashCode = 31 * hashCode + Objects.hashCode(shippingCity());
        hashCode = 31 * hashCode + Objects.hashCode(shippingCountry());
        hashCode = 31 * hashCode + Objects.hashCode(shippingCounty());
        hashCode = 31 * hashCode + Objects.hashCode(shippingPostalCode());
        hashCode = 31 * hashCode + Objects.hashCode(shippingProvince());
        hashCode = 31 * hashCode + Objects.hashCode(shippingState());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomerProfileAttributes)) {
            return false;
        }
        CustomerProfileAttributes other = (CustomerProfileAttributes) obj;
        return Objects.equals(accountNumber(), other.accountNumber())
                && Objects.equals(additionalInformation(), other.additionalInformation())
                && Objects.equals(address1(), other.address1()) && Objects.equals(address2(), other.address2())
                && Objects.equals(address3(), other.address3()) && Objects.equals(address4(), other.address4())
                && Objects.equals(billingAddress1(), other.billingAddress1())
                && Objects.equals(billingAddress2(), other.billingAddress2())
                && Objects.equals(billingAddress3(), other.billingAddress3())
                && Objects.equals(billingAddress4(), other.billingAddress4())
                && Objects.equals(billingCity(), other.billingCity()) && Objects.equals(billingCountry(), other.billingCountry())
                && Objects.equals(billingCounty(), other.billingCounty())
                && Objects.equals(billingPostalCode(), other.billingPostalCode())
                && Objects.equals(billingProvince(), other.billingProvince())
                && Objects.equals(billingState(), other.billingState()) && Objects.equals(birthDate(), other.birthDate())
                && Objects.equals(businessEmailAddress(), other.businessEmailAddress())
                && Objects.equals(businessName(), other.businessName())
                && Objects.equals(businessPhoneNumber(), other.businessPhoneNumber()) && Objects.equals(city(), other.city())
                && Objects.equals(country(), other.country()) && Objects.equals(county(), other.county())
                && hasCustom() == other.hasCustom() && Objects.equals(custom(), other.custom())
                && Objects.equals(emailAddress(), other.emailAddress()) && Objects.equals(firstName(), other.firstName())
                && Objects.equals(gender(), other.gender()) && Objects.equals(homePhoneNumber(), other.homePhoneNumber())
                && Objects.equals(lastName(), other.lastName()) && Objects.equals(mailingAddress1(), other.mailingAddress1())
                && Objects.equals(mailingAddress2(), other.mailingAddress2())
                && Objects.equals(mailingAddress3(), other.mailingAddress3())
                && Objects.equals(mailingAddress4(), other.mailingAddress4())
                && Objects.equals(mailingCity(), other.mailingCity()) && Objects.equals(mailingCountry(), other.mailingCountry())
                && Objects.equals(mailingCounty(), other.mailingCounty())
                && Objects.equals(mailingPostalCode(), other.mailingPostalCode())
                && Objects.equals(mailingProvince(), other.mailingProvince())
                && Objects.equals(mailingState(), other.mailingState()) && Objects.equals(middleName(), other.middleName())
                && Objects.equals(mobilePhoneNumber(), other.mobilePhoneNumber())
                && Objects.equals(partyType(), other.partyType()) && Objects.equals(phoneNumber(), other.phoneNumber())
                && Objects.equals(postalCode(), other.postalCode()) && Objects.equals(profileARN(), other.profileARN())
                && Objects.equals(profileId(), other.profileId()) && Objects.equals(province(), other.province())
                && Objects.equals(shippingAddress1(), other.shippingAddress1())
                && Objects.equals(shippingAddress2(), other.shippingAddress2())
                && Objects.equals(shippingAddress3(), other.shippingAddress3())
                && Objects.equals(shippingAddress4(), other.shippingAddress4())
                && Objects.equals(shippingCity(), other.shippingCity())
                && Objects.equals(shippingCountry(), other.shippingCountry())
                && Objects.equals(shippingCounty(), other.shippingCounty())
                && Objects.equals(shippingPostalCode(), other.shippingPostalCode())
                && Objects.equals(shippingProvince(), other.shippingProvince())
                && Objects.equals(shippingState(), other.shippingState()) && Objects.equals(state(), other.state());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomerProfileAttributes")
                .add("AccountNumber", accountNumber() == null ? null : "*** Sensitive Data Redacted ***")
                .add("AdditionalInformation", additionalInformation() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Address1", address1() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Address2", address2() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Address3", address3() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Address4", address4() == null ? null : "*** Sensitive Data Redacted ***")
                .add("BillingAddress1", billingAddress1() == null ? null : "*** Sensitive Data Redacted ***")
                .add("BillingAddress2", billingAddress2() == null ? null : "*** Sensitive Data Redacted ***")
                .add("BillingAddress3", billingAddress3() == null ? null : "*** Sensitive Data Redacted ***")
                .add("BillingAddress4", billingAddress4() == null ? null : "*** Sensitive Data Redacted ***")
                .add("BillingCity", billingCity() == null ? null : "*** Sensitive Data Redacted ***")
                .add("BillingCountry", billingCountry() == null ? null : "*** Sensitive Data Redacted ***")
                .add("BillingCounty", billingCounty() == null ? null : "*** Sensitive Data Redacted ***")
                .add("BillingPostalCode", billingPostalCode() == null ? null : "*** Sensitive Data Redacted ***")
                .add("BillingProvince", billingProvince() == null ? null : "*** Sensitive Data Redacted ***")
                .add("BillingState", billingState() == null ? null : "*** Sensitive Data Redacted ***")
                .add("BirthDate", birthDate() == null ? null : "*** Sensitive Data Redacted ***")
                .add("BusinessEmailAddress", businessEmailAddress() == null ? null : "*** Sensitive Data Redacted ***")
                .add("BusinessName", businessName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("BusinessPhoneNumber", businessPhoneNumber() == null ? null : "*** Sensitive Data Redacted ***")
                .add("City", city() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Country", country() == null ? null : "*** Sensitive Data Redacted ***")
                .add("County", county() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Custom", custom() == null ? null : "*** Sensitive Data Redacted ***")
                .add("EmailAddress", emailAddress() == null ? null : "*** Sensitive Data Redacted ***")
                .add("FirstName", firstName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Gender", gender() == null ? null : "*** Sensitive Data Redacted ***")
                .add("HomePhoneNumber", homePhoneNumber() == null ? null : "*** Sensitive Data Redacted ***")
                .add("LastName", lastName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("MailingAddress1", mailingAddress1() == null ? null : "*** Sensitive Data Redacted ***")
                .add("MailingAddress2", mailingAddress2() == null ? null : "*** Sensitive Data Redacted ***")
                .add("MailingAddress3", mailingAddress3() == null ? null : "*** Sensitive Data Redacted ***")
                .add("MailingAddress4", mailingAddress4() == null ? null : "*** Sensitive Data Redacted ***")
                .add("MailingCity", mailingCity() == null ? null : "*** Sensitive Data Redacted ***")
                .add("MailingCountry", mailingCountry() == null ? null : "*** Sensitive Data Redacted ***")
                .add("MailingCounty", mailingCounty() == null ? null : "*** Sensitive Data Redacted ***")
                .add("MailingPostalCode", mailingPostalCode() == null ? null : "*** Sensitive Data Redacted ***")
                .add("MailingProvince", mailingProvince() == null ? null : "*** Sensitive Data Redacted ***")
                .add("MailingState", mailingState() == null ? null : "*** Sensitive Data Redacted ***")
                .add("MiddleName", middleName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("MobilePhoneNumber", mobilePhoneNumber() == null ? null : "*** Sensitive Data Redacted ***")
                .add("PartyType", partyType() == null ? null : "*** Sensitive Data Redacted ***")
                .add("PhoneNumber", phoneNumber() == null ? null : "*** Sensitive Data Redacted ***")
                .add("PostalCode", postalCode() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ProfileARN", profileARN() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ProfileId", profileId() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Province", province() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ShippingAddress1", shippingAddress1() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ShippingAddress2", shippingAddress2() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ShippingAddress3", shippingAddress3() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ShippingAddress4", shippingAddress4() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ShippingCity", shippingCity() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ShippingCountry", shippingCountry() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ShippingCounty", shippingCounty() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ShippingPostalCode", shippingPostalCode() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ShippingProvince", shippingProvince() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ShippingState", shippingState() == null ? null : "*** Sensitive Data Redacted ***")
                .add("State", state() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountNumber":
            return Optional.ofNullable(clazz.cast(accountNumber()));
        case "additionalInformation":
            return Optional.ofNullable(clazz.cast(additionalInformation()));
        case "address1":
            return Optional.ofNullable(clazz.cast(address1()));
        case "address2":
            return Optional.ofNullable(clazz.cast(address2()));
        case "address3":
            return Optional.ofNullable(clazz.cast(address3()));
        case "address4":
            return Optional.ofNullable(clazz.cast(address4()));
        case "billingAddress1":
            return Optional.ofNullable(clazz.cast(billingAddress1()));
        case "billingAddress2":
            return Optional.ofNullable(clazz.cast(billingAddress2()));
        case "billingAddress3":
            return Optional.ofNullable(clazz.cast(billingAddress3()));
        case "billingAddress4":
            return Optional.ofNullable(clazz.cast(billingAddress4()));
        case "billingCity":
            return Optional.ofNullable(clazz.cast(billingCity()));
        case "billingCountry":
            return Optional.ofNullable(clazz.cast(billingCountry()));
        case "billingCounty":
            return Optional.ofNullable(clazz.cast(billingCounty()));
        case "billingPostalCode":
            return Optional.ofNullable(clazz.cast(billingPostalCode()));
        case "billingProvince":
            return Optional.ofNullable(clazz.cast(billingProvince()));
        case "billingState":
            return Optional.ofNullable(clazz.cast(billingState()));
        case "birthDate":
            return Optional.ofNullable(clazz.cast(birthDate()));
        case "businessEmailAddress":
            return Optional.ofNullable(clazz.cast(businessEmailAddress()));
        case "businessName":
            return Optional.ofNullable(clazz.cast(businessName()));
        case "businessPhoneNumber":
            return Optional.ofNullable(clazz.cast(businessPhoneNumber()));
        case "city":
            return Optional.ofNullable(clazz.cast(city()));
        case "country":
            return Optional.ofNullable(clazz.cast(country()));
        case "county":
            return Optional.ofNullable(clazz.cast(county()));
        case "custom":
            return Optional.ofNullable(clazz.cast(custom()));
        case "emailAddress":
            return Optional.ofNullable(clazz.cast(emailAddress()));
        case "firstName":
            return Optional.ofNullable(clazz.cast(firstName()));
        case "gender":
            return Optional.ofNullable(clazz.cast(gender()));
        case "homePhoneNumber":
            return Optional.ofNullable(clazz.cast(homePhoneNumber()));
        case "lastName":
            return Optional.ofNullable(clazz.cast(lastName()));
        case "mailingAddress1":
            return Optional.ofNullable(clazz.cast(mailingAddress1()));
        case "mailingAddress2":
            return Optional.ofNullable(clazz.cast(mailingAddress2()));
        case "mailingAddress3":
            return Optional.ofNullable(clazz.cast(mailingAddress3()));
        case "mailingAddress4":
            return Optional.ofNullable(clazz.cast(mailingAddress4()));
        case "mailingCity":
            return Optional.ofNullable(clazz.cast(mailingCity()));
        case "mailingCountry":
            return Optional.ofNullable(clazz.cast(mailingCountry()));
        case "mailingCounty":
            return Optional.ofNullable(clazz.cast(mailingCounty()));
        case "mailingPostalCode":
            return Optional.ofNullable(clazz.cast(mailingPostalCode()));
        case "mailingProvince":
            return Optional.ofNullable(clazz.cast(mailingProvince()));
        case "mailingState":
            return Optional.ofNullable(clazz.cast(mailingState()));
        case "middleName":
            return Optional.ofNullable(clazz.cast(middleName()));
        case "mobilePhoneNumber":
            return Optional.ofNullable(clazz.cast(mobilePhoneNumber()));
        case "partyType":
            return Optional.ofNullable(clazz.cast(partyType()));
        case "phoneNumber":
            return Optional.ofNullable(clazz.cast(phoneNumber()));
        case "postalCode":
            return Optional.ofNullable(clazz.cast(postalCode()));
        case "profileARN":
            return Optional.ofNullable(clazz.cast(profileARN()));
        case "profileId":
            return Optional.ofNullable(clazz.cast(profileId()));
        case "province":
            return Optional.ofNullable(clazz.cast(province()));
        case "shippingAddress1":
            return Optional.ofNullable(clazz.cast(shippingAddress1()));
        case "shippingAddress2":
            return Optional.ofNullable(clazz.cast(shippingAddress2()));
        case "shippingAddress3":
            return Optional.ofNullable(clazz.cast(shippingAddress3()));
        case "shippingAddress4":
            return Optional.ofNullable(clazz.cast(shippingAddress4()));
        case "shippingCity":
            return Optional.ofNullable(clazz.cast(shippingCity()));
        case "shippingCountry":
            return Optional.ofNullable(clazz.cast(shippingCountry()));
        case "shippingCounty":
            return Optional.ofNullable(clazz.cast(shippingCounty()));
        case "shippingPostalCode":
            return Optional.ofNullable(clazz.cast(shippingPostalCode()));
        case "shippingProvince":
            return Optional.ofNullable(clazz.cast(shippingProvince()));
        case "shippingState":
            return Optional.ofNullable(clazz.cast(shippingState()));
        case "state":
            return Optional.ofNullable(clazz.cast(state()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("accountNumber", ACCOUNT_NUMBER_FIELD);
        map.put("additionalInformation", ADDITIONAL_INFORMATION_FIELD);
        map.put("address1", ADDRESS1_FIELD);
        map.put("address2", ADDRESS2_FIELD);
        map.put("address3", ADDRESS3_FIELD);
        map.put("address4", ADDRESS4_FIELD);
        map.put("billingAddress1", BILLING_ADDRESS1_FIELD);
        map.put("billingAddress2", BILLING_ADDRESS2_FIELD);
        map.put("billingAddress3", BILLING_ADDRESS3_FIELD);
        map.put("billingAddress4", BILLING_ADDRESS4_FIELD);
        map.put("billingCity", BILLING_CITY_FIELD);
        map.put("billingCountry", BILLING_COUNTRY_FIELD);
        map.put("billingCounty", BILLING_COUNTY_FIELD);
        map.put("billingPostalCode", BILLING_POSTAL_CODE_FIELD);
        map.put("billingProvince", BILLING_PROVINCE_FIELD);
        map.put("billingState", BILLING_STATE_FIELD);
        map.put("birthDate", BIRTH_DATE_FIELD);
        map.put("businessEmailAddress", BUSINESS_EMAIL_ADDRESS_FIELD);
        map.put("businessName", BUSINESS_NAME_FIELD);
        map.put("businessPhoneNumber", BUSINESS_PHONE_NUMBER_FIELD);
        map.put("city", CITY_FIELD);
        map.put("country", COUNTRY_FIELD);
        map.put("county", COUNTY_FIELD);
        map.put("custom", CUSTOM_FIELD);
        map.put("emailAddress", EMAIL_ADDRESS_FIELD);
        map.put("firstName", FIRST_NAME_FIELD);
        map.put("gender", GENDER_FIELD);
        map.put("homePhoneNumber", HOME_PHONE_NUMBER_FIELD);
        map.put("lastName", LAST_NAME_FIELD);
        map.put("mailingAddress1", MAILING_ADDRESS1_FIELD);
        map.put("mailingAddress2", MAILING_ADDRESS2_FIELD);
        map.put("mailingAddress3", MAILING_ADDRESS3_FIELD);
        map.put("mailingAddress4", MAILING_ADDRESS4_FIELD);
        map.put("mailingCity", MAILING_CITY_FIELD);
        map.put("mailingCountry", MAILING_COUNTRY_FIELD);
        map.put("mailingCounty", MAILING_COUNTY_FIELD);
        map.put("mailingPostalCode", MAILING_POSTAL_CODE_FIELD);
        map.put("mailingProvince", MAILING_PROVINCE_FIELD);
        map.put("mailingState", MAILING_STATE_FIELD);
        map.put("middleName", MIDDLE_NAME_FIELD);
        map.put("mobilePhoneNumber", MOBILE_PHONE_NUMBER_FIELD);
        map.put("partyType", PARTY_TYPE_FIELD);
        map.put("phoneNumber", PHONE_NUMBER_FIELD);
        map.put("postalCode", POSTAL_CODE_FIELD);
        map.put("profileARN", PROFILE_ARN_FIELD);
        map.put("profileId", PROFILE_ID_FIELD);
        map.put("province", PROVINCE_FIELD);
        map.put("shippingAddress1", SHIPPING_ADDRESS1_FIELD);
        map.put("shippingAddress2", SHIPPING_ADDRESS2_FIELD);
        map.put("shippingAddress3", SHIPPING_ADDRESS3_FIELD);
        map.put("shippingAddress4", SHIPPING_ADDRESS4_FIELD);
        map.put("shippingCity", SHIPPING_CITY_FIELD);
        map.put("shippingCountry", SHIPPING_COUNTRY_FIELD);
        map.put("shippingCounty", SHIPPING_COUNTY_FIELD);
        map.put("shippingPostalCode", SHIPPING_POSTAL_CODE_FIELD);
        map.put("shippingProvince", SHIPPING_PROVINCE_FIELD);
        map.put("shippingState", SHIPPING_STATE_FIELD);
        map.put("state", STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomerProfileAttributes, T> g) {
        return obj -> g.apply((CustomerProfileAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomerProfileAttributes> {
        /**
         * <p>
         * A unique account number that you have given to the customer.
         * </p>
         * 
         * @param accountNumber
         *        A unique account number that you have given to the customer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountNumber(String accountNumber);

        /**
         * <p>
         * Any additional information relevant to the customer's profile.
         * </p>
         * 
         * @param additionalInformation
         *        Any additional information relevant to the customer's profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalInformation(String additionalInformation);

        /**
         * <p>
         * The first line of a customer address.
         * </p>
         * 
         * @param address1
         *        The first line of a customer address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder address1(String address1);

        /**
         * <p>
         * The second line of a customer address.
         * </p>
         * 
         * @param address2
         *        The second line of a customer address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder address2(String address2);

        /**
         * <p>
         * The third line of a customer address.
         * </p>
         * 
         * @param address3
         *        The third line of a customer address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder address3(String address3);

        /**
         * <p>
         * The fourth line of a customer address.
         * </p>
         * 
         * @param address4
         *        The fourth line of a customer address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder address4(String address4);

        /**
         * <p>
         * The first line of a customer’s billing address.
         * </p>
         * 
         * @param billingAddress1
         *        The first line of a customer’s billing address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingAddress1(String billingAddress1);

        /**
         * <p>
         * The second line of a customer’s billing address.
         * </p>
         * 
         * @param billingAddress2
         *        The second line of a customer’s billing address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingAddress2(String billingAddress2);

        /**
         * <p>
         * The third line of a customer’s billing address.
         * </p>
         * 
         * @param billingAddress3
         *        The third line of a customer’s billing address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingAddress3(String billingAddress3);

        /**
         * <p>
         * The fourth line of a customer’s billing address.
         * </p>
         * 
         * @param billingAddress4
         *        The fourth line of a customer’s billing address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingAddress4(String billingAddress4);

        /**
         * <p>
         * The city of a customer’s billing address.
         * </p>
         * 
         * @param billingCity
         *        The city of a customer’s billing address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingCity(String billingCity);

        /**
         * <p>
         * The country of a customer’s billing address.
         * </p>
         * 
         * @param billingCountry
         *        The country of a customer’s billing address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingCountry(String billingCountry);

        /**
         * <p>
         * The county of a customer’s billing address.
         * </p>
         * 
         * @param billingCounty
         *        The county of a customer’s billing address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingCounty(String billingCounty);

        /**
         * <p>
         * The postal code of a customer’s billing address.
         * </p>
         * 
         * @param billingPostalCode
         *        The postal code of a customer’s billing address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingPostalCode(String billingPostalCode);

        /**
         * <p>
         * The province of a customer’s billing address.
         * </p>
         * 
         * @param billingProvince
         *        The province of a customer’s billing address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingProvince(String billingProvince);

        /**
         * <p>
         * The state of a customer’s billing address.
         * </p>
         * 
         * @param billingState
         *        The state of a customer’s billing address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingState(String billingState);

        /**
         * <p>
         * The customer's birth date.
         * </p>
         * 
         * @param birthDate
         *        The customer's birth date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder birthDate(String birthDate);

        /**
         * <p>
         * The customer's business email address.
         * </p>
         * 
         * @param businessEmailAddress
         *        The customer's business email address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder businessEmailAddress(String businessEmailAddress);

        /**
         * <p>
         * The name of the customer's business.
         * </p>
         * 
         * @param businessName
         *        The name of the customer's business.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder businessName(String businessName);

        /**
         * <p>
         * The customer's business phone number.
         * </p>
         * 
         * @param businessPhoneNumber
         *        The customer's business phone number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder businessPhoneNumber(String businessPhoneNumber);

        /**
         * <p>
         * The city in which a customer lives.
         * </p>
         * 
         * @param city
         *        The city in which a customer lives.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder city(String city);

        /**
         * <p>
         * The country in which a customer lives.
         * </p>
         * 
         * @param country
         *        The country in which a customer lives.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder country(String country);

        /**
         * <p>
         * The county in which a customer lives.
         * </p>
         * 
         * @param county
         *        The county in which a customer lives.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder county(String county);

        /**
         * <p>
         * The custom attributes in customer profile attributes.
         * </p>
         * 
         * @param custom
         *        The custom attributes in customer profile attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder custom(Map<String, String> custom);

        /**
         * <p>
         * The customer's email address, which has not been specified as a personal or business address.
         * </p>
         * 
         * @param emailAddress
         *        The customer's email address, which has not been specified as a personal or business address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailAddress(String emailAddress);

        /**
         * <p>
         * The customer's first name.
         * </p>
         * 
         * @param firstName
         *        The customer's first name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstName(String firstName);

        /**
         * <p>
         * The customer's gender.
         * </p>
         * 
         * @param gender
         *        The customer's gender.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gender(String gender);

        /**
         * <p>
         * The customer's mobile phone number.
         * </p>
         * 
         * @param homePhoneNumber
         *        The customer's mobile phone number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder homePhoneNumber(String homePhoneNumber);

        /**
         * <p>
         * The customer's last name.
         * </p>
         * 
         * @param lastName
         *        The customer's last name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastName(String lastName);

        /**
         * <p>
         * The first line of a customer’s mailing address.
         * </p>
         * 
         * @param mailingAddress1
         *        The first line of a customer’s mailing address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mailingAddress1(String mailingAddress1);

        /**
         * <p>
         * The second line of a customer’s mailing address.
         * </p>
         * 
         * @param mailingAddress2
         *        The second line of a customer’s mailing address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mailingAddress2(String mailingAddress2);

        /**
         * <p>
         * The third line of a customer’s mailing address.
         * </p>
         * 
         * @param mailingAddress3
         *        The third line of a customer’s mailing address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mailingAddress3(String mailingAddress3);

        /**
         * <p>
         * The fourth line of a customer’s mailing address.
         * </p>
         * 
         * @param mailingAddress4
         *        The fourth line of a customer’s mailing address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mailingAddress4(String mailingAddress4);

        /**
         * <p>
         * The city of a customer’s mailing address.
         * </p>
         * 
         * @param mailingCity
         *        The city of a customer’s mailing address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mailingCity(String mailingCity);

        /**
         * <p>
         * The country of a customer’s mailing address.
         * </p>
         * 
         * @param mailingCountry
         *        The country of a customer’s mailing address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mailingCountry(String mailingCountry);

        /**
         * <p>
         * The county of a customer’s mailing address.
         * </p>
         * 
         * @param mailingCounty
         *        The county of a customer’s mailing address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mailingCounty(String mailingCounty);

        /**
         * <p>
         * The postal code of a customer’s mailing address.
         * </p>
         * 
         * @param mailingPostalCode
         *        The postal code of a customer’s mailing address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mailingPostalCode(String mailingPostalCode);

        /**
         * <p>
         * The province of a customer’s mailing address.
         * </p>
         * 
         * @param mailingProvince
         *        The province of a customer’s mailing address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mailingProvince(String mailingProvince);

        /**
         * <p>
         * The state of a customer’s mailing address.
         * </p>
         * 
         * @param mailingState
         *        The state of a customer’s mailing address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mailingState(String mailingState);

        /**
         * <p>
         * The customer's middle name.
         * </p>
         * 
         * @param middleName
         *        The customer's middle name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder middleName(String middleName);

        /**
         * <p>
         * The customer's mobile phone number.
         * </p>
         * 
         * @param mobilePhoneNumber
         *        The customer's mobile phone number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mobilePhoneNumber(String mobilePhoneNumber);

        /**
         * <p>
         * The customer's party type.
         * </p>
         * 
         * @param partyType
         *        The customer's party type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partyType(String partyType);

        /**
         * <p>
         * The customer's phone number, which has not been specified as a mobile, home, or business number.
         * </p>
         * 
         * @param phoneNumber
         *        The customer's phone number, which has not been specified as a mobile, home, or business number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumber(String phoneNumber);

        /**
         * <p>
         * The postal code of a customer address.
         * </p>
         * 
         * @param postalCode
         *        The postal code of a customer address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder postalCode(String postalCode);

        /**
         * <p>
         * The ARN of a customer profile.
         * </p>
         * 
         * @param profileARN
         *        The ARN of a customer profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileARN(String profileARN);

        /**
         * <p>
         * The unique identifier of a customer profile.
         * </p>
         * 
         * @param profileId
         *        The unique identifier of a customer profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileId(String profileId);

        /**
         * <p>
         * The province in which a customer lives.
         * </p>
         * 
         * @param province
         *        The province in which a customer lives.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder province(String province);

        /**
         * <p>
         * The first line of a customer’s shipping address.
         * </p>
         * 
         * @param shippingAddress1
         *        The first line of a customer’s shipping address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shippingAddress1(String shippingAddress1);

        /**
         * <p>
         * The second line of a customer’s shipping address.
         * </p>
         * 
         * @param shippingAddress2
         *        The second line of a customer’s shipping address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shippingAddress2(String shippingAddress2);

        /**
         * <p>
         * The third line of a customer’s shipping address.
         * </p>
         * 
         * @param shippingAddress3
         *        The third line of a customer’s shipping address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shippingAddress3(String shippingAddress3);

        /**
         * <p>
         * The fourth line of a customer’s shipping address.
         * </p>
         * 
         * @param shippingAddress4
         *        The fourth line of a customer’s shipping address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shippingAddress4(String shippingAddress4);

        /**
         * <p>
         * The city of a customer’s shipping address.
         * </p>
         * 
         * @param shippingCity
         *        The city of a customer’s shipping address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shippingCity(String shippingCity);

        /**
         * <p>
         * The country of a customer’s shipping address.
         * </p>
         * 
         * @param shippingCountry
         *        The country of a customer’s shipping address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shippingCountry(String shippingCountry);

        /**
         * <p>
         * The county of a customer’s shipping address.
         * </p>
         * 
         * @param shippingCounty
         *        The county of a customer’s shipping address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shippingCounty(String shippingCounty);

        /**
         * <p>
         * The postal code of a customer’s shipping address.
         * </p>
         * 
         * @param shippingPostalCode
         *        The postal code of a customer’s shipping address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shippingPostalCode(String shippingPostalCode);

        /**
         * <p>
         * The province of a customer’s shipping address.
         * </p>
         * 
         * @param shippingProvince
         *        The province of a customer’s shipping address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shippingProvince(String shippingProvince);

        /**
         * <p>
         * The state of a customer’s shipping address.
         * </p>
         * 
         * @param shippingState
         *        The state of a customer’s shipping address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shippingState(String shippingState);

        /**
         * <p>
         * The state in which a customer lives.
         * </p>
         * 
         * @param state
         *        The state in which a customer lives.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(String state);
    }

    static final class BuilderImpl implements Builder {
        private String accountNumber;

        private String additionalInformation;

        private String address1;

        private String address2;

        private String address3;

        private String address4;

        private String billingAddress1;

        private String billingAddress2;

        private String billingAddress3;

        private String billingAddress4;

        private String billingCity;

        private String billingCountry;

        private String billingCounty;

        private String billingPostalCode;

        private String billingProvince;

        private String billingState;

        private String birthDate;

        private String businessEmailAddress;

        private String businessName;

        private String businessPhoneNumber;

        private String city;

        private String country;

        private String county;

        private Map<String, String> custom = DefaultSdkAutoConstructMap.getInstance();

        private String emailAddress;

        private String firstName;

        private String gender;

        private String homePhoneNumber;

        private String lastName;

        private String mailingAddress1;

        private String mailingAddress2;

        private String mailingAddress3;

        private String mailingAddress4;

        private String mailingCity;

        private String mailingCountry;

        private String mailingCounty;

        private String mailingPostalCode;

        private String mailingProvince;

        private String mailingState;

        private String middleName;

        private String mobilePhoneNumber;

        private String partyType;

        private String phoneNumber;

        private String postalCode;

        private String profileARN;

        private String profileId;

        private String province;

        private String shippingAddress1;

        private String shippingAddress2;

        private String shippingAddress3;

        private String shippingAddress4;

        private String shippingCity;

        private String shippingCountry;

        private String shippingCounty;

        private String shippingPostalCode;

        private String shippingProvince;

        private String shippingState;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomerProfileAttributes model) {
            accountNumber(model.accountNumber);
            additionalInformation(model.additionalInformation);
            address1(model.address1);
            address2(model.address2);
            address3(model.address3);
            address4(model.address4);
            billingAddress1(model.billingAddress1);
            billingAddress2(model.billingAddress2);
            billingAddress3(model.billingAddress3);
            billingAddress4(model.billingAddress4);
            billingCity(model.billingCity);
            billingCountry(model.billingCountry);
            billingCounty(model.billingCounty);
            billingPostalCode(model.billingPostalCode);
            billingProvince(model.billingProvince);
            billingState(model.billingState);
            birthDate(model.birthDate);
            businessEmailAddress(model.businessEmailAddress);
            businessName(model.businessName);
            businessPhoneNumber(model.businessPhoneNumber);
            city(model.city);
            country(model.country);
            county(model.county);
            custom(model.custom);
            emailAddress(model.emailAddress);
            firstName(model.firstName);
            gender(model.gender);
            homePhoneNumber(model.homePhoneNumber);
            lastName(model.lastName);
            mailingAddress1(model.mailingAddress1);
            mailingAddress2(model.mailingAddress2);
            mailingAddress3(model.mailingAddress3);
            mailingAddress4(model.mailingAddress4);
            mailingCity(model.mailingCity);
            mailingCountry(model.mailingCountry);
            mailingCounty(model.mailingCounty);
            mailingPostalCode(model.mailingPostalCode);
            mailingProvince(model.mailingProvince);
            mailingState(model.mailingState);
            middleName(model.middleName);
            mobilePhoneNumber(model.mobilePhoneNumber);
            partyType(model.partyType);
            phoneNumber(model.phoneNumber);
            postalCode(model.postalCode);
            profileARN(model.profileARN);
            profileId(model.profileId);
            province(model.province);
            shippingAddress1(model.shippingAddress1);
            shippingAddress2(model.shippingAddress2);
            shippingAddress3(model.shippingAddress3);
            shippingAddress4(model.shippingAddress4);
            shippingCity(model.shippingCity);
            shippingCountry(model.shippingCountry);
            shippingCounty(model.shippingCounty);
            shippingPostalCode(model.shippingPostalCode);
            shippingProvince(model.shippingProvince);
            shippingState(model.shippingState);
            state(model.state);
        }

        public final String getAccountNumber() {
            return accountNumber;
        }

        public final void setAccountNumber(String accountNumber) {
            this.accountNumber = accountNumber;
        }

        @Override
        public final Builder accountNumber(String accountNumber) {
            this.accountNumber = accountNumber;
            return this;
        }

        public final String getAdditionalInformation() {
            return additionalInformation;
        }

        public final void setAdditionalInformation(String additionalInformation) {
            this.additionalInformation = additionalInformation;
        }

        @Override
        public final Builder additionalInformation(String additionalInformation) {
            this.additionalInformation = additionalInformation;
            return this;
        }

        public final String getAddress1() {
            return address1;
        }

        public final void setAddress1(String address1) {
            this.address1 = address1;
        }

        @Override
        public final Builder address1(String address1) {
            this.address1 = address1;
            return this;
        }

        public final String getAddress2() {
            return address2;
        }

        public final void setAddress2(String address2) {
            this.address2 = address2;
        }

        @Override
        public final Builder address2(String address2) {
            this.address2 = address2;
            return this;
        }

        public final String getAddress3() {
            return address3;
        }

        public final void setAddress3(String address3) {
            this.address3 = address3;
        }

        @Override
        public final Builder address3(String address3) {
            this.address3 = address3;
            return this;
        }

        public final String getAddress4() {
            return address4;
        }

        public final void setAddress4(String address4) {
            this.address4 = address4;
        }

        @Override
        public final Builder address4(String address4) {
            this.address4 = address4;
            return this;
        }

        public final String getBillingAddress1() {
            return billingAddress1;
        }

        public final void setBillingAddress1(String billingAddress1) {
            this.billingAddress1 = billingAddress1;
        }

        @Override
        public final Builder billingAddress1(String billingAddress1) {
            this.billingAddress1 = billingAddress1;
            return this;
        }

        public final String getBillingAddress2() {
            return billingAddress2;
        }

        public final void setBillingAddress2(String billingAddress2) {
            this.billingAddress2 = billingAddress2;
        }

        @Override
        public final Builder billingAddress2(String billingAddress2) {
            this.billingAddress2 = billingAddress2;
            return this;
        }

        public final String getBillingAddress3() {
            return billingAddress3;
        }

        public final void setBillingAddress3(String billingAddress3) {
            this.billingAddress3 = billingAddress3;
        }

        @Override
        public final Builder billingAddress3(String billingAddress3) {
            this.billingAddress3 = billingAddress3;
            return this;
        }

        public final String getBillingAddress4() {
            return billingAddress4;
        }

        public final void setBillingAddress4(String billingAddress4) {
            this.billingAddress4 = billingAddress4;
        }

        @Override
        public final Builder billingAddress4(String billingAddress4) {
            this.billingAddress4 = billingAddress4;
            return this;
        }

        public final String getBillingCity() {
            return billingCity;
        }

        public final void setBillingCity(String billingCity) {
            this.billingCity = billingCity;
        }

        @Override
        public final Builder billingCity(String billingCity) {
            this.billingCity = billingCity;
            return this;
        }

        public final String getBillingCountry() {
            return billingCountry;
        }

        public final void setBillingCountry(String billingCountry) {
            this.billingCountry = billingCountry;
        }

        @Override
        public final Builder billingCountry(String billingCountry) {
            this.billingCountry = billingCountry;
            return this;
        }

        public final String getBillingCounty() {
            return billingCounty;
        }

        public final void setBillingCounty(String billingCounty) {
            this.billingCounty = billingCounty;
        }

        @Override
        public final Builder billingCounty(String billingCounty) {
            this.billingCounty = billingCounty;
            return this;
        }

        public final String getBillingPostalCode() {
            return billingPostalCode;
        }

        public final void setBillingPostalCode(String billingPostalCode) {
            this.billingPostalCode = billingPostalCode;
        }

        @Override
        public final Builder billingPostalCode(String billingPostalCode) {
            this.billingPostalCode = billingPostalCode;
            return this;
        }

        public final String getBillingProvince() {
            return billingProvince;
        }

        public final void setBillingProvince(String billingProvince) {
            this.billingProvince = billingProvince;
        }

        @Override
        public final Builder billingProvince(String billingProvince) {
            this.billingProvince = billingProvince;
            return this;
        }

        public final String getBillingState() {
            return billingState;
        }

        public final void setBillingState(String billingState) {
            this.billingState = billingState;
        }

        @Override
        public final Builder billingState(String billingState) {
            this.billingState = billingState;
            return this;
        }

        public final String getBirthDate() {
            return birthDate;
        }

        public final void setBirthDate(String birthDate) {
            this.birthDate = birthDate;
        }

        @Override
        public final Builder birthDate(String birthDate) {
            this.birthDate = birthDate;
            return this;
        }

        public final String getBusinessEmailAddress() {
            return businessEmailAddress;
        }

        public final void setBusinessEmailAddress(String businessEmailAddress) {
            this.businessEmailAddress = businessEmailAddress;
        }

        @Override
        public final Builder businessEmailAddress(String businessEmailAddress) {
            this.businessEmailAddress = businessEmailAddress;
            return this;
        }

        public final String getBusinessName() {
            return businessName;
        }

        public final void setBusinessName(String businessName) {
            this.businessName = businessName;
        }

        @Override
        public final Builder businessName(String businessName) {
            this.businessName = businessName;
            return this;
        }

        public final String getBusinessPhoneNumber() {
            return businessPhoneNumber;
        }

        public final void setBusinessPhoneNumber(String businessPhoneNumber) {
            this.businessPhoneNumber = businessPhoneNumber;
        }

        @Override
        public final Builder businessPhoneNumber(String businessPhoneNumber) {
            this.businessPhoneNumber = businessPhoneNumber;
            return this;
        }

        public final String getCity() {
            return city;
        }

        public final void setCity(String city) {
            this.city = city;
        }

        @Override
        public final Builder city(String city) {
            this.city = city;
            return this;
        }

        public final String getCountry() {
            return country;
        }

        public final void setCountry(String country) {
            this.country = country;
        }

        @Override
        public final Builder country(String country) {
            this.country = country;
            return this;
        }

        public final String getCounty() {
            return county;
        }

        public final void setCounty(String county) {
            this.county = county;
        }

        @Override
        public final Builder county(String county) {
            this.county = county;
            return this;
        }

        public final Map<String, String> getCustom() {
            if (custom instanceof SdkAutoConstructMap) {
                return null;
            }
            return custom;
        }

        public final void setCustom(Map<String, String> custom) {
            this.custom = CustomAttributesCopier.copy(custom);
        }

        @Override
        public final Builder custom(Map<String, String> custom) {
            this.custom = CustomAttributesCopier.copy(custom);
            return this;
        }

        public final String getEmailAddress() {
            return emailAddress;
        }

        public final void setEmailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
        }

        @Override
        public final Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public final String getFirstName() {
            return firstName;
        }

        public final void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        @Override
        public final Builder firstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public final String getGender() {
            return gender;
        }

        public final void setGender(String gender) {
            this.gender = gender;
        }

        @Override
        public final Builder gender(String gender) {
            this.gender = gender;
            return this;
        }

        public final String getHomePhoneNumber() {
            return homePhoneNumber;
        }

        public final void setHomePhoneNumber(String homePhoneNumber) {
            this.homePhoneNumber = homePhoneNumber;
        }

        @Override
        public final Builder homePhoneNumber(String homePhoneNumber) {
            this.homePhoneNumber = homePhoneNumber;
            return this;
        }

        public final String getLastName() {
            return lastName;
        }

        public final void setLastName(String lastName) {
            this.lastName = lastName;
        }

        @Override
        public final Builder lastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public final String getMailingAddress1() {
            return mailingAddress1;
        }

        public final void setMailingAddress1(String mailingAddress1) {
            this.mailingAddress1 = mailingAddress1;
        }

        @Override
        public final Builder mailingAddress1(String mailingAddress1) {
            this.mailingAddress1 = mailingAddress1;
            return this;
        }

        public final String getMailingAddress2() {
            return mailingAddress2;
        }

        public final void setMailingAddress2(String mailingAddress2) {
            this.mailingAddress2 = mailingAddress2;
        }

        @Override
        public final Builder mailingAddress2(String mailingAddress2) {
            this.mailingAddress2 = mailingAddress2;
            return this;
        }

        public final String getMailingAddress3() {
            return mailingAddress3;
        }

        public final void setMailingAddress3(String mailingAddress3) {
            this.mailingAddress3 = mailingAddress3;
        }

        @Override
        public final Builder mailingAddress3(String mailingAddress3) {
            this.mailingAddress3 = mailingAddress3;
            return this;
        }

        public final String getMailingAddress4() {
            return mailingAddress4;
        }

        public final void setMailingAddress4(String mailingAddress4) {
            this.mailingAddress4 = mailingAddress4;
        }

        @Override
        public final Builder mailingAddress4(String mailingAddress4) {
            this.mailingAddress4 = mailingAddress4;
            return this;
        }

        public final String getMailingCity() {
            return mailingCity;
        }

        public final void setMailingCity(String mailingCity) {
            this.mailingCity = mailingCity;
        }

        @Override
        public final Builder mailingCity(String mailingCity) {
            this.mailingCity = mailingCity;
            return this;
        }

        public final String getMailingCountry() {
            return mailingCountry;
        }

        public final void setMailingCountry(String mailingCountry) {
            this.mailingCountry = mailingCountry;
        }

        @Override
        public final Builder mailingCountry(String mailingCountry) {
            this.mailingCountry = mailingCountry;
            return this;
        }

        public final String getMailingCounty() {
            return mailingCounty;
        }

        public final void setMailingCounty(String mailingCounty) {
            this.mailingCounty = mailingCounty;
        }

        @Override
        public final Builder mailingCounty(String mailingCounty) {
            this.mailingCounty = mailingCounty;
            return this;
        }

        public final String getMailingPostalCode() {
            return mailingPostalCode;
        }

        public final void setMailingPostalCode(String mailingPostalCode) {
            this.mailingPostalCode = mailingPostalCode;
        }

        @Override
        public final Builder mailingPostalCode(String mailingPostalCode) {
            this.mailingPostalCode = mailingPostalCode;
            return this;
        }

        public final String getMailingProvince() {
            return mailingProvince;
        }

        public final void setMailingProvince(String mailingProvince) {
            this.mailingProvince = mailingProvince;
        }

        @Override
        public final Builder mailingProvince(String mailingProvince) {
            this.mailingProvince = mailingProvince;
            return this;
        }

        public final String getMailingState() {
            return mailingState;
        }

        public final void setMailingState(String mailingState) {
            this.mailingState = mailingState;
        }

        @Override
        public final Builder mailingState(String mailingState) {
            this.mailingState = mailingState;
            return this;
        }

        public final String getMiddleName() {
            return middleName;
        }

        public final void setMiddleName(String middleName) {
            this.middleName = middleName;
        }

        @Override
        public final Builder middleName(String middleName) {
            this.middleName = middleName;
            return this;
        }

        public final String getMobilePhoneNumber() {
            return mobilePhoneNumber;
        }

        public final void setMobilePhoneNumber(String mobilePhoneNumber) {
            this.mobilePhoneNumber = mobilePhoneNumber;
        }

        @Override
        public final Builder mobilePhoneNumber(String mobilePhoneNumber) {
            this.mobilePhoneNumber = mobilePhoneNumber;
            return this;
        }

        public final String getPartyType() {
            return partyType;
        }

        public final void setPartyType(String partyType) {
            this.partyType = partyType;
        }

        @Override
        public final Builder partyType(String partyType) {
            this.partyType = partyType;
            return this;
        }

        public final String getPhoneNumber() {
            return phoneNumber;
        }

        public final void setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        @Override
        public final Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public final String getPostalCode() {
            return postalCode;
        }

        public final void setPostalCode(String postalCode) {
            this.postalCode = postalCode;
        }

        @Override
        public final Builder postalCode(String postalCode) {
            this.postalCode = postalCode;
            return this;
        }

        public final String getProfileARN() {
            return profileARN;
        }

        public final void setProfileARN(String profileARN) {
            this.profileARN = profileARN;
        }

        @Override
        public final Builder profileARN(String profileARN) {
            this.profileARN = profileARN;
            return this;
        }

        public final String getProfileId() {
            return profileId;
        }

        public final void setProfileId(String profileId) {
            this.profileId = profileId;
        }

        @Override
        public final Builder profileId(String profileId) {
            this.profileId = profileId;
            return this;
        }

        public final String getProvince() {
            return province;
        }

        public final void setProvince(String province) {
            this.province = province;
        }

        @Override
        public final Builder province(String province) {
            this.province = province;
            return this;
        }

        public final String getShippingAddress1() {
            return shippingAddress1;
        }

        public final void setShippingAddress1(String shippingAddress1) {
            this.shippingAddress1 = shippingAddress1;
        }

        @Override
        public final Builder shippingAddress1(String shippingAddress1) {
            this.shippingAddress1 = shippingAddress1;
            return this;
        }

        public final String getShippingAddress2() {
            return shippingAddress2;
        }

        public final void setShippingAddress2(String shippingAddress2) {
            this.shippingAddress2 = shippingAddress2;
        }

        @Override
        public final Builder shippingAddress2(String shippingAddress2) {
            this.shippingAddress2 = shippingAddress2;
            return this;
        }

        public final String getShippingAddress3() {
            return shippingAddress3;
        }

        public final void setShippingAddress3(String shippingAddress3) {
            this.shippingAddress3 = shippingAddress3;
        }

        @Override
        public final Builder shippingAddress3(String shippingAddress3) {
            this.shippingAddress3 = shippingAddress3;
            return this;
        }

        public final String getShippingAddress4() {
            return shippingAddress4;
        }

        public final void setShippingAddress4(String shippingAddress4) {
            this.shippingAddress4 = shippingAddress4;
        }

        @Override
        public final Builder shippingAddress4(String shippingAddress4) {
            this.shippingAddress4 = shippingAddress4;
            return this;
        }

        public final String getShippingCity() {
            return shippingCity;
        }

        public final void setShippingCity(String shippingCity) {
            this.shippingCity = shippingCity;
        }

        @Override
        public final Builder shippingCity(String shippingCity) {
            this.shippingCity = shippingCity;
            return this;
        }

        public final String getShippingCountry() {
            return shippingCountry;
        }

        public final void setShippingCountry(String shippingCountry) {
            this.shippingCountry = shippingCountry;
        }

        @Override
        public final Builder shippingCountry(String shippingCountry) {
            this.shippingCountry = shippingCountry;
            return this;
        }

        public final String getShippingCounty() {
            return shippingCounty;
        }

        public final void setShippingCounty(String shippingCounty) {
            this.shippingCounty = shippingCounty;
        }

        @Override
        public final Builder shippingCounty(String shippingCounty) {
            this.shippingCounty = shippingCounty;
            return this;
        }

        public final String getShippingPostalCode() {
            return shippingPostalCode;
        }

        public final void setShippingPostalCode(String shippingPostalCode) {
            this.shippingPostalCode = shippingPostalCode;
        }

        @Override
        public final Builder shippingPostalCode(String shippingPostalCode) {
            this.shippingPostalCode = shippingPostalCode;
            return this;
        }

        public final String getShippingProvince() {
            return shippingProvince;
        }

        public final void setShippingProvince(String shippingProvince) {
            this.shippingProvince = shippingProvince;
        }

        @Override
        public final Builder shippingProvince(String shippingProvince) {
            this.shippingProvince = shippingProvince;
            return this;
        }

        public final String getShippingState() {
            return shippingState;
        }

        public final void setShippingState(String shippingState) {
            this.shippingState = shippingState;
        }

        @Override
        public final Builder shippingState(String shippingState) {
            this.shippingState = shippingState;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public CustomerProfileAttributes build() {
            return new CustomerProfileAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
