/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The summary of the AI Guardrail.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AIGuardrailSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<AIGuardrailSummary.Builder, AIGuardrailSummary> {
    private static final SdkField<String> AI_GUARDRAIL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("aiGuardrailArn").getter(getter(AIGuardrailSummary::aiGuardrailArn))
            .setter(setter(Builder::aiGuardrailArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aiGuardrailArn").build()).build();

    private static final SdkField<String> AI_GUARDRAIL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("aiGuardrailId").getter(getter(AIGuardrailSummary::aiGuardrailId)).setter(setter(Builder::aiGuardrailId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aiGuardrailId").build()).build();

    private static final SdkField<String> ASSISTANT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assistantArn").getter(getter(AIGuardrailSummary::assistantArn)).setter(setter(Builder::assistantArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assistantArn").build()).build();

    private static final SdkField<String> ASSISTANT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assistantId").getter(getter(AIGuardrailSummary::assistantId)).setter(setter(Builder::assistantId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assistantId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(AIGuardrailSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Instant> MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("modifiedTime").getter(getter(AIGuardrailSummary::modifiedTime)).setter(setter(Builder::modifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modifiedTime").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(AIGuardrailSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(AIGuardrailSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(AIGuardrailSummary::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> VISIBILITY_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("visibilityStatus").getter(getter(AIGuardrailSummary::visibilityStatusAsString))
            .setter(setter(Builder::visibilityStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("visibilityStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AI_GUARDRAIL_ARN_FIELD,
            AI_GUARDRAIL_ID_FIELD, ASSISTANT_ARN_FIELD, ASSISTANT_ID_FIELD, DESCRIPTION_FIELD, MODIFIED_TIME_FIELD, NAME_FIELD,
            STATUS_FIELD, TAGS_FIELD, VISIBILITY_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String aiGuardrailArn;

    private final String aiGuardrailId;

    private final String assistantArn;

    private final String assistantId;

    private final String description;

    private final Instant modifiedTime;

    private final String name;

    private final String status;

    private final Map<String, String> tags;

    private final String visibilityStatus;

    private AIGuardrailSummary(BuilderImpl builder) {
        this.aiGuardrailArn = builder.aiGuardrailArn;
        this.aiGuardrailId = builder.aiGuardrailId;
        this.assistantArn = builder.assistantArn;
        this.assistantId = builder.assistantId;
        this.description = builder.description;
        this.modifiedTime = builder.modifiedTime;
        this.name = builder.name;
        this.status = builder.status;
        this.tags = builder.tags;
        this.visibilityStatus = builder.visibilityStatus;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the AI Guardrail.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the AI Guardrail.
     */
    public final String aiGuardrailArn() {
        return aiGuardrailArn;
    }

    /**
     * <p>
     * The identifier of the Amazon Q in Connect AI Guardrail.
     * </p>
     * 
     * @return The identifier of the Amazon Q in Connect AI Guardrail.
     */
    public final String aiGuardrailId() {
        return aiGuardrailId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon Q in Connect assistant.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon Q in Connect assistant.
     */
    public final String assistantArn() {
        return assistantArn;
    }

    /**
     * <p>
     * The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain the
     * ARN.
     * </p>
     * 
     * @return The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain
     *         the ARN.
     */
    public final String assistantId() {
        return assistantId;
    }

    /**
     * <p>
     * A description of the AI Guardrail.
     * </p>
     * 
     * @return A description of the AI Guardrail.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The time the AI Guardrail was last modified.
     * </p>
     * 
     * @return The time the AI Guardrail was last modified.
     */
    public final Instant modifiedTime() {
        return modifiedTime;
    }

    /**
     * <p>
     * The name of the AI Guardrail.
     * </p>
     * 
     * @return The name of the AI Guardrail.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The status of the AI Guardrail.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the AI Guardrail.
     * @see Status
     */
    public final Status status() {
        return Status.fromValue(status);
    }

    /**
     * <p>
     * The status of the AI Guardrail.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the AI Guardrail.
     * @see Status
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags used to organize, track, or control access for this resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags used to organize, track, or control access for this resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The visibility status of the AI Guardrail.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibilityStatus}
     * will return {@link VisibilityStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #visibilityStatusAsString}.
     * </p>
     * 
     * @return The visibility status of the AI Guardrail.
     * @see VisibilityStatus
     */
    public final VisibilityStatus visibilityStatus() {
        return VisibilityStatus.fromValue(visibilityStatus);
    }

    /**
     * <p>
     * The visibility status of the AI Guardrail.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibilityStatus}
     * will return {@link VisibilityStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #visibilityStatusAsString}.
     * </p>
     * 
     * @return The visibility status of the AI Guardrail.
     * @see VisibilityStatus
     */
    public final String visibilityStatusAsString() {
        return visibilityStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(aiGuardrailArn());
        hashCode = 31 * hashCode + Objects.hashCode(aiGuardrailId());
        hashCode = 31 * hashCode + Objects.hashCode(assistantArn());
        hashCode = 31 * hashCode + Objects.hashCode(assistantId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(modifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(visibilityStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AIGuardrailSummary)) {
            return false;
        }
        AIGuardrailSummary other = (AIGuardrailSummary) obj;
        return Objects.equals(aiGuardrailArn(), other.aiGuardrailArn()) && Objects.equals(aiGuardrailId(), other.aiGuardrailId())
                && Objects.equals(assistantArn(), other.assistantArn()) && Objects.equals(assistantId(), other.assistantId())
                && Objects.equals(description(), other.description()) && Objects.equals(modifiedTime(), other.modifiedTime())
                && Objects.equals(name(), other.name()) && Objects.equals(statusAsString(), other.statusAsString())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(visibilityStatusAsString(), other.visibilityStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AIGuardrailSummary").add("AiGuardrailArn", aiGuardrailArn())
                .add("AiGuardrailId", aiGuardrailId()).add("AssistantArn", assistantArn()).add("AssistantId", assistantId())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ModifiedTime", modifiedTime()).add("Name", name()).add("Status", statusAsString())
                .add("Tags", hasTags() ? tags() : null).add("VisibilityStatus", visibilityStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "aiGuardrailArn":
            return Optional.ofNullable(clazz.cast(aiGuardrailArn()));
        case "aiGuardrailId":
            return Optional.ofNullable(clazz.cast(aiGuardrailId()));
        case "assistantArn":
            return Optional.ofNullable(clazz.cast(assistantArn()));
        case "assistantId":
            return Optional.ofNullable(clazz.cast(assistantId()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "modifiedTime":
            return Optional.ofNullable(clazz.cast(modifiedTime()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "visibilityStatus":
            return Optional.ofNullable(clazz.cast(visibilityStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("aiGuardrailArn", AI_GUARDRAIL_ARN_FIELD);
        map.put("aiGuardrailId", AI_GUARDRAIL_ID_FIELD);
        map.put("assistantArn", ASSISTANT_ARN_FIELD);
        map.put("assistantId", ASSISTANT_ID_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("modifiedTime", MODIFIED_TIME_FIELD);
        map.put("name", NAME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("visibilityStatus", VISIBILITY_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AIGuardrailSummary, T> g) {
        return obj -> g.apply((AIGuardrailSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AIGuardrailSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the AI Guardrail.
         * </p>
         * 
         * @param aiGuardrailArn
         *        The Amazon Resource Name (ARN) of the AI Guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aiGuardrailArn(String aiGuardrailArn);

        /**
         * <p>
         * The identifier of the Amazon Q in Connect AI Guardrail.
         * </p>
         * 
         * @param aiGuardrailId
         *        The identifier of the Amazon Q in Connect AI Guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aiGuardrailId(String aiGuardrailId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon Q in Connect assistant.
         * </p>
         * 
         * @param assistantArn
         *        The Amazon Resource Name (ARN) of the Amazon Q in Connect assistant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assistantArn(String assistantArn);

        /**
         * <p>
         * The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain the
         * ARN.
         * </p>
         * 
         * @param assistantId
         *        The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot
         *        contain the ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assistantId(String assistantId);

        /**
         * <p>
         * A description of the AI Guardrail.
         * </p>
         * 
         * @param description
         *        A description of the AI Guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The time the AI Guardrail was last modified.
         * </p>
         * 
         * @param modifiedTime
         *        The time the AI Guardrail was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modifiedTime(Instant modifiedTime);

        /**
         * <p>
         * The name of the AI Guardrail.
         * </p>
         * 
         * @param name
         *        The name of the AI Guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The status of the AI Guardrail.
         * </p>
         * 
         * @param status
         *        The status of the AI Guardrail.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the AI Guardrail.
         * </p>
         * 
         * @param status
         *        The status of the AI Guardrail.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(Status status);

        /**
         * <p>
         * The tags used to organize, track, or control access for this resource.
         * </p>
         * 
         * @param tags
         *        The tags used to organize, track, or control access for this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The visibility status of the AI Guardrail.
         * </p>
         * 
         * @param visibilityStatus
         *        The visibility status of the AI Guardrail.
         * @see VisibilityStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VisibilityStatus
         */
        Builder visibilityStatus(String visibilityStatus);

        /**
         * <p>
         * The visibility status of the AI Guardrail.
         * </p>
         * 
         * @param visibilityStatus
         *        The visibility status of the AI Guardrail.
         * @see VisibilityStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VisibilityStatus
         */
        Builder visibilityStatus(VisibilityStatus visibilityStatus);
    }

    static final class BuilderImpl implements Builder {
        private String aiGuardrailArn;

        private String aiGuardrailId;

        private String assistantArn;

        private String assistantId;

        private String description;

        private Instant modifiedTime;

        private String name;

        private String status;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String visibilityStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(AIGuardrailSummary model) {
            aiGuardrailArn(model.aiGuardrailArn);
            aiGuardrailId(model.aiGuardrailId);
            assistantArn(model.assistantArn);
            assistantId(model.assistantId);
            description(model.description);
            modifiedTime(model.modifiedTime);
            name(model.name);
            status(model.status);
            tags(model.tags);
            visibilityStatus(model.visibilityStatus);
        }

        public final String getAiGuardrailArn() {
            return aiGuardrailArn;
        }

        public final void setAiGuardrailArn(String aiGuardrailArn) {
            this.aiGuardrailArn = aiGuardrailArn;
        }

        @Override
        public final Builder aiGuardrailArn(String aiGuardrailArn) {
            this.aiGuardrailArn = aiGuardrailArn;
            return this;
        }

        public final String getAiGuardrailId() {
            return aiGuardrailId;
        }

        public final void setAiGuardrailId(String aiGuardrailId) {
            this.aiGuardrailId = aiGuardrailId;
        }

        @Override
        public final Builder aiGuardrailId(String aiGuardrailId) {
            this.aiGuardrailId = aiGuardrailId;
            return this;
        }

        public final String getAssistantArn() {
            return assistantArn;
        }

        public final void setAssistantArn(String assistantArn) {
            this.assistantArn = assistantArn;
        }

        @Override
        public final Builder assistantArn(String assistantArn) {
            this.assistantArn = assistantArn;
            return this;
        }

        public final String getAssistantId() {
            return assistantId;
        }

        public final void setAssistantId(String assistantId) {
            this.assistantId = assistantId;
        }

        @Override
        public final Builder assistantId(String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getModifiedTime() {
            return modifiedTime;
        }

        public final void setModifiedTime(Instant modifiedTime) {
            this.modifiedTime = modifiedTime;
        }

        @Override
        public final Builder modifiedTime(Instant modifiedTime) {
            this.modifiedTime = modifiedTime;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final String getVisibilityStatus() {
            return visibilityStatus;
        }

        public final void setVisibilityStatus(String visibilityStatus) {
            this.visibilityStatus = visibilityStatus;
        }

        @Override
        public final Builder visibilityStatus(String visibilityStatus) {
            this.visibilityStatus = visibilityStatus;
            return this;
        }

        @Override
        public final Builder visibilityStatus(VisibilityStatus visibilityStatus) {
            this.visibilityStatus(visibilityStatus == null ? null : visibilityStatus.toString());
            return this;
        }

        @Override
        public AIGuardrailSummary build() {
            return new AIGuardrailSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
