/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The document.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Document implements SdkPojo, Serializable, ToCopyableBuilder<Document.Builder, Document> {
    private static final SdkField<ContentReference> CONTENT_REFERENCE_FIELD = SdkField
            .<ContentReference> builder(MarshallingType.SDK_POJO).memberName("contentReference")
            .getter(getter(Document::contentReference)).setter(setter(Builder::contentReference))
            .constructor(ContentReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentReference").build()).build();

    private static final SdkField<DocumentText> EXCERPT_FIELD = SdkField.<DocumentText> builder(MarshallingType.SDK_POJO)
            .memberName("excerpt").getter(getter(Document::excerpt)).setter(setter(Builder::excerpt))
            .constructor(DocumentText::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("excerpt").build()).build();

    private static final SdkField<DocumentText> TITLE_FIELD = SdkField.<DocumentText> builder(MarshallingType.SDK_POJO)
            .memberName("title").getter(getter(Document::title)).setter(setter(Builder::title))
            .constructor(DocumentText::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_REFERENCE_FIELD,
            EXCERPT_FIELD, TITLE_FIELD));

    private static final long serialVersionUID = 1L;

    private final ContentReference contentReference;

    private final DocumentText excerpt;

    private final DocumentText title;

    private Document(BuilderImpl builder) {
        this.contentReference = builder.contentReference;
        this.excerpt = builder.excerpt;
        this.title = builder.title;
    }

    /**
     * <p>
     * A reference to the content resource.
     * </p>
     * 
     * @return A reference to the content resource.
     */
    public final ContentReference contentReference() {
        return contentReference;
    }

    /**
     * <p>
     * The excerpt from the document.
     * </p>
     * 
     * @return The excerpt from the document.
     */
    public final DocumentText excerpt() {
        return excerpt;
    }

    /**
     * <p>
     * The title of the document.
     * </p>
     * 
     * @return The title of the document.
     */
    public final DocumentText title() {
        return title;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(contentReference());
        hashCode = 31 * hashCode + Objects.hashCode(excerpt());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Document)) {
            return false;
        }
        Document other = (Document) obj;
        return Objects.equals(contentReference(), other.contentReference()) && Objects.equals(excerpt(), other.excerpt())
                && Objects.equals(title(), other.title());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Document").add("ContentReference", contentReference()).add("Excerpt", excerpt())
                .add("Title", title()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "contentReference":
            return Optional.ofNullable(clazz.cast(contentReference()));
        case "excerpt":
            return Optional.ofNullable(clazz.cast(excerpt()));
        case "title":
            return Optional.ofNullable(clazz.cast(title()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Document, T> g) {
        return obj -> g.apply((Document) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Document> {
        /**
         * <p>
         * A reference to the content resource.
         * </p>
         * 
         * @param contentReference
         *        A reference to the content resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentReference(ContentReference contentReference);

        /**
         * <p>
         * A reference to the content resource.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContentReference.Builder} avoiding the
         * need to create one manually via {@link ContentReference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContentReference.Builder#build()} is called immediately and its
         * result is passed to {@link #contentReference(ContentReference)}.
         * 
         * @param contentReference
         *        a consumer that will call methods on {@link ContentReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contentReference(ContentReference)
         */
        default Builder contentReference(Consumer<ContentReference.Builder> contentReference) {
            return contentReference(ContentReference.builder().applyMutation(contentReference).build());
        }

        /**
         * <p>
         * The excerpt from the document.
         * </p>
         * 
         * @param excerpt
         *        The excerpt from the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excerpt(DocumentText excerpt);

        /**
         * <p>
         * The excerpt from the document.
         * </p>
         * This is a convenience method that creates an instance of the {@link DocumentText.Builder} avoiding the need
         * to create one manually via {@link DocumentText#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DocumentText.Builder#build()} is called immediately and its
         * result is passed to {@link #excerpt(DocumentText)}.
         * 
         * @param excerpt
         *        a consumer that will call methods on {@link DocumentText.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #excerpt(DocumentText)
         */
        default Builder excerpt(Consumer<DocumentText.Builder> excerpt) {
            return excerpt(DocumentText.builder().applyMutation(excerpt).build());
        }

        /**
         * <p>
         * The title of the document.
         * </p>
         * 
         * @param title
         *        The title of the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(DocumentText title);

        /**
         * <p>
         * The title of the document.
         * </p>
         * This is a convenience method that creates an instance of the {@link DocumentText.Builder} avoiding the need
         * to create one manually via {@link DocumentText#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DocumentText.Builder#build()} is called immediately and its
         * result is passed to {@link #title(DocumentText)}.
         * 
         * @param title
         *        a consumer that will call methods on {@link DocumentText.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #title(DocumentText)
         */
        default Builder title(Consumer<DocumentText.Builder> title) {
            return title(DocumentText.builder().applyMutation(title).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ContentReference contentReference;

        private DocumentText excerpt;

        private DocumentText title;

        private BuilderImpl() {
        }

        private BuilderImpl(Document model) {
            contentReference(model.contentReference);
            excerpt(model.excerpt);
            title(model.title);
        }

        public final ContentReference.Builder getContentReference() {
            return contentReference != null ? contentReference.toBuilder() : null;
        }

        public final void setContentReference(ContentReference.BuilderImpl contentReference) {
            this.contentReference = contentReference != null ? contentReference.build() : null;
        }

        @Override
        public final Builder contentReference(ContentReference contentReference) {
            this.contentReference = contentReference;
            return this;
        }

        public final DocumentText.Builder getExcerpt() {
            return excerpt != null ? excerpt.toBuilder() : null;
        }

        public final void setExcerpt(DocumentText.BuilderImpl excerpt) {
            this.excerpt = excerpt != null ? excerpt.build() : null;
        }

        @Override
        public final Builder excerpt(DocumentText excerpt) {
            this.excerpt = excerpt;
            return this;
        }

        public final DocumentText.Builder getTitle() {
            return title != null ? title.toBuilder() : null;
        }

        public final void setTitle(DocumentText.BuilderImpl title) {
            this.title = title != null ? title.build() : null;
        }

        @Override
        public final Builder title(DocumentText title) {
            this.title = title;
            return this;
        }

        @Override
        public Document build() {
            return new Document(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
