/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateQuickResponseResponse extends QConnectResponse implements
        ToCopyableBuilder<CreateQuickResponseResponse.Builder, CreateQuickResponseResponse> {
    private static final SdkField<QuickResponseData> QUICK_RESPONSE_FIELD = SdkField
            .<QuickResponseData> builder(MarshallingType.SDK_POJO).memberName("quickResponse")
            .getter(getter(CreateQuickResponseResponse::quickResponse)).setter(setter(Builder::quickResponse))
            .constructor(QuickResponseData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("quickResponse").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUICK_RESPONSE_FIELD));

    private final QuickResponseData quickResponse;

    private CreateQuickResponseResponse(BuilderImpl builder) {
        super(builder);
        this.quickResponse = builder.quickResponse;
    }

    /**
     * <p>
     * The quick response.
     * </p>
     * 
     * @return The quick response.
     */
    public final QuickResponseData quickResponse() {
        return quickResponse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(quickResponse());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateQuickResponseResponse)) {
            return false;
        }
        CreateQuickResponseResponse other = (CreateQuickResponseResponse) obj;
        return Objects.equals(quickResponse(), other.quickResponse());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateQuickResponseResponse").add("QuickResponse", quickResponse()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "quickResponse":
            return Optional.ofNullable(clazz.cast(quickResponse()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateQuickResponseResponse, T> g) {
        return obj -> g.apply((CreateQuickResponseResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateQuickResponseResponse> {
        /**
         * <p>
         * The quick response.
         * </p>
         * 
         * @param quickResponse
         *        The quick response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quickResponse(QuickResponseData quickResponse);

        /**
         * <p>
         * The quick response.
         * </p>
         * This is a convenience method that creates an instance of the {@link QuickResponseData.Builder} avoiding the
         * need to create one manually via {@link QuickResponseData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link QuickResponseData.Builder#build()} is called immediately and its
         * result is passed to {@link #quickResponse(QuickResponseData)}.
         * 
         * @param quickResponse
         *        a consumer that will call methods on {@link QuickResponseData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #quickResponse(QuickResponseData)
         */
        default Builder quickResponse(Consumer<QuickResponseData.Builder> quickResponse) {
            return quickResponse(QuickResponseData.builder().applyMutation(quickResponse).build());
        }
    }

    static final class BuilderImpl extends QConnectResponse.BuilderImpl implements Builder {
        private QuickResponseData quickResponse;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateQuickResponseResponse model) {
            super(model);
            quickResponse(model.quickResponse);
        }

        public final QuickResponseData.Builder getQuickResponse() {
            return quickResponse != null ? quickResponse.toBuilder() : null;
        }

        public final void setQuickResponse(QuickResponseData.BuilderImpl quickResponse) {
            this.quickResponse = quickResponse != null ? quickResponse.build() : null;
        }

        @Override
        public final Builder quickResponse(QuickResponseData quickResponse) {
            this.quickResponse = quickResponse;
            return this;
        }

        @Override
        public CreateQuickResponseResponse build() {
            return new CreateQuickResponseResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
