/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.privatenetworks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a network resource definition.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkResourceDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<NetworkResourceDefinition.Builder, NetworkResourceDefinition> {
    private static final SdkField<Integer> COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("count")
            .getter(getter(NetworkResourceDefinition::count)).setter(setter(Builder::count))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("count").build()).build();

    private static final SdkField<List<NameValuePair>> OPTIONS_FIELD = SdkField
            .<List<NameValuePair>> builder(MarshallingType.LIST)
            .memberName("options")
            .getter(getter(NetworkResourceDefinition::options))
            .setter(setter(Builder::options))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("options").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NameValuePair> builder(MarshallingType.SDK_POJO)
                                            .constructor(NameValuePair::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(NetworkResourceDefinition::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COUNT_FIELD, OPTIONS_FIELD,
            TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer count;

    private final List<NameValuePair> options;

    private final String type;

    private NetworkResourceDefinition(BuilderImpl builder) {
        this.count = builder.count;
        this.options = builder.options;
        this.type = builder.type;
    }

    /**
     * <p>
     * The count in the network resource definition.
     * </p>
     * 
     * @return The count in the network resource definition.
     */
    public final Integer count() {
        return count;
    }

    /**
     * For responses, this returns true if the service returned a value for the Options property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOptions() {
        return options != null && !(options instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The options in the network resource definition.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOptions} method.
     * </p>
     * 
     * @return The options in the network resource definition.
     */
    public final List<NameValuePair> options() {
        return options;
    }

    /**
     * <p>
     * The type in the network resource definition.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link NetworkResourceDefinitionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return The type in the network resource definition.
     * @see NetworkResourceDefinitionType
     */
    public final NetworkResourceDefinitionType type() {
        return NetworkResourceDefinitionType.fromValue(type);
    }

    /**
     * <p>
     * The type in the network resource definition.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link NetworkResourceDefinitionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return The type in the network resource definition.
     * @see NetworkResourceDefinitionType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(count());
        hashCode = 31 * hashCode + Objects.hashCode(hasOptions() ? options() : null);
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkResourceDefinition)) {
            return false;
        }
        NetworkResourceDefinition other = (NetworkResourceDefinition) obj;
        return Objects.equals(count(), other.count()) && hasOptions() == other.hasOptions()
                && Objects.equals(options(), other.options()) && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NetworkResourceDefinition").add("Count", count())
                .add("Options", hasOptions() ? options() : null).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "count":
            return Optional.ofNullable(clazz.cast(count()));
        case "options":
            return Optional.ofNullable(clazz.cast(options()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("count", COUNT_FIELD);
        map.put("options", OPTIONS_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NetworkResourceDefinition, T> g) {
        return obj -> g.apply((NetworkResourceDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NetworkResourceDefinition> {
        /**
         * <p>
         * The count in the network resource definition.
         * </p>
         * 
         * @param count
         *        The count in the network resource definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder count(Integer count);

        /**
         * <p>
         * The options in the network resource definition.
         * </p>
         * 
         * @param options
         *        The options in the network resource definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder options(Collection<NameValuePair> options);

        /**
         * <p>
         * The options in the network resource definition.
         * </p>
         * 
         * @param options
         *        The options in the network resource definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder options(NameValuePair... options);

        /**
         * <p>
         * The options in the network resource definition.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.privatenetworks.model.NameValuePair.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.privatenetworks.model.NameValuePair#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.privatenetworks.model.NameValuePair.Builder#build()} is called
         * immediately and its result is passed to {@link #options(List<NameValuePair>)}.
         * 
         * @param options
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.privatenetworks.model.NameValuePair.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #options(java.util.Collection<NameValuePair>)
         */
        Builder options(Consumer<NameValuePair.Builder>... options);

        /**
         * <p>
         * The type in the network resource definition.
         * </p>
         * 
         * @param type
         *        The type in the network resource definition.
         * @see NetworkResourceDefinitionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkResourceDefinitionType
         */
        Builder type(String type);

        /**
         * <p>
         * The type in the network resource definition.
         * </p>
         * 
         * @param type
         *        The type in the network resource definition.
         * @see NetworkResourceDefinitionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkResourceDefinitionType
         */
        Builder type(NetworkResourceDefinitionType type);
    }

    static final class BuilderImpl implements Builder {
        private Integer count;

        private List<NameValuePair> options = DefaultSdkAutoConstructList.getInstance();

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkResourceDefinition model) {
            count(model.count);
            options(model.options);
            type(model.type);
        }

        public final Integer getCount() {
            return count;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final List<NameValuePair.Builder> getOptions() {
            List<NameValuePair.Builder> result = OptionsCopier.copyToBuilder(this.options);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOptions(Collection<NameValuePair.BuilderImpl> options) {
            this.options = OptionsCopier.copyFromBuilder(options);
        }

        @Override
        public final Builder options(Collection<NameValuePair> options) {
            this.options = OptionsCopier.copy(options);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder options(NameValuePair... options) {
            options(Arrays.asList(options));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder options(Consumer<NameValuePair.Builder>... options) {
            options(Stream.of(options).map(c -> NameValuePair.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(NetworkResourceDefinitionType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public NetworkResourceDefinition build() {
            return new NetworkResourceDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
