/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.privatenetworks.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum NetworkSiteStatus {
    CREATED("CREATED"),
    PROVISIONING("PROVISIONING"),
    AVAILABLE("AVAILABLE"),
    DEPROVISIONING("DEPROVISIONING"),
    DELETED("DELETED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, NetworkSiteStatus> VALUE_MAP;
    private final String value;

    private NetworkSiteStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static NetworkSiteStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<NetworkSiteStatus> knownValues() {
        EnumSet<NetworkSiteStatus> knownValues = EnumSet.allOf(NetworkSiteStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(NetworkSiteStatus.class, NetworkSiteStatus::toString);
    }
}

