/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.privatenetworks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a request to return a network resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReturnInformation implements SdkPojo, Serializable,
        ToCopyableBuilder<ReturnInformation.Builder, ReturnInformation> {
    private static final SdkField<String> REPLACEMENT_ORDER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("replacementOrderArn").getter(getter(ReturnInformation::replacementOrderArn))
            .setter(setter(Builder::replacementOrderArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replacementOrderArn").build())
            .build();

    private static final SdkField<String> RETURN_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("returnReason").getter(getter(ReturnInformation::returnReason)).setter(setter(Builder::returnReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("returnReason").build()).build();

    private static final SdkField<Address> SHIPPING_ADDRESS_FIELD = SdkField.<Address> builder(MarshallingType.SDK_POJO)
            .memberName("shippingAddress").getter(getter(ReturnInformation::shippingAddress))
            .setter(setter(Builder::shippingAddress)).constructor(Address::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shippingAddress").build()).build();

    private static final SdkField<String> SHIPPING_LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("shippingLabel").getter(getter(ReturnInformation::shippingLabel)).setter(setter(Builder::shippingLabel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shippingLabel").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLACEMENT_ORDER_ARN_FIELD,
            RETURN_REASON_FIELD, SHIPPING_ADDRESS_FIELD, SHIPPING_LABEL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String replacementOrderArn;

    private final String returnReason;

    private final Address shippingAddress;

    private final String shippingLabel;

    private ReturnInformation(BuilderImpl builder) {
        this.replacementOrderArn = builder.replacementOrderArn;
        this.returnReason = builder.returnReason;
        this.shippingAddress = builder.shippingAddress;
        this.shippingLabel = builder.shippingLabel;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the replacement order.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the replacement order.
     */
    public final String replacementOrderArn() {
        return replacementOrderArn;
    }

    /**
     * <p>
     * The reason for the return. If the return request did not include a reason for the return, this value is null.
     * </p>
     * 
     * @return The reason for the return. If the return request did not include a reason for the return, this value is
     *         null.
     */
    public final String returnReason() {
        return returnReason;
    }

    /**
     * <p>
     * The shipping address.
     * </p>
     * 
     * @return The shipping address.
     */
    public final Address shippingAddress() {
        return shippingAddress;
    }

    /**
     * <p>
     * The URL of the shipping label. The shipping label is available for download only if the status of the network
     * resource is <code>PENDING_RETURN</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/private-networks/latest/userguide/radio-units.html#return-radio-unit">Return a
     * radio unit</a>.
     * </p>
     * 
     * @return The URL of the shipping label. The shipping label is available for download only if the status of the
     *         network resource is <code>PENDING_RETURN</code>. For more information, see <a
     *         href="https://docs.aws.amazon.com/private-networks/latest/userguide/radio-units.html#return-radio-unit"
     *         >Return a radio unit</a>.
     */
    public final String shippingLabel() {
        return shippingLabel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(replacementOrderArn());
        hashCode = 31 * hashCode + Objects.hashCode(returnReason());
        hashCode = 31 * hashCode + Objects.hashCode(shippingAddress());
        hashCode = 31 * hashCode + Objects.hashCode(shippingLabel());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReturnInformation)) {
            return false;
        }
        ReturnInformation other = (ReturnInformation) obj;
        return Objects.equals(replacementOrderArn(), other.replacementOrderArn())
                && Objects.equals(returnReason(), other.returnReason())
                && Objects.equals(shippingAddress(), other.shippingAddress())
                && Objects.equals(shippingLabel(), other.shippingLabel());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReturnInformation").add("ReplacementOrderArn", replacementOrderArn())
                .add("ReturnReason", returnReason()).add("ShippingAddress", shippingAddress())
                .add("ShippingLabel", shippingLabel()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "replacementOrderArn":
            return Optional.ofNullable(clazz.cast(replacementOrderArn()));
        case "returnReason":
            return Optional.ofNullable(clazz.cast(returnReason()));
        case "shippingAddress":
            return Optional.ofNullable(clazz.cast(shippingAddress()));
        case "shippingLabel":
            return Optional.ofNullable(clazz.cast(shippingLabel()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("replacementOrderArn", REPLACEMENT_ORDER_ARN_FIELD);
        map.put("returnReason", RETURN_REASON_FIELD);
        map.put("shippingAddress", SHIPPING_ADDRESS_FIELD);
        map.put("shippingLabel", SHIPPING_LABEL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReturnInformation, T> g) {
        return obj -> g.apply((ReturnInformation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReturnInformation> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the replacement order.
         * </p>
         * 
         * @param replacementOrderArn
         *        The Amazon Resource Name (ARN) of the replacement order.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replacementOrderArn(String replacementOrderArn);

        /**
         * <p>
         * The reason for the return. If the return request did not include a reason for the return, this value is null.
         * </p>
         * 
         * @param returnReason
         *        The reason for the return. If the return request did not include a reason for the return, this value
         *        is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder returnReason(String returnReason);

        /**
         * <p>
         * The shipping address.
         * </p>
         * 
         * @param shippingAddress
         *        The shipping address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shippingAddress(Address shippingAddress);

        /**
         * <p>
         * The shipping address.
         * </p>
         * This is a convenience method that creates an instance of the {@link Address.Builder} avoiding the need to
         * create one manually via {@link Address#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Address.Builder#build()} is called immediately and its result is
         * passed to {@link #shippingAddress(Address)}.
         * 
         * @param shippingAddress
         *        a consumer that will call methods on {@link Address.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #shippingAddress(Address)
         */
        default Builder shippingAddress(Consumer<Address.Builder> shippingAddress) {
            return shippingAddress(Address.builder().applyMutation(shippingAddress).build());
        }

        /**
         * <p>
         * The URL of the shipping label. The shipping label is available for download only if the status of the network
         * resource is <code>PENDING_RETURN</code>. For more information, see <a
         * href="https://docs.aws.amazon.com/private-networks/latest/userguide/radio-units.html#return-radio-unit"
         * >Return a radio unit</a>.
         * </p>
         * 
         * @param shippingLabel
         *        The URL of the shipping label. The shipping label is available for download only if the status of the
         *        network resource is <code>PENDING_RETURN</code>. For more information, see <a
         *        href="https://docs.aws.amazon.com/private-networks/latest/userguide/radio-units.html#return-radio-unit"
         *        >Return a radio unit</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shippingLabel(String shippingLabel);
    }

    static final class BuilderImpl implements Builder {
        private String replacementOrderArn;

        private String returnReason;

        private Address shippingAddress;

        private String shippingLabel;

        private BuilderImpl() {
        }

        private BuilderImpl(ReturnInformation model) {
            replacementOrderArn(model.replacementOrderArn);
            returnReason(model.returnReason);
            shippingAddress(model.shippingAddress);
            shippingLabel(model.shippingLabel);
        }

        public final String getReplacementOrderArn() {
            return replacementOrderArn;
        }

        public final void setReplacementOrderArn(String replacementOrderArn) {
            this.replacementOrderArn = replacementOrderArn;
        }

        @Override
        public final Builder replacementOrderArn(String replacementOrderArn) {
            this.replacementOrderArn = replacementOrderArn;
            return this;
        }

        public final String getReturnReason() {
            return returnReason;
        }

        public final void setReturnReason(String returnReason) {
            this.returnReason = returnReason;
        }

        @Override
        public final Builder returnReason(String returnReason) {
            this.returnReason = returnReason;
            return this;
        }

        public final Address.Builder getShippingAddress() {
            return shippingAddress != null ? shippingAddress.toBuilder() : null;
        }

        public final void setShippingAddress(Address.BuilderImpl shippingAddress) {
            this.shippingAddress = shippingAddress != null ? shippingAddress.build() : null;
        }

        @Override
        public final Builder shippingAddress(Address shippingAddress) {
            this.shippingAddress = shippingAddress;
            return this;
        }

        public final String getShippingLabel() {
            return shippingLabel;
        }

        public final void setShippingLabel(String shippingLabel) {
            this.shippingLabel = shippingLabel;
        }

        @Override
        public final Builder shippingLabel(String shippingLabel) {
            this.shippingLabel = shippingLabel;
            return this;
        }

        @Override
        public ReturnInformation build() {
            return new ReturnInformation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
