/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.privatenetworks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a position.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Position implements SdkPojo, Serializable, ToCopyableBuilder<Position.Builder, Position> {
    private static final SdkField<Double> ELEVATION_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("elevation").getter(getter(Position::elevation)).setter(setter(Builder::elevation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("elevation").build()).build();

    private static final SdkField<String> ELEVATION_REFERENCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("elevationReference").getter(getter(Position::elevationReferenceAsString))
            .setter(setter(Builder::elevationReference))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("elevationReference").build())
            .build();

    private static final SdkField<String> ELEVATION_UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("elevationUnit").getter(getter(Position::elevationUnitAsString)).setter(setter(Builder::elevationUnit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("elevationUnit").build()).build();

    private static final SdkField<Double> LATITUDE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("latitude").getter(getter(Position::latitude)).setter(setter(Builder::latitude))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latitude").build()).build();

    private static final SdkField<Double> LONGITUDE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("longitude").getter(getter(Position::longitude)).setter(setter(Builder::longitude))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("longitude").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ELEVATION_FIELD,
            ELEVATION_REFERENCE_FIELD, ELEVATION_UNIT_FIELD, LATITUDE_FIELD, LONGITUDE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Double elevation;

    private final String elevationReference;

    private final String elevationUnit;

    private final Double latitude;

    private final Double longitude;

    private Position(BuilderImpl builder) {
        this.elevation = builder.elevation;
        this.elevationReference = builder.elevationReference;
        this.elevationUnit = builder.elevationUnit;
        this.latitude = builder.latitude;
        this.longitude = builder.longitude;
    }

    /**
     * <p>
     * The elevation of the equipment at this position.
     * </p>
     * 
     * @return The elevation of the equipment at this position.
     */
    public final Double elevation() {
        return elevation;
    }

    /**
     * <p>
     * The reference point from which elevation is reported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #elevationReference} will return {@link ElevationReference#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #elevationReferenceAsString}.
     * </p>
     * 
     * @return The reference point from which elevation is reported.
     * @see ElevationReference
     */
    public final ElevationReference elevationReference() {
        return ElevationReference.fromValue(elevationReference);
    }

    /**
     * <p>
     * The reference point from which elevation is reported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #elevationReference} will return {@link ElevationReference#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #elevationReferenceAsString}.
     * </p>
     * 
     * @return The reference point from which elevation is reported.
     * @see ElevationReference
     */
    public final String elevationReferenceAsString() {
        return elevationReference;
    }

    /**
     * <p>
     * The units used to measure the elevation of the position.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #elevationUnit}
     * will return {@link ElevationUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #elevationUnitAsString}.
     * </p>
     * 
     * @return The units used to measure the elevation of the position.
     * @see ElevationUnit
     */
    public final ElevationUnit elevationUnit() {
        return ElevationUnit.fromValue(elevationUnit);
    }

    /**
     * <p>
     * The units used to measure the elevation of the position.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #elevationUnit}
     * will return {@link ElevationUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #elevationUnitAsString}.
     * </p>
     * 
     * @return The units used to measure the elevation of the position.
     * @see ElevationUnit
     */
    public final String elevationUnitAsString() {
        return elevationUnit;
    }

    /**
     * <p>
     * The latitude of the position.
     * </p>
     * 
     * @return The latitude of the position.
     */
    public final Double latitude() {
        return latitude;
    }

    /**
     * <p>
     * The longitude of the position.
     * </p>
     * 
     * @return The longitude of the position.
     */
    public final Double longitude() {
        return longitude;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(elevation());
        hashCode = 31 * hashCode + Objects.hashCode(elevationReferenceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(elevationUnitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(latitude());
        hashCode = 31 * hashCode + Objects.hashCode(longitude());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Position)) {
            return false;
        }
        Position other = (Position) obj;
        return Objects.equals(elevation(), other.elevation())
                && Objects.equals(elevationReferenceAsString(), other.elevationReferenceAsString())
                && Objects.equals(elevationUnitAsString(), other.elevationUnitAsString())
                && Objects.equals(latitude(), other.latitude()) && Objects.equals(longitude(), other.longitude());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Position").add("Elevation", elevation()).add("ElevationReference", elevationReferenceAsString())
                .add("ElevationUnit", elevationUnitAsString()).add("Latitude", latitude()).add("Longitude", longitude()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "elevation":
            return Optional.ofNullable(clazz.cast(elevation()));
        case "elevationReference":
            return Optional.ofNullable(clazz.cast(elevationReferenceAsString()));
        case "elevationUnit":
            return Optional.ofNullable(clazz.cast(elevationUnitAsString()));
        case "latitude":
            return Optional.ofNullable(clazz.cast(latitude()));
        case "longitude":
            return Optional.ofNullable(clazz.cast(longitude()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("elevation", ELEVATION_FIELD);
        map.put("elevationReference", ELEVATION_REFERENCE_FIELD);
        map.put("elevationUnit", ELEVATION_UNIT_FIELD);
        map.put("latitude", LATITUDE_FIELD);
        map.put("longitude", LONGITUDE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Position, T> g) {
        return obj -> g.apply((Position) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Position> {
        /**
         * <p>
         * The elevation of the equipment at this position.
         * </p>
         * 
         * @param elevation
         *        The elevation of the equipment at this position.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elevation(Double elevation);

        /**
         * <p>
         * The reference point from which elevation is reported.
         * </p>
         * 
         * @param elevationReference
         *        The reference point from which elevation is reported.
         * @see ElevationReference
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ElevationReference
         */
        Builder elevationReference(String elevationReference);

        /**
         * <p>
         * The reference point from which elevation is reported.
         * </p>
         * 
         * @param elevationReference
         *        The reference point from which elevation is reported.
         * @see ElevationReference
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ElevationReference
         */
        Builder elevationReference(ElevationReference elevationReference);

        /**
         * <p>
         * The units used to measure the elevation of the position.
         * </p>
         * 
         * @param elevationUnit
         *        The units used to measure the elevation of the position.
         * @see ElevationUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ElevationUnit
         */
        Builder elevationUnit(String elevationUnit);

        /**
         * <p>
         * The units used to measure the elevation of the position.
         * </p>
         * 
         * @param elevationUnit
         *        The units used to measure the elevation of the position.
         * @see ElevationUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ElevationUnit
         */
        Builder elevationUnit(ElevationUnit elevationUnit);

        /**
         * <p>
         * The latitude of the position.
         * </p>
         * 
         * @param latitude
         *        The latitude of the position.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latitude(Double latitude);

        /**
         * <p>
         * The longitude of the position.
         * </p>
         * 
         * @param longitude
         *        The longitude of the position.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder longitude(Double longitude);
    }

    static final class BuilderImpl implements Builder {
        private Double elevation;

        private String elevationReference;

        private String elevationUnit;

        private Double latitude;

        private Double longitude;

        private BuilderImpl() {
        }

        private BuilderImpl(Position model) {
            elevation(model.elevation);
            elevationReference(model.elevationReference);
            elevationUnit(model.elevationUnit);
            latitude(model.latitude);
            longitude(model.longitude);
        }

        public final Double getElevation() {
            return elevation;
        }

        public final void setElevation(Double elevation) {
            this.elevation = elevation;
        }

        @Override
        public final Builder elevation(Double elevation) {
            this.elevation = elevation;
            return this;
        }

        public final String getElevationReference() {
            return elevationReference;
        }

        public final void setElevationReference(String elevationReference) {
            this.elevationReference = elevationReference;
        }

        @Override
        public final Builder elevationReference(String elevationReference) {
            this.elevationReference = elevationReference;
            return this;
        }

        @Override
        public final Builder elevationReference(ElevationReference elevationReference) {
            this.elevationReference(elevationReference == null ? null : elevationReference.toString());
            return this;
        }

        public final String getElevationUnit() {
            return elevationUnit;
        }

        public final void setElevationUnit(String elevationUnit) {
            this.elevationUnit = elevationUnit;
        }

        @Override
        public final Builder elevationUnit(String elevationUnit) {
            this.elevationUnit = elevationUnit;
            return this;
        }

        @Override
        public final Builder elevationUnit(ElevationUnit elevationUnit) {
            this.elevationUnit(elevationUnit == null ? null : elevationUnit.toString());
            return this;
        }

        public final Double getLatitude() {
            return latitude;
        }

        public final void setLatitude(Double latitude) {
            this.latitude = latitude;
        }

        @Override
        public final Builder latitude(Double latitude) {
            this.latitude = latitude;
            return this;
        }

        public final Double getLongitude() {
            return longitude;
        }

        public final void setLongitude(Double longitude) {
            this.longitude = longitude;
        }

        @Override
        public final Builder longitude(Double longitude) {
            this.longitude = longitude;
            return this;
        }

        @Override
        public Position build() {
            return new Position(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
