/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.privatenetworks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfigureAccessPointRequest extends PrivateNetworksRequest implements
        ToCopyableBuilder<ConfigureAccessPointRequest.Builder, ConfigureAccessPointRequest> {
    private static final SdkField<String> ACCESS_POINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accessPointArn").getter(getter(ConfigureAccessPointRequest::accessPointArn))
            .setter(setter(Builder::accessPointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessPointArn").build()).build();

    private static final SdkField<String> CPI_SECRET_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("cpiSecretKey").getter(getter(ConfigureAccessPointRequest::cpiSecretKey))
            .setter(setter(Builder::cpiSecretKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpiSecretKey").build()).build();

    private static final SdkField<String> CPI_USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("cpiUserId").getter(getter(ConfigureAccessPointRequest::cpiUserId)).setter(setter(Builder::cpiUserId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpiUserId").build()).build();

    private static final SdkField<String> CPI_USER_PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("cpiUserPassword").getter(getter(ConfigureAccessPointRequest::cpiUserPassword))
            .setter(setter(Builder::cpiUserPassword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpiUserPassword").build()).build();

    private static final SdkField<String> CPI_USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("cpiUsername").getter(getter(ConfigureAccessPointRequest::cpiUsername))
            .setter(setter(Builder::cpiUsername))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpiUsername").build()).build();

    private static final SdkField<Position> POSITION_FIELD = SdkField.<Position> builder(MarshallingType.SDK_POJO)
            .memberName("position").getter(getter(ConfigureAccessPointRequest::position)).setter(setter(Builder::position))
            .constructor(Position::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("position").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_POINT_ARN_FIELD,
            CPI_SECRET_KEY_FIELD, CPI_USER_ID_FIELD, CPI_USER_PASSWORD_FIELD, CPI_USERNAME_FIELD, POSITION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String accessPointArn;

    private final String cpiSecretKey;

    private final String cpiUserId;

    private final String cpiUserPassword;

    private final String cpiUsername;

    private final Position position;

    private ConfigureAccessPointRequest(BuilderImpl builder) {
        super(builder);
        this.accessPointArn = builder.accessPointArn;
        this.cpiSecretKey = builder.cpiSecretKey;
        this.cpiUserId = builder.cpiUserId;
        this.cpiUserPassword = builder.cpiUserPassword;
        this.cpiUsername = builder.cpiUsername;
        this.position = builder.position;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the network resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the network resource.
     */
    public final String accessPointArn() {
        return accessPointArn;
    }

    /**
     * <p>
     * A Base64 encoded string of the CPI certificate associated with the CPI user who is certifying the coordinates of
     * the network resource.
     * </p>
     * 
     * @return A Base64 encoded string of the CPI certificate associated with the CPI user who is certifying the
     *         coordinates of the network resource.
     */
    public final String cpiSecretKey() {
        return cpiSecretKey;
    }

    /**
     * <p>
     * The CPI user ID of the CPI user who is certifying the coordinates of the network resource.
     * </p>
     * 
     * @return The CPI user ID of the CPI user who is certifying the coordinates of the network resource.
     */
    public final String cpiUserId() {
        return cpiUserId;
    }

    /**
     * <p>
     * The CPI password associated with the CPI certificate in <code>cpiSecretKey</code>.
     * </p>
     * 
     * @return The CPI password associated with the CPI certificate in <code>cpiSecretKey</code>.
     */
    public final String cpiUserPassword() {
        return cpiUserPassword;
    }

    /**
     * <p>
     * The CPI user name of the CPI user who is certifying the coordinates of the radio unit.
     * </p>
     * 
     * @return The CPI user name of the CPI user who is certifying the coordinates of the radio unit.
     */
    public final String cpiUsername() {
        return cpiUsername;
    }

    /**
     * <p>
     * The position of the network resource.
     * </p>
     * 
     * @return The position of the network resource.
     */
    public final Position position() {
        return position;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accessPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(cpiSecretKey());
        hashCode = 31 * hashCode + Objects.hashCode(cpiUserId());
        hashCode = 31 * hashCode + Objects.hashCode(cpiUserPassword());
        hashCode = 31 * hashCode + Objects.hashCode(cpiUsername());
        hashCode = 31 * hashCode + Objects.hashCode(position());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigureAccessPointRequest)) {
            return false;
        }
        ConfigureAccessPointRequest other = (ConfigureAccessPointRequest) obj;
        return Objects.equals(accessPointArn(), other.accessPointArn()) && Objects.equals(cpiSecretKey(), other.cpiSecretKey())
                && Objects.equals(cpiUserId(), other.cpiUserId()) && Objects.equals(cpiUserPassword(), other.cpiUserPassword())
                && Objects.equals(cpiUsername(), other.cpiUsername()) && Objects.equals(position(), other.position());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConfigureAccessPointRequest").add("AccessPointArn", accessPointArn())
                .add("CpiSecretKey", cpiSecretKey() == null ? null : "*** Sensitive Data Redacted ***")
                .add("CpiUserId", cpiUserId() == null ? null : "*** Sensitive Data Redacted ***")
                .add("CpiUserPassword", cpiUserPassword() == null ? null : "*** Sensitive Data Redacted ***")
                .add("CpiUsername", cpiUsername() == null ? null : "*** Sensitive Data Redacted ***").add("Position", position())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accessPointArn":
            return Optional.ofNullable(clazz.cast(accessPointArn()));
        case "cpiSecretKey":
            return Optional.ofNullable(clazz.cast(cpiSecretKey()));
        case "cpiUserId":
            return Optional.ofNullable(clazz.cast(cpiUserId()));
        case "cpiUserPassword":
            return Optional.ofNullable(clazz.cast(cpiUserPassword()));
        case "cpiUsername":
            return Optional.ofNullable(clazz.cast(cpiUsername()));
        case "position":
            return Optional.ofNullable(clazz.cast(position()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("accessPointArn", ACCESS_POINT_ARN_FIELD);
        map.put("cpiSecretKey", CPI_SECRET_KEY_FIELD);
        map.put("cpiUserId", CPI_USER_ID_FIELD);
        map.put("cpiUserPassword", CPI_USER_PASSWORD_FIELD);
        map.put("cpiUsername", CPI_USERNAME_FIELD);
        map.put("position", POSITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConfigureAccessPointRequest, T> g) {
        return obj -> g.apply((ConfigureAccessPointRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PrivateNetworksRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ConfigureAccessPointRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the network resource.
         * </p>
         * 
         * @param accessPointArn
         *        The Amazon Resource Name (ARN) of the network resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessPointArn(String accessPointArn);

        /**
         * <p>
         * A Base64 encoded string of the CPI certificate associated with the CPI user who is certifying the coordinates
         * of the network resource.
         * </p>
         * 
         * @param cpiSecretKey
         *        A Base64 encoded string of the CPI certificate associated with the CPI user who is certifying the
         *        coordinates of the network resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cpiSecretKey(String cpiSecretKey);

        /**
         * <p>
         * The CPI user ID of the CPI user who is certifying the coordinates of the network resource.
         * </p>
         * 
         * @param cpiUserId
         *        The CPI user ID of the CPI user who is certifying the coordinates of the network resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cpiUserId(String cpiUserId);

        /**
         * <p>
         * The CPI password associated with the CPI certificate in <code>cpiSecretKey</code>.
         * </p>
         * 
         * @param cpiUserPassword
         *        The CPI password associated with the CPI certificate in <code>cpiSecretKey</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cpiUserPassword(String cpiUserPassword);

        /**
         * <p>
         * The CPI user name of the CPI user who is certifying the coordinates of the radio unit.
         * </p>
         * 
         * @param cpiUsername
         *        The CPI user name of the CPI user who is certifying the coordinates of the radio unit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cpiUsername(String cpiUsername);

        /**
         * <p>
         * The position of the network resource.
         * </p>
         * 
         * @param position
         *        The position of the network resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder position(Position position);

        /**
         * <p>
         * The position of the network resource.
         * </p>
         * This is a convenience method that creates an instance of the {@link Position.Builder} avoiding the need to
         * create one manually via {@link Position#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Position.Builder#build()} is called immediately and its result is
         * passed to {@link #position(Position)}.
         * 
         * @param position
         *        a consumer that will call methods on {@link Position.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #position(Position)
         */
        default Builder position(Consumer<Position.Builder> position) {
            return position(Position.builder().applyMutation(position).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PrivateNetworksRequest.BuilderImpl implements Builder {
        private String accessPointArn;

        private String cpiSecretKey;

        private String cpiUserId;

        private String cpiUserPassword;

        private String cpiUsername;

        private Position position;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigureAccessPointRequest model) {
            super(model);
            accessPointArn(model.accessPointArn);
            cpiSecretKey(model.cpiSecretKey);
            cpiUserId(model.cpiUserId);
            cpiUserPassword(model.cpiUserPassword);
            cpiUsername(model.cpiUsername);
            position(model.position);
        }

        public final String getAccessPointArn() {
            return accessPointArn;
        }

        public final void setAccessPointArn(String accessPointArn) {
            this.accessPointArn = accessPointArn;
        }

        @Override
        public final Builder accessPointArn(String accessPointArn) {
            this.accessPointArn = accessPointArn;
            return this;
        }

        public final String getCpiSecretKey() {
            return cpiSecretKey;
        }

        public final void setCpiSecretKey(String cpiSecretKey) {
            this.cpiSecretKey = cpiSecretKey;
        }

        @Override
        public final Builder cpiSecretKey(String cpiSecretKey) {
            this.cpiSecretKey = cpiSecretKey;
            return this;
        }

        public final String getCpiUserId() {
            return cpiUserId;
        }

        public final void setCpiUserId(String cpiUserId) {
            this.cpiUserId = cpiUserId;
        }

        @Override
        public final Builder cpiUserId(String cpiUserId) {
            this.cpiUserId = cpiUserId;
            return this;
        }

        public final String getCpiUserPassword() {
            return cpiUserPassword;
        }

        public final void setCpiUserPassword(String cpiUserPassword) {
            this.cpiUserPassword = cpiUserPassword;
        }

        @Override
        public final Builder cpiUserPassword(String cpiUserPassword) {
            this.cpiUserPassword = cpiUserPassword;
            return this;
        }

        public final String getCpiUsername() {
            return cpiUsername;
        }

        public final void setCpiUsername(String cpiUsername) {
            this.cpiUsername = cpiUsername;
        }

        @Override
        public final Builder cpiUsername(String cpiUsername) {
            this.cpiUsername = cpiUsername;
            return this;
        }

        public final Position.Builder getPosition() {
            return position != null ? position.toBuilder() : null;
        }

        public final void setPosition(Position.BuilderImpl position) {
            this.position = position != null ? position.build() : null;
        }

        @Override
        public final Builder position(Position position) {
            this.position = position;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ConfigureAccessPointRequest build() {
            return new ConfigureAccessPointRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
