/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.privatenetworks.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Shows the duration, the date and time that the contract started and ends, and the renewal status of the commitment
 * period for the radio unit.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CommitmentInformation implements SdkPojo, Serializable,
        ToCopyableBuilder<CommitmentInformation.Builder, CommitmentInformation> {
    private static final SdkField<CommitmentConfiguration> COMMITMENT_CONFIGURATION_FIELD = SdkField
            .<CommitmentConfiguration> builder(MarshallingType.SDK_POJO).memberName("commitmentConfiguration")
            .getter(getter(CommitmentInformation::commitmentConfiguration)).setter(setter(Builder::commitmentConfiguration))
            .constructor(CommitmentConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commitmentConfiguration").build())
            .build();

    private static final SdkField<Instant> EXPIRES_ON_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("expiresOn")
            .getter(getter(CommitmentInformation::expiresOn))
            .setter(setter(Builder::expiresOn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expiresOn").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> START_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("startAt")
            .getter(getter(CommitmentInformation::startAt))
            .setter(setter(Builder::startAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            COMMITMENT_CONFIGURATION_FIELD, EXPIRES_ON_FIELD, START_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final CommitmentConfiguration commitmentConfiguration;

    private final Instant expiresOn;

    private final Instant startAt;

    private CommitmentInformation(BuilderImpl builder) {
        this.commitmentConfiguration = builder.commitmentConfiguration;
        this.expiresOn = builder.expiresOn;
        this.startAt = builder.startAt;
    }

    /**
     * <p>
     * The duration and renewal status of the commitment period for the radio unit.
     * </p>
     * 
     * @return The duration and renewal status of the commitment period for the radio unit.
     */
    public final CommitmentConfiguration commitmentConfiguration() {
        return commitmentConfiguration;
    }

    /**
     * <p>
     * The date and time that the commitment period ends. If you do not cancel or renew the commitment before the
     * expiration date, you will be billed at the 60-day-commitment rate.
     * </p>
     * 
     * @return The date and time that the commitment period ends. If you do not cancel or renew the commitment before
     *         the expiration date, you will be billed at the 60-day-commitment rate.
     */
    public final Instant expiresOn() {
        return expiresOn;
    }

    /**
     * <p>
     * The date and time that the commitment period started.
     * </p>
     * 
     * @return The date and time that the commitment period started.
     */
    public final Instant startAt() {
        return startAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(commitmentConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(expiresOn());
        hashCode = 31 * hashCode + Objects.hashCode(startAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CommitmentInformation)) {
            return false;
        }
        CommitmentInformation other = (CommitmentInformation) obj;
        return Objects.equals(commitmentConfiguration(), other.commitmentConfiguration())
                && Objects.equals(expiresOn(), other.expiresOn()) && Objects.equals(startAt(), other.startAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CommitmentInformation").add("CommitmentConfiguration", commitmentConfiguration())
                .add("ExpiresOn", expiresOn()).add("StartAt", startAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "commitmentConfiguration":
            return Optional.ofNullable(clazz.cast(commitmentConfiguration()));
        case "expiresOn":
            return Optional.ofNullable(clazz.cast(expiresOn()));
        case "startAt":
            return Optional.ofNullable(clazz.cast(startAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("commitmentConfiguration", COMMITMENT_CONFIGURATION_FIELD);
        map.put("expiresOn", EXPIRES_ON_FIELD);
        map.put("startAt", START_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CommitmentInformation, T> g) {
        return obj -> g.apply((CommitmentInformation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CommitmentInformation> {
        /**
         * <p>
         * The duration and renewal status of the commitment period for the radio unit.
         * </p>
         * 
         * @param commitmentConfiguration
         *        The duration and renewal status of the commitment period for the radio unit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commitmentConfiguration(CommitmentConfiguration commitmentConfiguration);

        /**
         * <p>
         * The duration and renewal status of the commitment period for the radio unit.
         * </p>
         * This is a convenience method that creates an instance of the {@link CommitmentConfiguration.Builder} avoiding
         * the need to create one manually via {@link CommitmentConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CommitmentConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #commitmentConfiguration(CommitmentConfiguration)}.
         * 
         * @param commitmentConfiguration
         *        a consumer that will call methods on {@link CommitmentConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #commitmentConfiguration(CommitmentConfiguration)
         */
        default Builder commitmentConfiguration(Consumer<CommitmentConfiguration.Builder> commitmentConfiguration) {
            return commitmentConfiguration(CommitmentConfiguration.builder().applyMutation(commitmentConfiguration).build());
        }

        /**
         * <p>
         * The date and time that the commitment period ends. If you do not cancel or renew the commitment before the
         * expiration date, you will be billed at the 60-day-commitment rate.
         * </p>
         * 
         * @param expiresOn
         *        The date and time that the commitment period ends. If you do not cancel or renew the commitment before
         *        the expiration date, you will be billed at the 60-day-commitment rate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiresOn(Instant expiresOn);

        /**
         * <p>
         * The date and time that the commitment period started.
         * </p>
         * 
         * @param startAt
         *        The date and time that the commitment period started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startAt(Instant startAt);
    }

    static final class BuilderImpl implements Builder {
        private CommitmentConfiguration commitmentConfiguration;

        private Instant expiresOn;

        private Instant startAt;

        private BuilderImpl() {
        }

        private BuilderImpl(CommitmentInformation model) {
            commitmentConfiguration(model.commitmentConfiguration);
            expiresOn(model.expiresOn);
            startAt(model.startAt);
        }

        public final CommitmentConfiguration.Builder getCommitmentConfiguration() {
            return commitmentConfiguration != null ? commitmentConfiguration.toBuilder() : null;
        }

        public final void setCommitmentConfiguration(CommitmentConfiguration.BuilderImpl commitmentConfiguration) {
            this.commitmentConfiguration = commitmentConfiguration != null ? commitmentConfiguration.build() : null;
        }

        @Override
        public final Builder commitmentConfiguration(CommitmentConfiguration commitmentConfiguration) {
            this.commitmentConfiguration = commitmentConfiguration;
            return this;
        }

        public final Instant getExpiresOn() {
            return expiresOn;
        }

        public final void setExpiresOn(Instant expiresOn) {
            this.expiresOn = expiresOn;
        }

        @Override
        public final Builder expiresOn(Instant expiresOn) {
            this.expiresOn = expiresOn;
            return this;
        }

        public final Instant getStartAt() {
            return startAt;
        }

        public final void setStartAt(Instant startAt) {
            this.startAt = startAt;
        }

        @Override
        public final Builder startAt(Instant startAt) {
            this.startAt = startAt;
            return this;
        }

        @Override
        public CommitmentInformation build() {
            return new CommitmentInformation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
